package net.adventurez.mixin.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.At;

import net.adventurez.entity.DragonEntity;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.fabricmc.api.EnvType;

@Environment(EnvType.CLIENT)
@Mixin(class_636.class)
public class ClientPlayerInteractionManagerMixin {

    @Shadow
    @Final
    private class_310 client;

    @Inject(method = "hasRidingInventory", at = @At(value = "HEAD"), cancellable = true)
    public void hasRidingInventoryMixin(CallbackInfoReturnable<Boolean> info) {
        if (this.client.field_1724.method_5765() && this.client.field_1724.method_5854() instanceof DragonEntity dragonEntity && dragonEntity.hasChest()) {
            info.setReturnValue(true);
        }
    }

}
