package net.adventurez.mixin.client;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import net.fabricmc.api.Environment;
import net.minecraft.class_1439;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4691;
import net.minecraft.class_9273;
import net.adventurez.access.EntityAccess;
import net.fabricmc.api.EnvType;

@Environment(EnvType.CLIENT)
@Mixin(class_4691.class)
public class IronGolemCrackFeatureRendererMixin {

    private static final Map<class_9273.class_4621, class_2960> BLACKSTONED_CRACKINESS_TO_TEXTURE = ImmutableMap.of(class_9273.class_4621.field_21082,
            class_2960.method_60654("adventurez:textures/entity/feature/iron_golem_blackstoned_low.png"), class_9273.class_4621.field_21083,
            class_2960.method_60654("adventurez:textures/entity/feature/iron_golem_blackstoned_medium.png"), class_9273.class_4621.field_21084,
            class_2960.method_60654("adventurez:textures/entity/feature/iron_golem_blackstoned_high.png"));

    @ModifyVariable(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/feature/IronGolemCrackFeatureRenderer;getContextModel()Lnet/minecraft/client/render/entity/model/EntityModel;"), ordinal = 0)
    private class_2960 renderMixin(class_2960 original, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_1439 ironGolemEntity, float f, float g, float h,
            float j, float k, float l) {
        if (ironGolemEntity.method_5841().method_12789(((EntityAccess) ironGolemEntity).getTrackedDataBoolean())) {
            return BLACKSTONED_CRACKINESS_TO_TEXTURE.get(ironGolemEntity.method_23347());
        } else {
            return original;
        }
    }

}
