package net.adventurez.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import net.adventurez.access.EntityAccess;
import net.fabricmc.api.Environment;
import net.minecraft.class_1439;
import net.minecraft.class_2960;
import net.minecraft.class_913;
import net.fabricmc.api.EnvType;

@Environment(EnvType.CLIENT)
@Mixin(class_913.class)
public class IronGolemEntityRendererMixin {

    private static final class_2960 BLACKSTONED_TEXTURE = class_2960.method_60654("adventurez:textures/entity/blackstone_golem.png");

    @Inject(method = "getTexture", at = @At("HEAD"), cancellable = true)
    private void getTextureMixin(class_1439 ironGolemEntity, CallbackInfoReturnable<class_2960> info) {
        if (ironGolemEntity.method_5841().method_12789(((EntityAccess) ironGolemEntity).getTrackedDataBoolean())) {
            info.setReturnValue(BLACKSTONED_TEXTURE);
        }
    }
}
