package net.adventurez.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.At;

import net.fabricmc.api.Environment;
import net.minecraft.class_2586;
import net.minecraft.class_2745;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.adventurez.block.entity.ShadowChestEntity;
import net.fabricmc.api.EnvType;

@Environment(EnvType.CLIENT)
@Mixin(class_4722.class)
public class TexturedRenderLayersMixin {

    private static final class_4730 SHADOW = createChestTextureId("shadow_chest");

    @Inject(method = "Lnet/minecraft/client/render/TexturedRenderLayers;getChestTextureId(Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/block/enums/ChestType;Z)Lnet/minecraft/client/util/SpriteIdentifier;", at = @At("TAIL"), cancellable = true)
    private static void getChestTextureMixin(class_2586 blockEntity, class_2745 type, boolean christmas, CallbackInfoReturnable<class_4730> info) {
        if (blockEntity instanceof ShadowChestEntity) {
            info.setReturnValue(SHADOW);
        }
    }

    @Shadow
    private static class_4730 createChestTextureId(String variant) {
        return null;
    }
}
