/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import com.google.common.collect.Lists;
import fuzs.mutantmonsters.animation.AnimatedEntity;
import fuzs.mutantmonsters.animation.Animation;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.MutantSkeletonBodyPart;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.entity.projectile.MutantArrow;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MutantSkeleton
extends AbstractMutantMonster
implements AnimatedEntity {
    public static final Animation MELEE_ANIMATION = new Animation(14);
    public static final Animation CONSTRICT_RIBS_ANIMATION = new Animation(20);
    public static final Animation SHOOT_ANIMATION = new Animation(32);
    public static final Animation MULTI_SHOT_ANIMATION = new Animation(30);
    private static final Animation[] ANIMATIONS = new Animation[]{MELEE_ANIMATION, CONSTRICT_RIBS_ANIMATION, SHOOT_ANIMATION, MULTI_SHOT_ANIMATION};
    private Animation animation = Animation.NONE;
    private int animationTick;

    public MutantSkeleton(EntityType<? extends MutantSkeleton> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        this.f_21364_ = 30;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MutantSkeleton.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22278_, 0.75);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MeleeGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new ShootGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new MultiShotGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new ConstrictRibsGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.1).setMaxAttackTick(5));
        this.f_21345_.m_25352_(2, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, WitherBoss.class));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, true));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 3.25f;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new MutantGroundPathNavigation((Mob)this, worldIn);
    }

    protected BodyRotationControl m_7560_() {
        return super.m_7560_();
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7562_() {
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.m_9236_().m_46462_() && this.f_19797_ % 100 == 0 && this.m_6084_() && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(2.0f);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.isAnimationPlaying()) {
            this.animation = this.f_19796_.m_188503_(4) != 0 ? MELEE_ANIMATION : CONSTRICT_RIBS_ANIMATION;
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return !(source.m_7639_() instanceof MutantSkeleton) && super.m_6469_(source, amount);
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_6731_(LivingEntity livingEntity) {
        livingEntity.f_19864_ = true;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().f_46443_) {
            for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(3.0, 2.0, 3.0))) {
                livingEntity.m_6469_(DamageSourcesHelper.source((LevelReader)this.m_9236_(), ModRegistry.ARMOR_BYPASSING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this), 7.0f);
            }
            for (int i = 0; i < 18; ++i) {
                int j = i;
                if (i >= 3) {
                    j = i + 1;
                }
                if (j >= 4) {
                    ++j;
                }
                if (j >= 5) {
                    ++j;
                }
                if (j >= 6) {
                    ++j;
                }
                if (j >= 9) {
                    ++j;
                }
                if (j >= 10) {
                    ++j;
                }
                if (j >= 11) {
                    ++j;
                }
                if (j >= 12) {
                    ++j;
                }
                if (j >= 15) {
                    ++j;
                }
                if (j >= 16) {
                    ++j;
                }
                if (j >= 17) {
                    ++j;
                }
                if (j >= 18) {
                    ++j;
                }
                if (j >= 20) {
                    ++j;
                }
                MutantSkeletonBodyPart part = new MutantSkeletonBodyPart(this.m_9236_(), (Mob)this, j);
                part.m_20256_(part.m_20184_().m_82520_((double)(this.f_19796_.m_188501_() * 0.8f * 2.0f - 0.8f), (double)(this.f_19796_.m_188501_() * 0.25f + 0.1f), (double)(this.f_19796_.m_188501_() * 0.8f * 2.0f - 0.8f)));
                this.m_9236_().m_7967_((Entity)part);
            }
        }
        this.f_20919_ = 19;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_SKELETON_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_SKELETON_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ENTITY_MUTANT_SKELETON_DEATH_SOUND_EVENT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ModRegistry.ENTITY_MUTANT_SKELETON_STEP_SOUND_EVENT.get(), 0.15f, 1.0f);
    }

    static class MeleeGoal
    extends AnimationGoal<MutantSkeleton> {
        public MeleeGoal(MutantSkeleton mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void m_8037_() {
            ((MutantSkeleton)this.mob).m_21573_().m_26573_();
            LivingEntity target = ((MutantSkeleton)this.mob).m_5448_();
            if (target != null && target.m_6084_()) {
                ((MutantSkeleton)this.mob).f_21365_.m_24960_((Entity)target, 30.0f, 30.0f);
            }
            if (((MutantSkeleton)this.mob).animationTick == 3) {
                float attackDamage = (float)((MutantSkeleton)this.mob).m_21133_(Attributes.f_22281_);
                for (LivingEntity livingEntity : ((MutantSkeleton)this.mob).m_9236_().m_45976_(LivingEntity.class, ((MutantSkeleton)this.mob).m_20191_().m_82400_(4.0))) {
                    if (livingEntity instanceof MutantSkeleton) continue;
                    double dist = ((MutantSkeleton)this.mob).m_20270_((Entity)livingEntity);
                    double x = ((MutantSkeleton)this.mob).m_20185_() - livingEntity.m_20185_();
                    double z = ((MutantSkeleton)this.mob).m_20189_() - livingEntity.m_20189_();
                    if (!(dist <= 3.0) || !(EntityUtil.getHeadAngle((LivingEntity)this.mob, x, z) < 60.0f)) continue;
                    float power = 1.8f + (float)((MutantSkeleton)this.mob).f_19796_.m_188503_(5) * 0.15f;
                    livingEntity.m_6469_(((MutantSkeleton)this.mob).m_9236_().m_269111_().m_269333_((LivingEntity)this.mob), attackDamage > 0.0f ? attackDamage + (float)((MutantSkeleton)this.mob).f_19796_.m_188503_(2) : 0.0f);
                    livingEntity.m_20334_(-x / dist * (double)power, Math.max((double)0.28f, livingEntity.m_20184_().f_82480_), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket((Entity)livingEntity);
                }
                ((MutantSkeleton)this.mob).m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f / (((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.4f + 1.2f));
            }
        }
    }

    static class ShootGoal
    extends AnimationGoal<MutantSkeleton> {
        public ShootGoal(MutantSkeleton mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return SHOOT_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = ((MutantSkeleton)this.mob).m_5448_();
            return target != null && !((MutantSkeleton)this.mob).isAnimationPlaying() && ((MutantSkeleton)this.mob).f_19796_.m_188503_(12) == 0 && ((MutantSkeleton)this.mob).m_20280_((Entity)target) > 4.0 && ((MutantSkeleton)this.mob).m_142582_((Entity)target);
        }

        public void m_8037_() {
            LivingEntity target = ((MutantSkeleton)this.mob).m_5448_();
            if (target != null) {
                ((MutantSkeleton)this.mob).m_21573_().m_26573_();
                ((MutantSkeleton)this.mob).f_21365_.m_24960_((Entity)target, 30.0f, 30.0f);
                if (((MutantSkeleton)this.mob).animationTick == 5) {
                    ((MutantSkeleton)this.mob).m_5496_(SoundEvents.f_11845_, 1.0f, 1.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 20) {
                    ((MutantSkeleton)this.mob).m_5496_(SoundEvents.f_11841_, 1.0f, 1.0f / (((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.5f + 1.0f) + 0.2f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 26 && target.m_6084_()) {
                    float randomization = (float)((MutantSkeleton)this.mob).f_20916_ / 2.0f;
                    if (((MutantSkeleton)this.mob).f_20916_ > 0 && ((MutantSkeleton)this.mob).f_20898_ > 0.0f && ((MutantSkeleton)this.mob).m_21225_() != null && ((MutantSkeleton)this.mob).m_21225_().m_7639_() != null) {
                        randomization = (float)((MutantSkeleton)this.mob).f_20916_ / 2.0f;
                    } else if (!((MutantSkeleton)this.mob).m_142582_((Entity)target)) {
                        randomization = 0.5f + ((MutantSkeleton)this.mob).f_19796_.m_188501_();
                    }
                    MutantArrow arrowEntity = new MutantArrow(((MutantSkeleton)this.mob).m_9236_(), (LivingEntity)this.mob);
                    arrowEntity.shoot(target, 2.4f, randomization);
                    ArrayList effects = Lists.newArrayList();
                    if (((MutantSkeleton)this.mob).f_19796_.m_188503_(4) == 0) {
                        effects.add(new MobEffectInstance(MobEffects.f_19614_, 80 + ((MutantSkeleton)this.mob).f_19796_.m_188503_(60), 0));
                    }
                    if (((MutantSkeleton)this.mob).f_19796_.m_188503_(4) == 0) {
                        effects.add(new MobEffectInstance(MobEffects.f_19612_, 120 + ((MutantSkeleton)this.mob).f_19796_.m_188503_(60), 1));
                    }
                    if (((MutantSkeleton)this.mob).f_19796_.m_188503_(4) == 0) {
                        effects.add(new MobEffectInstance(MobEffects.f_19597_, 120 + ((MutantSkeleton)this.mob).f_19796_.m_188503_(60), 1));
                    }
                    if (!effects.isEmpty()) {
                        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42738_);
                        PotionUtils.m_43552_((ItemStack)itemStack, (Collection)effects);
                        arrowEntity.m_36878_(itemStack);
                    }
                    ((MutantSkeleton)this.mob).m_9236_().m_7967_((Entity)arrowEntity);
                    ((MutantSkeleton)this.mob).m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.4f + 1.2f) + 0.25f);
                }
            }
        }
    }

    static class MultiShotGoal
    extends AnimationGoal<MutantSkeleton> {
        private final List<MutantArrow> shots = new ArrayList<MutantArrow>();

        public MultiShotGoal(MutantSkeleton mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected Animation getAnimation() {
            return MULTI_SHOT_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = ((MutantSkeleton)this.mob).m_5448_();
            return target != null && ((MutantSkeleton)this.mob).f_19797_ % 3 == 0 && !((MutantSkeleton)this.mob).isAnimationPlaying() && (((MutantSkeleton)this.mob).m_20096_() && ((MutantSkeleton)this.mob).f_19796_.m_188503_(26) == 0 && ((MutantSkeleton)this.mob).m_142582_((Entity)target) || ((MutantSkeleton)this.mob).m_20202_() == target);
        }

        public void m_8037_() {
            LivingEntity target = ((MutantSkeleton)this.mob).m_5448_();
            if (target != null) {
                ((MutantSkeleton)this.mob).m_21573_().m_26573_();
                ((MutantSkeleton)this.mob).f_21365_.m_24960_((Entity)target, 30.0f, 30.0f);
                if (((MutantSkeleton)this.mob).animationTick == 10) {
                    ((MutantSkeleton)this.mob).m_8127_();
                    double x = target.m_20185_() - ((MutantSkeleton)this.mob).m_20185_();
                    double z = target.m_20189_() - ((MutantSkeleton)this.mob).m_20189_();
                    float scale = 0.06f + ((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.03f;
                    if (((MutantSkeleton)this.mob).m_20280_((Entity)target) < 16.0) {
                        x *= -1.0;
                        z *= -1.0;
                        scale = (float)((double)scale * 5.0);
                    }
                    ((MutantSkeleton)this.mob).f_19865_ = Vec3.f_82478_;
                    ((MutantSkeleton)this.mob).m_20334_(x * (double)scale, 1.1 * (double)((MutantSkeleton)this.mob).m_20098_(), z * (double)scale);
                }
                if (((MutantSkeleton)this.mob).animationTick == 15) {
                    ((MutantSkeleton)this.mob).m_5496_(SoundEvents.f_11846_, 1.0f, 1.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 20) {
                    ((MutantSkeleton)this.mob).m_5496_(SoundEvents.f_11841_, 1.0f, 1.0f / (((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.5f + 1.0f) + 0.2f);
                }
                if (((MutantSkeleton)this.mob).animationTick >= 24 && ((MutantSkeleton)this.mob).animationTick < 28) {
                    if (!this.shots.isEmpty()) {
                        for (MutantArrow arrowEntity : this.shots) {
                            ((MutantSkeleton)this.mob).m_9236_().m_7967_((Entity)arrowEntity);
                        }
                        this.shots.clear();
                    }
                    for (int i = 0; i < 6; ++i) {
                        MutantArrow mutantArrow = new MutantArrow(((MutantSkeleton)this.mob).m_9236_(), (LivingEntity)this.mob);
                        mutantArrow.shoot(target, 2.0f - ((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.1f, 3.0f);
                        this.shots.add(mutantArrow);
                    }
                    ((MutantSkeleton)this.mob).m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.4f + 1.2f) + 0.25f);
                }
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.shots.clear();
        }
    }

    static class ConstrictRibsGoal
    extends AnimationGoal<MutantSkeleton> {
        public ConstrictRibsGoal(MutantSkeleton mob) {
            super(mob);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected Animation getAnimation() {
            return CONSTRICT_RIBS_ANIMATION;
        }

        @Override
        public boolean m_8036_() {
            return ((MutantSkeleton)this.mob).m_5448_() != null && super.m_8036_();
        }

        public void m_8037_() {
            LivingEntity target = ((MutantSkeleton)this.mob).m_5448_();
            if (target != null) {
                ((MutantSkeleton)this.mob).m_21573_().m_26573_();
                if (((MutantSkeleton)this.mob).animationTick < 6) {
                    ((MutantSkeleton)this.mob).f_21365_.m_24960_((Entity)target, 30.0f, 30.0f);
                }
                if (((MutantSkeleton)this.mob).animationTick == 5) {
                    target.m_8127_();
                }
                if (((MutantSkeleton)this.mob).animationTick == 6) {
                    float attackDamage = (float)((MutantSkeleton)this.mob).m_21133_(Attributes.f_22281_);
                    if (!target.m_6469_(((MutantSkeleton)this.mob).m_9236_().m_269111_().m_269333_((LivingEntity)this.mob), attackDamage > 0.0f ? attackDamage + 6.0f : 0.0f)) {
                        EntityUtil.disableShield(target, 100);
                    }
                    double motionX = (double)(1.0f + ((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.4f) * (double)(((MutantSkeleton)this.mob).f_19796_.m_188499_() ? 1 : -1);
                    double motionY = 0.4f + ((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.8f;
                    double motionZ = (double)(1.0f + ((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.4f) * (double)(((MutantSkeleton)this.mob).f_19796_.m_188499_() ? 1 : -1);
                    target.m_20334_(motionX, motionY, motionZ);
                    EntityUtil.sendPlayerVelocityPacket((Entity)target);
                    ((MutantSkeleton)this.mob).m_5496_(SoundEvents.f_11913_, 0.5f, 0.8f + ((MutantSkeleton)this.mob).f_19796_.m_188501_() * 0.4f);
                }
            }
        }
    }
}

