/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters;

import fuzs.mutantmonsters.config.CommonConfig;
import fuzs.mutantmonsters.config.ServerConfig;
import fuzs.mutantmonsters.handler.BiomeModificationsHandler;
import fuzs.mutantmonsters.handler.EntityEventsHandler;
import fuzs.mutantmonsters.handler.PlayerEventsHandler;
import fuzs.mutantmonsters.handler.SpawningPreventionHandler;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.ClientboundAddEntityDataMessage;
import fuzs.mutantmonsters.network.ClientboundAnimationMessage;
import fuzs.mutantmonsters.network.ClientboundMutantLevelParticlesMessage;
import fuzs.mutantmonsters.network.ClientboundSeismicWaveFluidParticlesMessage;
import fuzs.mutantmonsters.network.client.ServerboundCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.ServerboundCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesContext;
import fuzs.puzzleslib.api.core.v1.context.PayloadTypesContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1429;
import net.minecraft.class_1588;
import net.minecraft.class_2484;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_9169;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutantMonsters
implements ModConstructor {
    public static final String MOD_ID = "mutantmonsters";
    public static final String MOD_NAME = "Mutant Monsters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mutant Monsters");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"mutantmonsters").common(CommonConfig.class).server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        MutantMonsters.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        LivingHurtCallback.EVENT.register(EntityEventsHandler::onLivingHurt);
        UseItemEvents.TICK.register(PlayerEventsHandler::onItemUseTick);
        ArrowLooseCallback.EVENT.register(PlayerEventsHandler::onArrowLoose);
        PlayerInteractEvents.USE_ENTITY.register(EntityEventsHandler::onEntityInteract);
        PlayerTickEvents.END.register(PlayerEventsHandler::onEndPlayerTick);
        ServerEntityLevelEvents.LOAD.register(EntityEventsHandler::onEntityLoad);
        LivingDropsCallback.EVENT.register(EntityEventsHandler::onLivingDrops);
        ItemEntityEvents.TOSS.register(PlayerEventsHandler::onItemToss);
        ServerEntityLevelEvents.LOAD.register(SpawningPreventionHandler::onEntitySpawn);
        ExplosionEvents.DETONATE.register(MutatedExplosionHelper::onExplosionDetonate);
    }

    public void onCommonSetup() {
        class_2484.class_2485.field_46442.put(ModRegistry.MUTANT_SKELETON_SKULL_TYPE.method_15434(), ModRegistry.MUTANT_SKELETON_SKULL_TYPE);
    }

    public void onRegisterPayloadTypes(PayloadTypesContext context) {
        context.playToClient(ClientboundMutantLevelParticlesMessage.class, ClientboundMutantLevelParticlesMessage.STREAM_CODEC);
        context.playToClient(ClientboundAddEntityDataMessage.class, ClientboundAddEntityDataMessage.STREAM_CODEC);
        context.playToClient(ClientboundAnimationMessage.class, ClientboundAnimationMessage.STREAM_CODEC);
        context.playToClient(ClientboundSeismicWaveFluidParticlesMessage.class, ClientboundSeismicWaveFluidParticlesMessage.STREAM_CODEC);
        context.playToServer(ServerboundCreeperMinionTrackerMessage.class, ServerboundCreeperMinionTrackerMessage.STREAM_CODEC);
        context.playToServer(ServerboundCreeperMinionNameMessage.class, ServerboundCreeperMinionNameMessage.STREAM_CODEC);
    }

    public void onRegisterEntityAttributes(EntityAttributesContext context) {
        context.registerAttributes((class_1299)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.comp_349(), CreeperMinion.createAttributes());
        context.registerAttributes((class_1299)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.comp_349(), EndersoulClone.createAttributes());
        context.registerAttributes((class_1299)ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.comp_349(), MutantCreeper.createAttributes());
        context.registerAttributes((class_1299)ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE.comp_349(), MutantEnderman.createAttributes());
        context.registerAttributes((class_1299)ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.comp_349(), MutantSnowGolem.createAttributes());
        context.registerAttributes((class_1299)ModEntityTypes.SPIDER_PIG_ENTITY_TYPE.comp_349(), SpiderPig.createAttributes());
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike()) {
            context.registerAttributes((class_1299)ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.comp_349(), MutantSkeleton.createAttributes());
            context.registerAttributes((class_1299)ModEntityTypes.MUTANT_ZOMBIE_ENTITY_TYPE.comp_349(), MutantZombie.createAttributes());
        }
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((class_1299)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1308::method_20636);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_ENDERMAN_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, MutantEnderman::checkMutantEndermanSpawnRules);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1308::method_20636);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MUTANT_ZOMBIE_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.SPIDER_PIG_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13197, class_1429::method_20663);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        BiomeModificationsHandler.onRegisterBiomeModifications(context);
    }

    public static class_2960 id(String name) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }
}

