/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.animation;

import fuzs.mutantmonsters.client.animation.Transform;
import fuzs.mutantmonsters.client.renderer.entity.state.AnimatedEntityRenderState;
import fuzs.mutantmonsters.world.entity.animation.EntityAnimation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_3532;
import net.minecraft.class_630;

public class Animator {
    private int tempTick;
    private int prevTempTick;
    private boolean correctAnim;
    private AnimatedEntityRenderState renderState;
    private final Map<class_630, Transform> transformMap = new HashMap<class_630, Transform>();
    private final Map<class_630, Transform> prevTransformMap = new HashMap<class_630, Transform>();

    public AnimatedEntityRenderState getRenderState() {
        return this.renderState;
    }

    public void update(AnimatedEntityRenderState renderState) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = false;
        this.renderState = renderState;
        this.transformMap.clear();
        this.prevTransformMap.clear();
    }

    public boolean setAnimation(EntityAnimation animation) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = this.renderState.animation == animation;
        return this.correctAnim;
    }

    public void startPhase(int duration) {
        if (this.correctAnim) {
            this.prevTempTick = this.tempTick;
            this.tempTick += duration;
        }
    }

    public void setStationaryPhase(int duration) {
        this.startPhase(duration);
        this.endPhase(true);
    }

    public void resetPhase(int duration) {
        this.startPhase(duration);
        this.endPhase();
    }

    public void rotate(class_630 box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).getRotation().add(x, y, z);
        }
    }

    public void move(class_630 box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).getOffset().add(x, y, z);
        }
    }

    private Transform getTransform(class_630 box) {
        return this.transformMap.computeIfAbsent(box, b -> new Transform());
    }

    public void endPhase() {
        this.endPhase(false);
    }

    private void endPhase(boolean stationary) {
        if (this.correctAnim) {
            float animTick = this.renderState.animationTime;
            if (animTick >= (float)this.prevTempTick && animTick < (float)this.tempTick) {
                if (stationary) {
                    for (class_630 modelPart : this.prevTransformMap.keySet()) {
                        Transform transform = this.prevTransformMap.get(modelPart);
                        transform.rotate(modelPart, 1.0f);
                        transform.offset(modelPart, 1.0f);
                    }
                } else {
                    Transform transform;
                    class_630 model;
                    class_630 modelPart;
                    float tick = (animTick - (float)this.prevTempTick) / (float)(this.tempTick - this.prevTempTick);
                    float inc = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
                    float dec = 1.0f - inc;
                    Iterator<class_630> iterator = this.prevTransformMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        model = modelPart = iterator.next();
                        transform = this.prevTransformMap.get(model);
                        transform.rotate(model, dec);
                        transform.offset(model, dec);
                    }
                    iterator = this.transformMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        model = modelPart = iterator.next();
                        transform = this.transformMap.get(model);
                        transform.rotate(model, inc);
                        transform.offset(model, inc);
                    }
                }
            }
            if (!stationary) {
                this.prevTransformMap.clear();
                this.prevTransformMap.putAll(this.transformMap);
                this.transformMap.clear();
            }
        }
    }

    public static void addRotationAngle(class_630 modelPart, float x, float y, float z) {
        modelPart.field_3654 += x;
        modelPart.field_3675 += y;
        modelPart.field_3674 += z;
    }

    public static void setScale(class_630 modelPart, float scale) {
        modelPart.field_37939 = modelPart.field_37940 = scale;
        modelPart.field_37938 = modelPart.field_37940;
    }
}

