/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.gui.screens;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.network.client.ServerboundCreeperMinionNameMessage;
import fuzs.mutantmonsters.network.client.ServerboundCreeperMinionTrackerMessage;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

public class CreeperMinionTrackerScreen
extends class_437 {
    public static final class_2960 TEXTURE_LOCATION = MutantMonsters.id("textures/gui/creeper_minion_tracker.png");
    public static final class_2561 HEALTH_COMPONENT = CreeperMinionTrackerScreen.createComponent("health");
    public static final class_2561 EXPLOSION_COMPONENT = CreeperMinionTrackerScreen.createComponent("explosion");
    public static final class_2561 BLAST_RADIUS_COMPONENT = CreeperMinionTrackerScreen.createComponent("blast_radius");
    public static final class_2561 CONTINUOUS_EXPLOSION_COMPONENT = CreeperMinionTrackerScreen.createComponent("explosion.continuous");
    public static final class_2561 ONE_TIME_EXPLOSION_COMPONENT = CreeperMinionTrackerScreen.createComponent("explosion.one_time");
    public static final class_2561 SHOW_NAME_COMPONENT = CreeperMinionTrackerScreen.createComponent("show_name");
    public static final class_2561 DESTROY_BLOCKS_COMPONENT = CreeperMinionTrackerScreen.createComponent("destroys_blocks");
    public static final class_2561 RIDE_ON_SHOULDER_COMPONENT = CreeperMinionTrackerScreen.createComponent("ride_on_shoulder");
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("0.0"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private final CreeperMinion creeperMinion;
    private int leftPos;
    private int topPos;
    private class_342 name;
    private boolean canRideOnShoulder;
    private boolean canDestroyBlocks;
    private boolean alwaysShowName;
    private int titleLabelX;
    private int titleLabelY;

    public CreeperMinionTrackerScreen(CreeperMinion creeperMinion) {
        super(creeperMinion.method_5864().method_5897());
        this.creeperMinion = creeperMinion;
    }

    static class_2561 createComponent(String translationKey) {
        return class_2561.method_43471((String)("gui.mutantmonsters.creeper_minion_tracker." + translationKey));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, -12566464, false);
        this.name.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51439(this.field_22793, HEALTH_COMPONENT, this.leftPos + 13, this.topPos + 31, -12566464, false);
        guiGraphics.method_51439(this.field_22793, EXPLOSION_COMPONENT, this.leftPos + 13, this.topPos + 51, -12566464, false);
        guiGraphics.method_51439(this.field_22793, BLAST_RADIUS_COMPONENT, this.leftPos + 13, this.topPos + 71, -12566464, false);
        guiGraphics.method_25300(this.field_22793, String.format("%s / %s", DECIMAL_FORMAT.format(this.creeperMinion.method_6032()), DECIMAL_FORMAT.format(this.creeperMinion.method_6063())), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 31, -1);
        guiGraphics.method_27534(this.field_22793, this.creeperMinion.canExplodeContinuously() ? CONTINUOUS_EXPLOSION_COMPONENT : ONE_TIME_EXPLOSION_COMPONENT, this.leftPos + this.imageWidth / 2 + 38, this.topPos + 51, -1);
        guiGraphics.method_25300(this.field_22793, DECIMAL_FORMAT.format(this.creeperMinion.getExplosionRadius()), this.leftPos + this.imageWidth / 2 + 38, this.topPos + 71, -1);
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.method_74231() && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return this.name.method_25404(keyEvent) || this.name.method_20315() || super.method_25404(keyEvent);
    }

    protected void method_25426() {
        this.canDestroyBlocks = this.creeperMinion.canDestroyBlocks();
        this.alwaysShowName = this.creeperMinion.method_5807();
        this.canRideOnShoulder = this.creeperMinion.canRideOnShoulder();
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.name = new class_342(this.field_22793, this.leftPos + 5, this.topPos - 24, this.imageHeight, 20, (class_2561)class_2561.method_43473());
        this.name.method_1868(-1);
        this.name.method_1860(-1);
        this.name.method_1880(50);
        this.name.method_1863(this::onNameChanged);
        this.name.method_1852(this.creeperMinion.method_5477().getString());
        this.method_25429((class_364)this.name);
        int buttonWidth = this.imageWidth / 2 - 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)CreeperMinionTrackerScreen.onOffComponent(DESTROY_BLOCKS_COMPONENT, this.canDestroyBlocks), button -> {
            this.canDestroyBlocks = !this.canDestroyBlocks;
            MessageSender.broadcast((Message)new ServerboundCreeperMinionTrackerMessage(this.creeperMinion.method_5628(), ServerboundCreeperMinionTrackerMessage.DataType.CAN_DESTROY_BLOCKS, this.canDestroyBlocks));
            button.method_25355(CreeperMinionTrackerScreen.onOffComponent(DESTROY_BLOCKS_COMPONENT, this.canDestroyBlocks));
        }).method_46434(this.leftPos + 8, this.topPos + this.imageHeight - 75, buttonWidth * 2 + 4, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)CreeperMinionTrackerScreen.onOffComponent(SHOW_NAME_COMPONENT, this.alwaysShowName), button -> {
            this.alwaysShowName = !this.alwaysShowName;
            MessageSender.broadcast((Message)new ServerboundCreeperMinionTrackerMessage(this.creeperMinion.method_5628(), ServerboundCreeperMinionTrackerMessage.DataType.IS_CUSTOM_NAME_VISIBLE, this.alwaysShowName));
            button.method_25355(CreeperMinionTrackerScreen.onOffComponent(SHOW_NAME_COMPONENT, this.alwaysShowName));
        }).method_46434(this.leftPos + 8, this.topPos + this.imageHeight - 51, buttonWidth * 2 + 4, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)CreeperMinionTrackerScreen.onOffComponent(RIDE_ON_SHOULDER_COMPONENT, this.canRideOnShoulder), button -> {
            this.canRideOnShoulder = !this.canRideOnShoulder;
            MessageSender.broadcast((Message)new ServerboundCreeperMinionTrackerMessage(this.creeperMinion.method_5628(), ServerboundCreeperMinionTrackerMessage.DataType.CAN_RIDE_ON_SHOULDER, this.canRideOnShoulder));
            button.method_25355(CreeperMinionTrackerScreen.onOffComponent(RIDE_ON_SHOULDER_COMPONENT, this.canRideOnShoulder));
        }).method_46434(this.leftPos + 8, this.topPos + this.imageHeight - 27, buttonWidth * 2 + 4, 20).method_46431());
        if (!this.creeperMinion.method_6171((class_1309)this.field_22787.field_1724)) {
            this.field_33816.stream().filter(class_339.class::isInstance).map(class_339.class::cast).forEach(widget -> {
                widget.field_22763 = false;
            });
        }
        this.titleLabelX = (this.imageWidth - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        this.titleLabelY = 6;
    }

    public void method_25393() {
        if (!this.creeperMinion.method_5805()) {
            this.field_22787.field_1724.method_7346();
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_25290(class_10799.field_56883, TEXTURE_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        guiGraphics.method_25290(class_10799.field_56883, TEXTURE_LOCATION, this.leftPos + 15, this.topPos + 16, 0.0f, 166.0f, 146, 5, 256, 256);
        float healthProgress = class_3532.method_15363((float)(this.creeperMinion.method_6032() / this.creeperMinion.method_6063()), (float)0.0f, (float)1.0f);
        guiGraphics.method_25290(class_10799.field_56883, TEXTURE_LOCATION, this.leftPos + 15, this.topPos + 16, 0.0f, 171.0f, (int)(healthProgress * 146.0f), 5, 256, 256);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String string = this.name.method_1882();
        this.method_25423(minecraft, width, height);
        this.name.method_1852(string);
    }

    private void onNameChanged(String input) {
        if (!(input = input.trim()).equals(this.creeperMinion.method_5477().getString())) {
            this.creeperMinion.method_5665((class_2561)class_2561.method_43470((String)input));
            MessageSender.broadcast((Message)new ServerboundCreeperMinionNameMessage(this.creeperMinion.method_5628(), input));
        }
    }

    private static class_2561 onOffComponent(class_2561 component, boolean on) {
        return class_2561.method_43473().method_10852(component).method_27693(": ").method_10852(on ? class_5244.field_24332 : class_5244.field_24333);
    }
}

