/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantSkeletonRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import net.minecraft.class_1306;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class MutantSkeletonModel
extends class_583<MutantSkeletonRenderState> {
    private final Animator animator = new Animator();
    private final class_630 skeleBase;
    private final class_630 pelvis;
    private final class_630 waist;
    private final Spine[] spine = new Spine[3];
    private final class_630 neck;
    private final class_630 head;
    private final class_630 innerhead;
    private final class_630 jaw;
    private final class_630 shoulder1;
    private final class_630 shoulder2;
    private final class_630 arm1;
    private final class_630 innerarm1;
    private final class_630 arm2;
    private final class_630 innerarm2;
    private final class_630 forearm1;
    private final class_630 innerforearm1;
    private final class_630 forearm2;
    private final class_630 innerforearm2;
    private final class_630 leg1;
    private final class_630 innerleg1;
    private final class_630 leg2;
    private final class_630 innerleg2;
    private final class_630 foreleg1;
    private final class_630 innerforeleg1;
    private final class_630 foreleg2;
    private final class_630 innerforeleg2;

    public MutantSkeletonModel(class_630 modelPart) {
        super(modelPart);
        this.skeleBase = modelPart.method_32086("base");
        this.pelvis = this.skeleBase.method_32086("pelvis");
        modelPart = this.waist = this.pelvis.method_32086("waist");
        for (int i = 0; i < 3; ++i) {
            this.spine[i] = new Spine(modelPart, "" + (i + 1));
            modelPart = this.spine[i].middle;
        }
        this.neck = modelPart.method_32086("neck");
        this.head = this.neck.method_32086("head");
        this.innerhead = this.head.method_32086("inner_head");
        this.jaw = this.innerhead.method_32086("jaw");
        this.shoulder1 = modelPart.method_32086("shoulder1");
        this.shoulder2 = modelPart.method_32086("shoulder2");
        this.arm1 = this.shoulder1.method_32086("arm1");
        this.innerarm1 = this.arm1.method_32086("inner_arm1");
        this.arm2 = this.shoulder2.method_32086("arm2");
        this.innerarm2 = this.arm2.method_32086("inner_arm2");
        this.forearm1 = this.innerarm1.method_32086("fore_arm1");
        this.innerforearm1 = this.forearm1.method_32086("inner_fore_arm1");
        this.forearm2 = this.innerarm2.method_32086("fore_arm2");
        this.innerforearm2 = this.forearm2.method_32086("inner_fore_arm2");
        this.leg1 = this.pelvis.method_32086("leg1");
        this.innerleg1 = this.leg1.method_32086("inner_leg1");
        this.leg2 = this.pelvis.method_32086("leg2");
        this.innerleg2 = this.leg2.method_32086("inner_leg2");
        this.foreleg1 = this.innerleg1.method_32086("fore_leg1");
        this.innerforeleg1 = this.foreleg1.method_32086("inner_fore_leg1");
        this.foreleg2 = this.innerleg2.method_32086("fore_leg2");
        this.innerforeleg2 = this.foreleg2.method_32086("inner_fore_leg2");
    }

    public static class_5607 createBodyLayer() {
        class_5610 waist;
        class_5609 mesh = new class_5609();
        class_5610 root = mesh.method_32111();
        class_5610 base = root.method_32117("base", class_5606.method_32108().method_32101(0, 0), class_5603.method_32090((float)0.0f, (float)3.0f, (float)0.0f));
        class_5610 pelvis = base.method_32117("pelvis", class_5606.method_32108().method_32101(0, 16).method_32097(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f), class_5603.field_27701);
        class_5610 middle = waist = pelvis.method_32117("waist", class_5606.method_32108().method_32101(32, 0).method_32097(-2.5f, -8.0f, -2.0f, 5.0f, 8.0f, 4.0f), class_5603.method_32090((float)0.0f, (float)-5.0f, (float)0.0f));
        for (int i = 0; i < 3; ++i) {
            Spine.createSpineLayer(middle, i);
            middle = middle.method_32116("middle" + (i + 1));
        }
        class_5610 neck = middle.method_32117("neck", class_5606.method_32108().method_32101(64, 0).method_32097(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f), class_5603.method_32090((float)0.0f, (float)-4.0f, (float)0.0f));
        class_5610 head = neck.method_32117("head", class_5606.method_32108().method_32101(0, 0), class_5603.method_32090((float)0.0f, (float)-4.0f, (float)-1.0f));
        class_5610 innerHead = head.method_32117("inner_head", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new class_5605(0.4f)), class_5603.field_27701);
        innerHead.method_32117("jaw", class_5606.method_32108().method_32101(72, 0).method_32098(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, new class_5605(0.7f)), class_5603.method_32090((float)0.0f, (float)-0.2f, (float)3.5f));
        class_5610 shoulder1 = middle.method_32117("shoulder1", class_5606.method_32108().method_32101(28, 16).method_32097(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f), class_5603.method_32090((float)-7.0f, (float)-3.0f, (float)-1.0f));
        class_5610 shoulder2 = middle.method_32117("shoulder2", class_5606.method_32108().method_32101(28, 16).method_32096().method_32097(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f), class_5603.method_32090((float)7.0f, (float)-3.0f, (float)-1.0f));
        class_5610 arm1 = shoulder1.method_32117("arm1", class_5606.method_32108().method_32101(0, 28), class_5603.method_32090((float)-1.0f, (float)-1.0f, (float)0.0f));
        class_5610 innerArm1 = arm1.method_32117("inner_arm1", class_5606.method_32108().method_32101(0, 28).method_32097(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), class_5603.field_27701);
        class_5610 arm2 = shoulder2.method_32117("arm2", class_5606.method_32108().method_32101(0, 28).method_32096(), class_5603.method_32090((float)1.0f, (float)-1.0f, (float)0.0f));
        class_5610 innerArm2 = arm2.method_32117("inner_arm2", class_5606.method_32108().method_32101(0, 28).method_32097(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), class_5603.field_27701);
        class_5610 foreArm1 = innerArm1.method_32117("fore_arm1", class_5606.method_32108().method_32101(16, 28), class_5603.method_32090((float)0.0f, (float)11.0f, (float)0.0f));
        foreArm1.method_32117("inner_fore_arm1", class_5606.method_32108().method_32101(16, 28).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new class_5605(-0.01f)), class_5603.field_27701);
        class_5610 foreArm2 = innerArm2.method_32117("fore_arm2", class_5606.method_32108().method_32101(16, 28).method_32096(), class_5603.method_32090((float)0.0f, (float)11.0f, (float)0.0f));
        foreArm2.method_32117("inner_fore_arm2", class_5606.method_32108().method_32101(16, 28).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new class_5605(-0.01f)), class_5603.field_27701);
        class_5610 leg1 = pelvis.method_32117("leg1", class_5606.method_32108().method_32101(0, 28), class_5603.method_32090((float)-2.5f, (float)-2.5f, (float)0.0f));
        class_5610 innerLeg1 = leg1.method_32117("inner_leg1", class_5606.method_32108().method_32101(0, 28).method_32097(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), class_5603.field_27701);
        class_5610 leg2 = pelvis.method_32117("leg2", class_5606.method_32108().method_32101(0, 28).method_32096(), class_5603.method_32090((float)2.5f, (float)-2.5f, (float)0.0f));
        class_5610 innerLeg2 = leg2.method_32117("inner_leg2", class_5606.method_32108().method_32101(0, 28).method_32097(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), class_5603.field_27701);
        class_5610 foreLeg1 = innerLeg1.method_32117("fore_leg1", class_5606.method_32108().method_32101(32, 28), class_5603.method_32090((float)0.0f, (float)12.0f, (float)0.0f));
        foreLeg1.method_32117("inner_fore_leg1", class_5606.method_32108().method_32101(32, 28).method_32097(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), class_5603.field_27701);
        class_5610 foreLeg2 = innerLeg2.method_32117("fore_leg2", class_5606.method_32108().method_32101(32, 28).method_32096(), class_5603.method_32090((float)0.0f, (float)12.0f, (float)0.0f));
        foreLeg2.method_32117("inner_fore_leg2", class_5606.method_32108().method_32101(32, 28).method_32097(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), class_5603.field_27701);
        return class_5607.method_32110((class_5609)mesh, (int)128, (int)128);
    }

    public void setupAnim(MutantSkeletonRenderState renderState) {
        super.method_2819((Object)renderState);
        this.animator.update(renderState);
        this.setupInitialAngles();
        this.animate(renderState, renderState.field_53450, renderState.field_53451, renderState.field_53328, renderState.field_53447, renderState.field_53448);
    }

    private void setupInitialAngles() {
        this.skeleBase.field_3656 = 3.0f;
        this.pelvis.field_3654 = -0.31415927f;
        this.waist.field_3654 = 0.22439948f;
        for (int i = 0; i < this.spine.length; ++i) {
            this.spine[i].setupAnim(i == 1);
        }
        this.neck.field_3654 = -0.1308997f;
        this.head.field_3654 = -0.1308997f;
        this.jaw.field_3654 = 0.09817477f;
        this.shoulder1.field_3654 = -0.7853982f;
        this.shoulder2.field_3654 = -0.7853982f;
        this.innerarm1.field_3654 = 0.5235988f;
        this.innerarm1.field_3674 = 0.31415927f;
        this.innerarm2.field_3654 = 0.5235988f;
        this.innerarm2.field_3674 = -0.31415927f;
        this.innerforearm1.field_3654 = -0.5235988f;
        this.innerforearm2.field_3654 = -0.5235988f;
        this.leg1.field_3654 = -0.2617994f - this.pelvis.field_3654;
        this.leg1.field_3674 = 0.19634955f;
        this.leg2.field_3654 = -0.2617994f - this.pelvis.field_3654;
        this.leg2.field_3674 = -0.19634955f;
        this.foreleg1.field_3674 = -0.1308997f;
        this.innerforeleg1.field_3654 = 0.31415927f;
        this.foreleg2.field_3674 = 0.1308997f;
        this.innerforeleg2.field_3654 = 0.31415927f;
    }

    private void animate(MutantSkeletonRenderState renderState, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkAnim1 = class_3532.method_15374((float)(limbSwing * 0.5f));
        float walkAnim2 = class_3532.method_15374((float)(limbSwing * 0.5f - 1.1f));
        float breatheAnim = class_3532.method_15374((float)(ageInTicks * 0.1f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (renderState.animation == MutantSkeleton.MELEE_ANIMATION) {
            this.animateMelee(renderState);
            scale = 1.0f - class_3532.method_15363((float)(renderState.animationTime / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
        } else if (renderState.animation == MutantSkeleton.SHOOT_ANIMATION) {
            this.animateShoot(renderState, facePitch, faceYaw);
            scale = 1.0f - class_3532.method_15363((float)(renderState.animationTime / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (renderState.animation == MutantSkeleton.MULTI_SHOT_ANIMATION) {
            this.animateMultiShoot(renderState, facePitch, faceYaw);
            scale = 1.0f - class_3532.method_15363((float)(renderState.animationTime / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (this.animator.setAnimation(MutantSkeleton.CONSTRICT_RIBS_ANIMATION)) {
            this.animateConstrict(renderState);
            scale = 1.0f - class_3532.method_15363((float)(renderState.animationTime / 6.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        }
        this.skeleBase.field_3656 -= (-0.5f + Math.abs(walkAnim1)) * limbSwingAmount;
        this.spine[0].middle.field_3675 -= walkAnim1 * 0.06f * limbSwingAmount;
        this.arm1.field_3654 -= walkAnim1 * 0.9f * limbSwingAmount;
        this.arm2.field_3654 += walkAnim1 * 0.9f * limbSwingAmount;
        this.leg1.field_3654 += (0.2f + walkAnim1) * 1.0f * limbSwingAmount;
        this.leg2.field_3654 -= (-0.2f + walkAnim1) * 1.0f * limbSwingAmount;
        this.innerforeleg1.field_3654 += (0.6f + walkAnim2) * 0.6f * limbSwingAmount;
        this.innerforeleg2.field_3654 -= (-0.6f + walkAnim2) * 0.6f * limbSwingAmount;
        for (Spine spine : this.spine) {
            spine.animate(breatheAnim);
        }
        this.head.field_3654 -= breatheAnim * 0.02f;
        this.jaw.field_3654 += breatheAnim * 0.04f + 0.04f;
        this.arm1.field_3674 += breatheAnim * 0.025f;
        this.arm2.field_3674 -= breatheAnim * 0.025f;
        this.innerhead.field_3654 += facePitch;
        this.innerhead.field_3675 += faceYaw;
    }

    private void animateMelee(MutantSkeletonRenderState renderState) {
        int offsetMultiplier;
        boolean leftHanded = renderState.field_55303 == class_1306.field_6182;
        class_630 meleeArm = leftHanded ? this.arm2 : this.arm1;
        class_630 offArm = leftHanded ? this.arm1 : this.arm2;
        int n = offsetMultiplier = leftHanded ? -1 : 1;
        if (renderState.animationTime < 3.0f) {
            float animationProgress = renderState.animationTime / 3.0f;
            float rotationAmount = class_3532.method_15374((float)(animationProgress * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_3675 += rotationAmount * (float)Math.PI / 16.0f * (float)offsetMultiplier;
            }
            meleeArm.field_3675 += rotationAmount * (float)Math.PI / 10.0f * (float)offsetMultiplier;
            meleeArm.field_3674 += rotationAmount * (float)Math.PI / 4.0f * (float)offsetMultiplier;
            offArm.field_3674 += rotationAmount * (float)(-Math.PI) / 16.0f * (float)offsetMultiplier;
        } else if (renderState.animationTime < 5.0f) {
            float animationProgress = (renderState.animationTime - 3.0f) / 2.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_3675 += (rotationAmount * 0.5890486f - 0.3926991f) * (float)offsetMultiplier;
            }
            meleeArm.field_3675 += (rotationAmount * 2.7307692f - 2.41661f) * (float)offsetMultiplier;
            meleeArm.field_3674 += (rotationAmount * 1.1780972f - 0.3926991f) * (float)offsetMultiplier;
            offArm.field_3674 += -0.19634955f * (float)offsetMultiplier;
        } else if (renderState.animationTime < 8.0f) {
            for (Spine spine : this.spine) {
                spine.middle.field_3675 += -0.3926991f * (float)offsetMultiplier;
            }
            meleeArm.field_3675 += -2.41661f * (float)offsetMultiplier;
            meleeArm.field_3674 += -0.3926991f * (float)offsetMultiplier;
            offArm.field_3674 += -0.19634955f * (float)offsetMultiplier;
        } else if (renderState.animationTime < 14.0f) {
            float animationProgress = (renderState.animationTime - 8.0f) / 6.0f;
            float rotationAmount = class_3532.method_15362((float)(animationProgress * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_3675 += rotationAmount * (float)(-Math.PI) / 8.0f * (float)offsetMultiplier;
            }
            meleeArm.field_3675 += rotationAmount * (float)(-Math.PI) / 1.3f * (float)offsetMultiplier;
            meleeArm.field_3674 += rotationAmount * (float)(-Math.PI) / 8.0f * (float)offsetMultiplier;
            offArm.field_3674 += rotationAmount * (float)(-Math.PI) / 16.0f * (float)offsetMultiplier;
        }
    }

    private void animateShoot(MutantSkeletonRenderState renderState, float facePitch, float faceYaw) {
        int offset;
        boolean leftHanded = renderState.field_55303 == class_1306.field_6182;
        class_630 drawingArm = leftHanded ? this.arm2 : this.arm1;
        class_630 holdingArm = leftHanded ? this.arm1 : this.arm2;
        class_630 innerDrawingArm = leftHanded ? this.innerarm2 : this.innerarm1;
        class_630 innerHoldingArm = leftHanded ? this.innerarm1 : this.innerarm2;
        class_630 drawingForearm = leftHanded ? this.forearm2 : this.forearm1;
        class_630 holdingforearm = leftHanded ? this.forearm1 : this.forearm2;
        int n = offset = leftHanded ? -1 : 1;
        if (renderState.animationTime < 5.0f) {
            float tick = renderState.animationTime / 5.0f;
            float f = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            innerDrawingArm.field_3654 += -f * (float)Math.PI / 4.0f;
            drawingArm.field_3675 += -f * (float)Math.PI / 2.0f * (float)offset;
            drawingArm.field_3674 += f * (float)Math.PI / 16.0f * (float)offset;
            drawingForearm.field_3654 += f * (float)Math.PI / 7.0f;
            innerHoldingArm.field_3654 += -f * (float)Math.PI / 4.0f;
            holdingArm.field_3675 += f * (float)Math.PI / 2.0f * (float)offset;
            holdingArm.field_3674 += -f * (float)Math.PI / 16.0f * (float)offset;
            innerHoldingArm.field_3674 += -f * (float)Math.PI / 8.0f * (float)offset;
            holdingforearm.field_3654 += -f * (float)Math.PI / 6.0f;
        } else if (renderState.animationTime < 12.0f) {
            float tick = (renderState.animationTime - 5.0f) / 7.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            float f1 = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.innerhead.field_3675 += f1 * (float)Math.PI / 4.0f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.field_3675 += -f1 * (float)Math.PI / 12.0f * (float)offset;
                spine.middle.field_3654 += f1 * facePitch / 3.0f;
                spine.middle.field_3675 += f1 * faceYaw / 3.0f;
            }
            innerDrawingArm.field_3654 += f * 0.2617994f - 1.0471976f;
            drawingArm.field_3675 += (f * -0.9424778f - 0.62831855f) * (float)offset;
            drawingArm.field_3674 += (f * -0.850848f + 1.0471976f) * (float)offset;
            drawingForearm.field_3654 += 0.44879895f;
            innerHoldingArm.field_3654 += f * 1.8325956f - 2.6179938f;
            holdingArm.field_3675 += (f * 0.9424778f + 0.62831855f) * (float)offset;
            holdingArm.field_3674 += (f * 0.850848f - 1.0471976f) * (float)offset;
            innerHoldingArm.field_3674 += -f * (float)Math.PI / 8.0f * (float)offset;
            holdingforearm.field_3654 += f * 0.10471976f - 0.62831855f;
        } else if (renderState.animationTime < 26.0f) {
            this.innerhead.field_3675 += 0.7853982f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.field_3675 += -0.2617994f * (float)offset;
                spine.middle.field_3654 += facePitch / 3.0f;
                spine.middle.field_3675 += faceYaw / 3.0f;
            }
            innerDrawingArm.field_3654 += -1.0471976f;
            drawingArm.field_3675 += -0.62831855f * (float)offset;
            drawingArm.field_3674 += (float)offset;
            drawingForearm.field_3654 += 0.44879895f;
            innerHoldingArm.field_3654 += -2.6179938f;
            holdingArm.field_3675 += 0.62831855f * (float)offset;
            holdingArm.field_3674 += -1.0471976f * (float)offset;
            holdingforearm.field_3654 += -0.62831855f;
        } else if (renderState.animationTime < 30.0f) {
            float tick = (renderState.animationTime - 26.0f) / 4.0f;
            float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            this.innerhead.field_3675 += f * (float)Math.PI / 4.0f * (float)offset;
            for (Spine spine : this.spine) {
                spine.middle.field_3675 += -f * (float)Math.PI / 12.0f * (float)offset;
                spine.middle.field_3654 += f * facePitch / 3.0f;
                spine.middle.field_3675 += f * faceYaw / 3.0f;
            }
            innerDrawingArm.field_3654 += -f * (float)Math.PI / 3.0f;
            drawingArm.field_3675 += -f * (float)Math.PI / 5.0f * (float)offset;
            drawingArm.field_3674 += f * (float)Math.PI / 3.0f * (float)offset;
            drawingForearm.field_3654 += f * (float)Math.PI / 7.0f;
            innerHoldingArm.field_3654 += -f * (float)Math.PI / 1.2f;
            holdingArm.field_3675 += f * (float)Math.PI / 5.0f * (float)offset;
            holdingArm.field_3674 += -f * (float)Math.PI / 3.0f * (float)offset;
            holdingforearm.field_3654 += -f * (float)Math.PI / 5.0f;
        }
    }

    private void animateMultiShoot(MutantSkeletonRenderState renderState, float facePitch, float faceYaw) {
        boolean leftHanded;
        boolean bl = leftHanded = renderState.field_55303 == class_1306.field_6182;
        if (renderState.animationTime < 10.0f) {
            float tick = renderState.animationTime / 10.0f;
            float f = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
            this.skeleBase.field_3656 += f * 3.5f;
            this.spine[0].middle.field_3654 += f * (float)Math.PI / 6.0f;
            this.head.field_3654 += -f * (float)Math.PI / 4.0f;
            this.arm1.field_3654 += f * (float)Math.PI / 6.0f;
            this.arm1.field_3674 += f * (float)Math.PI / 16.0f;
            this.arm2.field_3654 += f * (float)Math.PI / 6.0f;
            this.arm2.field_3674 += -f * (float)Math.PI / 16.0f;
            this.leg1.field_3654 += -f * (float)Math.PI / 8.0f;
            this.leg2.field_3654 += -f * (float)Math.PI / 8.0f;
            this.innerforeleg1.field_3654 += f * (float)Math.PI / 4.0f;
            this.innerforeleg2.field_3654 += f * (float)Math.PI / 4.0f;
        } else {
            int offset;
            class_630 drawingArm = leftHanded ? this.arm2 : this.arm1;
            class_630 holdingArm = leftHanded ? this.arm1 : this.arm2;
            class_630 innerDrawingArm = leftHanded ? this.innerarm2 : this.innerarm1;
            class_630 innerHoldingArm = leftHanded ? this.innerarm1 : this.innerarm2;
            class_630 drawingForearm = leftHanded ? this.forearm2 : this.forearm1;
            class_630 holdingforearm = leftHanded ? this.forearm1 : this.forearm2;
            int n = offset = leftHanded ? -1 : 1;
            if (renderState.animationTime < 12.0f) {
                float tick = (renderState.animationTime - 10.0f) / 2.0f;
                float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
                float f1 = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
                this.skeleBase.field_3656 += f * 3.5f;
                this.spine[0].middle.field_3654 += f * (float)Math.PI / 6.0f;
                this.head.field_3654 += -f * (float)Math.PI / 4.0f;
                drawingArm.field_3654 += f * (float)Math.PI / 6.0f;
                drawingArm.field_3674 += f * (float)Math.PI / 16.0f * (float)offset;
                holdingArm.field_3654 += f * (float)Math.PI / 6.0f;
                holdingArm.field_3674 += -f * (float)Math.PI / 16.0f * (float)offset;
                this.leg1.field_3654 += -f * (float)Math.PI / 8.0f;
                this.leg2.field_3654 += -f * (float)Math.PI / 8.0f;
                this.innerforeleg1.field_3654 += f * (float)Math.PI / 4.0f;
                this.innerforeleg2.field_3654 += f * (float)Math.PI / 4.0f;
                drawingArm.field_3674 += -f1 * (float)Math.PI / 14.0f * (float)offset;
                holdingArm.field_3674 += f1 * (float)Math.PI / 14.0f * (float)offset;
                this.leg1.field_3674 += -f1 * (float)Math.PI / 24.0f;
                this.leg2.field_3674 += f1 * (float)Math.PI / 24.0f;
                this.foreleg1.field_3674 += f1 * (float)Math.PI / 64.0f;
                this.foreleg2.field_3674 += -f1 * (float)Math.PI / 64.0f;
            } else if (renderState.animationTime < 14.0f) {
                drawingArm.field_3674 += -0.22439948f * (float)offset;
                holdingArm.field_3674 += 0.22439948f * (float)offset;
                this.leg1.field_3674 += -0.1308997f;
                this.leg2.field_3674 += 0.1308997f;
                this.foreleg1.field_3674 += 0.049087387f;
                this.foreleg2.field_3674 += -0.049087387f;
            } else if (renderState.animationTime < 17.0f) {
                float tick = (renderState.animationTime - 14.0f) / 3.0f;
                float f = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
                float f1 = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
                drawingArm.field_3674 += -f1 * (float)Math.PI / 14.0f * (float)offset;
                holdingArm.field_3674 += f1 * (float)Math.PI / 14.0f * (float)offset;
                this.leg1.field_3674 += -f1 * (float)Math.PI / 24.0f;
                this.leg2.field_3674 += f1 * (float)Math.PI / 24.0f;
                this.foreleg1.field_3674 += f1 * (float)Math.PI / 64.0f;
                this.foreleg2.field_3674 += -f1 * (float)Math.PI / 64.0f;
                innerDrawingArm.field_3654 += -f * (float)Math.PI / 4.0f;
                drawingArm.field_3675 += -f * (float)Math.PI / 2.0f * (float)offset;
                drawingArm.field_3674 += f * (float)Math.PI / 16.0f * (float)offset;
                drawingForearm.field_3654 += f * (float)Math.PI / 7.0f;
                innerHoldingArm.field_3654 += -f * (float)Math.PI / 4.0f;
                holdingArm.field_3675 += f * (float)Math.PI / 2.0f * (float)offset;
                holdingArm.field_3674 += -f * (float)Math.PI / 16.0f * (float)offset;
                innerHoldingArm.field_3674 += -f * (float)Math.PI / 8.0f * (float)offset;
                holdingforearm.field_3654 += -f * (float)Math.PI / 6.0f;
            } else if (renderState.animationTime < 20.0f) {
                float tick = (renderState.animationTime - 17.0f) / 3.0f;
                float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
                float f1 = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
                this.innerhead.field_3675 += f1 * (float)Math.PI / 4.0f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.field_3675 += -f1 * (float)Math.PI / 12.0f * (float)offset;
                    spine.middle.field_3654 += f1 * facePitch / 3.0f;
                    spine.middle.field_3675 += f1 * faceYaw / 3.0f;
                }
                innerDrawingArm.field_3654 += f * 0.2617994f - 1.0471976f;
                drawingArm.field_3675 += (f * -0.9424778f - 0.62831855f) * (float)offset;
                drawingArm.field_3674 += (f * -0.850848f + 1.0471976f) * (float)offset;
                drawingForearm.field_3654 += 0.44879895f;
                innerHoldingArm.field_3654 += f * 1.8325956f - 2.6179938f;
                holdingArm.field_3675 += (f * 0.9424778f + 0.62831855f) * (float)offset;
                holdingArm.field_3674 += (f * 0.850848f - 1.0471976f) * (float)offset;
                innerHoldingArm.field_3674 += -f * (float)Math.PI / 8.0f * (float)offset;
                holdingforearm.field_3654 += f * 0.10471976f - 0.62831855f;
            } else if (renderState.animationTime < 24.0f) {
                this.innerhead.field_3675 += 0.7853982f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.field_3675 += -0.2617994f * (float)offset;
                    spine.middle.field_3654 += facePitch / 3.0f;
                    spine.middle.field_3675 += faceYaw / 3.0f;
                }
                innerDrawingArm.field_3654 += -1.0471976f;
                drawingArm.field_3675 += -0.62831855f * (float)offset;
                drawingArm.field_3674 += (float)offset;
                drawingForearm.field_3654 += 0.44879895f;
                innerHoldingArm.field_3654 += -2.6179938f;
                holdingArm.field_3675 += 0.62831855f * (float)offset;
                holdingArm.field_3674 += -1.0471976f * (float)offset;
                holdingforearm.field_3654 += -0.62831855f;
            } else if (renderState.animationTime < 28.0f) {
                float tick = (renderState.animationTime - 24.0f) / 4.0f;
                float f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
                this.innerhead.field_3675 += f * (float)Math.PI / 4.0f * (float)offset;
                for (Spine spine : this.spine) {
                    spine.middle.field_3675 += -f * (float)Math.PI / 12.0f * (float)offset;
                    spine.middle.field_3654 += f * facePitch / 3.0f;
                    spine.middle.field_3675 += f * faceYaw / 3.0f;
                }
                innerDrawingArm.field_3654 += -f * (float)Math.PI / 3.0f;
                drawingArm.field_3675 += -f * (float)Math.PI / 5.0f * (float)offset;
                drawingArm.field_3674 += f * (float)Math.PI / 3.0f * (float)offset;
                drawingForearm.field_3654 += f * (float)Math.PI / 7.0f;
                innerHoldingArm.field_3654 += -f * (float)Math.PI / 1.2f;
                holdingArm.field_3675 += f * (float)Math.PI / 5.0f * (float)offset;
                holdingArm.field_3674 += -f * (float)Math.PI / 3.0f * (float)offset;
                holdingforearm.field_3654 += -f * (float)Math.PI / 5.0f;
            }
        }
    }

    private void animateConstrict(MutantSkeletonRenderState renderState) {
        block6: {
            float f;
            float tick;
            block7: {
                block5: {
                    int i;
                    this.animator.startPhase(5);
                    this.animator.rotate(this.waist, 0.1308997f, 0.0f, 0.0f);
                    for (i = 0; i < this.spine.length; ++i) {
                        tick = i == 0 ? 0.3926991f : (i == 2 ? -0.3926991f : 0.0f);
                        f = i == 1 ? 0.3926991f : 0.31415927f;
                        this.animator.rotate(this.spine[i].side1[0], tick, f, 0.0f);
                        this.animator.rotate(this.spine[i].side1[1], 0.0f, 0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[i].side1[2], 0.0f, 0.2617994f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[0], tick, -f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[1], 0.0f, -0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[2], 0.0f, -0.2617994f, 0.0f);
                    }
                    this.animator.rotate(this.arm1, 0.0f, 0.0f, 0.8975979f);
                    this.animator.rotate(this.arm2, 0.0f, 0.0f, -0.8975979f);
                    this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
                    this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.innerforeleg1, 0.5235988f, 0.0f, 0.0f);
                    this.animator.rotate(this.innerforeleg2, 0.5235988f, 0.0f, 0.0f);
                    this.animator.endPhase();
                    this.animator.setStationaryPhase(2);
                    this.animator.startPhase(1);
                    this.animator.rotate(this.neck, 0.19634955f, 0.0f, 0.0f);
                    this.animator.rotate(this.head, 0.15707964f, 0.0f, 0.0f);
                    this.animator.rotate(this.waist, 0.31415927f, 0.0f, 0.0f);
                    this.animator.rotate(this.spine[0].middle, 0.2617994f, 0.0f, 0.0f);
                    for (i = 0; i < this.spine.length; ++i) {
                        tick = i == 0 ? 0.1308997f : (i == 2 ? -0.1308997f : 0.0f);
                        f = i == 1 ? -0.17453294f : -0.22439948f;
                        this.animator.rotate(this.spine[i].side1[0], tick - 0.08f, f, 0.0f);
                        this.animator.rotate(this.spine[i].side1[1], 0.0f, 0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[i].side1[2], 0.0f, 0.2617994f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[0], tick + 0.08f, -f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[1], 0.0f, -0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[i].side2[2], 0.0f, -0.2617994f, 0.0f);
                    }
                    this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
                    this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.innerforeleg1, 0.5235988f, 0.0f, 0.0f);
                    this.animator.rotate(this.innerforeleg2, 0.5235988f, 0.0f, 0.0f);
                    this.animator.endPhase();
                    this.animator.setStationaryPhase(4);
                    this.animator.resetPhase(8);
                    if (!(renderState.animationTime < 5.0f)) break block5;
                    tick = renderState.animationTime / 5.0f;
                    f = class_3532.method_15374((float)(tick * (float)Math.PI / 2.0f));
                    for (Spine spine : this.spine) {
                        Animator.setScale(spine.side1[0], 1.0f + f * 0.6f);
                        Animator.setScale(spine.side2[0], 1.0f + f * 0.6f);
                    }
                    break block6;
                }
                if (!(renderState.animationTime < 12.0f)) break block7;
                for (Spine spine : this.spine) {
                    Animator.setScale(spine.side1[0], 1.6f);
                    Animator.setScale(spine.side2[0], 1.6f);
                }
                break block6;
            }
            if (!(renderState.animationTime < 20.0f)) break block6;
            tick = (renderState.animationTime - 12.0f) / 8.0f;
            f = class_3532.method_15362((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                Animator.setScale(spine.side1[0], 1.0f + f * 0.6f);
                Animator.setScale(spine.side2[0], 1.0f + f * 0.6f);
            }
        }
    }

    public void translateHand(boolean leftHanded, class_4587 poseStack) {
        this.skeleBase.method_22703(poseStack);
        this.pelvis.method_22703(poseStack);
        this.waist.method_22703(poseStack);
        for (Spine spine : this.spine) {
            spine.middle.method_22703(poseStack);
        }
        if (leftHanded) {
            this.shoulder2.method_22703(poseStack);
            this.arm2.method_22703(poseStack);
            this.innerarm2.method_22703(poseStack);
            this.forearm2.method_22703(poseStack);
            this.innerforearm2.method_22703(poseStack);
        } else {
            this.shoulder1.method_22703(poseStack);
            this.arm1.method_22703(poseStack);
            this.innerarm1.method_22703(poseStack);
            this.forearm1.method_22703(poseStack);
            this.innerforearm1.method_22703(poseStack);
        }
    }

    public static class Spine
    extends class_3879<Boolean> {
        public final class_630 middle;
        public final class_630[] side1 = new class_630[3];
        public final class_630[] side2 = new class_630[3];

        public Spine(class_630 modelPart) {
            this(modelPart, "");
        }

        public Spine(class_630 modelPart, String index) {
            super(modelPart.method_32086("middle" + index), class_1921::method_23578);
            int i;
            this.middle = this.field_54014;
            modelPart = this.field_54014;
            for (i = 0; i < 3; ++i) {
                modelPart = this.side1[i] = modelPart.method_32086("side1" + (i + 1) + index);
            }
            modelPart = this.field_54014;
            for (i = 0; i < 3; ++i) {
                modelPart = this.side2[i] = modelPart.method_32086("side2" + (i + 1) + index);
            }
        }

        public static class_5607 createBodyLayer() {
            class_5609 meshDefinition = new class_5609();
            class_5610 root = meshDefinition.method_32111();
            Spine.createSpineLayer(root, -1);
            return class_5607.method_32110((class_5609)meshDefinition, (int)128, (int)128);
        }

        public static void createSpineLayer(class_5610 root, int index) {
            class_5603 partPose = class_5603.field_27701;
            if (index == 0) {
                partPose = class_5603.method_32090((float)0.0f, (float)-7.0f, (float)0.0f);
            } else if (index > 0) {
                partPose = class_5603.method_32090((float)0.0f, (float)-5.0f, (float)0.0f);
            }
            boolean skeletonPart = index < 0;
            String indexString = skeletonPart ? "" : "" + (index + 1);
            class_5610 middle = root.method_32117("middle" + indexString, class_5606.method_32108().method_32101(50, 0).method_32098(-2.5f, -4.0f, -2.0f, 5.0f, 4.0f, 4.0f, new class_5605(0.5f)), partPose);
            partPose = !skeletonPart ? class_5603.method_32090((float)-3.0f, (float)-1.0f, (float)1.75f) : class_5603.field_27701;
            class_5610 side11 = middle.method_32117("side11" + indexString, class_5606.method_32108().method_32101(32, 12).method_32098(skeletonPart ? 0.0f : -6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new class_5605(0.25f)), partPose);
            class_5610 side12 = side11.method_32117("side12" + indexString, class_5606.method_32108().method_32101(32, 12).method_32096().method_32098(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new class_5605(0.2f)), class_5603.method_32090((float)(skeletonPart ? -0.5f : -6.5f), (float)0.0f, (float)0.0f));
            side12.method_32117("side13" + indexString, class_5606.method_32108().method_32101(32, 12).method_32098(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new class_5605(0.15f)), class_5603.method_32090((float)-6.4f, (float)0.0f, (float)0.0f));
            partPose = !skeletonPart ? class_5603.method_32090((float)3.0f, (float)-1.0f, (float)1.75f) : class_5603.field_27701;
            class_5610 side21 = middle.method_32117("side21" + indexString, class_5606.method_32108().method_32101(32, 12).method_32096().method_32098(skeletonPart ? -6.0f : 0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new class_5605(0.25f)), partPose);
            class_5610 side22 = side21.method_32117("side22" + indexString, class_5606.method_32108().method_32101(32, 12).method_32098(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new class_5605(0.2f)), class_5603.method_32090((float)(skeletonPart ? 0.5f : 6.5f), (float)0.0f, (float)0.0f));
            side22.method_32117("side23" + indexString, class_5606.method_32108().method_32101(32, 12).method_32096().method_32098(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, new class_5605(0.15f)), class_5603.method_32090((float)6.4f, (float)0.0f, (float)0.0f));
        }

        public void setupAnim(Boolean middleSpine) {
            super.method_2819((Object)middleSpine);
            this.middle.field_3654 = 0.17453294f;
            this.side1[0].field_3675 = -0.69813174f;
            this.side2[0].field_3675 = 0.69813174f;
            this.side1[1].field_3675 = -1.0471976f;
            this.side2[1].field_3675 = 1.0471976f;
            this.side1[2].field_3675 = -0.8975979f;
            this.side2[2].field_3675 = 0.8975979f;
            if (middleSpine.booleanValue()) {
                for (int i = 0; i < this.side1.length; ++i) {
                    this.side1[i].field_3675 *= 0.98f;
                    this.side2[i].field_3675 *= 0.98f;
                }
            }
            Animator.setScale(this.side1[0], 1.0f);
            Animator.setScale(this.side2[0], 1.0f);
        }

        public void animate(float breatheAnim) {
            this.side1[1].field_3675 += breatheAnim * 0.02f;
            this.side2[1].field_3675 -= breatheAnim * 0.02f;
        }
    }
}

