/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.model.CreeperMinionModel;
import fuzs.mutantmonsters.client.model.geom.ModModelLayers;
import fuzs.mutantmonsters.client.renderer.ModRenderType;
import fuzs.mutantmonsters.client.renderer.entity.CreeperMinionRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.PowerableLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.CreeperMinionRenderState;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import java.util.Optional;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10201;
import net.minecraft.class_11659;
import net.minecraft.class_11890;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_922;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

public class CreeperMinionOnShoulderLayer
extends class_3887<class_10055, class_591> {
    private static final class_169<Optional<CreeperMinionRenderState>> LEFT_SHOULDER_CREEPER_MINION_KEY = new class_169(MutantMonsters.id("left_shoulder_creeper_minion"));
    private static final class_169<Optional<CreeperMinionRenderState>> RIGHT_SHOULDER_CREEPER_MINION_KEY = new class_169(MutantMonsters.id("right_shoulder_creeper_minion"));
    private final class_10201 equipmentAssets;
    private final CreeperMinionModel model;
    private final CreeperMinionModel chargedModel;

    public CreeperMinionOnShoulderLayer(class_3883<class_10055, class_591> entityRenderer, class_5617.class_5618 context) {
        super(entityRenderer);
        this.equipmentAssets = context.method_64071();
        this.model = new CreeperMinionModel(context.method_32167(ModModelLayers.CREEPER_MINION_SHOULDER));
        this.chargedModel = new CreeperMinionModel(context.method_32167(ModModelLayers.CREEPER_MINION_SHOULDER_ARMOR));
    }

    public static void addLivingEntityRenderLayers(class_1299<?> entityType, class_922<?, ?, ?> entityRenderer, class_5617.class_5618 context) {
        if (entityRenderer instanceof class_1007) {
            class_1007 avatarRenderer = (class_1007)entityRenderer;
            avatarRenderer.method_4046((class_3887)new CreeperMinionOnShoulderLayer((class_3883<class_10055, class_591>)avatarRenderer, context));
        }
    }

    public static void onExtractRenderState(class_1297 entity, class_10017 renderState, float partialTick) {
        if (entity instanceof class_11890 && renderState instanceof class_10055) {
            class_10055 avatarRenderState = (class_10055)renderState;
            RenderStateExtraData.set((class_10017)renderState, LEFT_SHOULDER_CREEPER_MINION_KEY, CreeperMinionOnShoulderLayer.copyRenderState((class_10042)avatarRenderState, (Optional)ModRegistry.LEFT_SHOULDER_CREEPER_MINION_ATTACHMENT_TYPE.getOrDefault((Object)entity, Optional.empty())));
            RenderStateExtraData.set((class_10017)renderState, RIGHT_SHOULDER_CREEPER_MINION_KEY, CreeperMinionOnShoulderLayer.copyRenderState((class_10042)avatarRenderState, (Optional)ModRegistry.RIGHT_SHOULDER_CREEPER_MINION_ATTACHMENT_TYPE.getOrDefault((Object)entity, Optional.empty())));
        }
    }

    private static Optional<CreeperMinionRenderState> copyRenderState(class_10042 renderState, Optional<Boolean> isPowered) {
        if (isPowered.isEmpty()) {
            return Optional.empty();
        }
        CreeperMinionRenderState creeperMinionRenderState = new CreeperMinionRenderState();
        creeperMinionRenderState.field_53328 = renderState.field_53328;
        creeperMinionRenderState.field_53450 = renderState.field_53450;
        creeperMinionRenderState.field_53451 = renderState.field_53451;
        creeperMinionRenderState.field_53447 = renderState.field_53447;
        creeperMinionRenderState.field_53448 = renderState.field_53448;
        creeperMinionRenderState.inSittingPose = true;
        creeperMinionRenderState.field_61821 = renderState.field_61821;
        creeperMinionRenderState.field_53304 = isPowered.get();
        return Optional.of(creeperMinionRenderState);
    }

    public void submit(class_4587 poseStack, class_11659 nodeCollector, int packedLight, class_10055 renderState, float yRot, float xRot) {
        ((Optional)RenderStateExtraData.getOrDefault((class_10017)renderState, LEFT_SHOULDER_CREEPER_MINION_KEY, Optional.empty())).ifPresent(creeperMinionRenderState -> this.renderOnShoulder(poseStack, nodeCollector, packedLight, renderState, (CreeperMinionRenderState)creeperMinionRenderState, true));
        ((Optional)RenderStateExtraData.getOrDefault((class_10017)renderState, RIGHT_SHOULDER_CREEPER_MINION_KEY, Optional.empty())).ifPresent(creeperMinionRenderState -> this.renderOnShoulder(poseStack, nodeCollector, packedLight, renderState, (CreeperMinionRenderState)creeperMinionRenderState, false));
    }

    private void renderOnShoulder(class_4587 poseStack, class_11659 nodeCollector, int packedLight, class_10055 avatarRenderState, CreeperMinionRenderState renderState, boolean isLeftShoulder) {
        poseStack.method_22903();
        poseStack.method_46416(0.42f * (isLeftShoulder ? 1.0f : -1.0f), avatarRenderState.field_53410 ? -0.55f : -0.75f, 0.0f);
        if (this.hasLayer(avatarRenderState.field_53418, class_10186.class_10190.field_54125)) {
            poseStack.method_46416(0.0f, -0.053125f, 0.0f);
        }
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        nodeCollector.method_73489((class_3879)this.model, (Object)renderState, poseStack, this.model.method_23500(CreeperMinionRenderer.TEXTURE_LOCATION), packedLight, class_4608.field_21444, avatarRenderState.field_61821, null);
        if (renderState.field_53304) {
            class_1921 renderType = ModRenderType.energySwirl(PowerableLayer.LIGHTNING_TEXTURE, avatarRenderState.field_53328 * 0.01f, avatarRenderState.field_53328 * 0.01f);
            int color = class_9848.method_61318((float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
            nodeCollector.method_73490((class_3879)this.chargedModel, (Object)renderState, poseStack, renderType, packedLight, class_4608.field_21444, color, null, avatarRenderState.field_61821, null);
        }
        poseStack.method_22909();
    }

    private boolean hasLayer(class_1799 itemStack, class_10186.class_10190 layer) {
        class_10192 equippable = (class_10192)itemStack.method_58694(class_9334.field_54196);
        if (equippable != null && !equippable.comp_3176().isEmpty()) {
            class_10186 equipmentClientInfo = this.equipmentAssets.method_64087((class_5321)equippable.comp_3176().get());
            return !equipmentClientInfo.method_63996(layer).isEmpty();
        }
        return false;
    }
}

