/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_10042;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10197;
import net.minecraft.class_10394;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_583;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ModEquipmentLayer<S extends class_10042, RM extends class_583<? super S>, EM extends class_583<? super S>>
extends class_3887<S, RM> {
    private final Map<class_5321<class_10394>, List<class_10186.class_10189>> equipmentAssets;
    private final String layerType;
    private final Function<S, class_1799> itemGetter;
    private final EM adultModel;
    private final EM babyModel;
    private final int order;

    public ModEquipmentLayer(class_3883<S, RM> renderLayerParent, class_5321<class_10394> assetId, class_2960 layer, String layerType, Function<S, class_1799> itemGetter, EM adultModel, EM babyModel, int order) {
        super(renderLayerParent);
        this.equipmentAssets = Collections.singletonMap(assetId, Collections.singletonList(new class_10186.class_10189(layer)));
        this.layerType = layerType;
        this.itemGetter = itemGetter;
        this.adultModel = adultModel;
        this.babyModel = babyModel;
        this.order = order;
    }

    public ModEquipmentLayer(class_3883<S, RM> renderLayerParent, class_5321<class_10394> assetId, class_2960 layer, String layerType, Function<S, class_1799> itemGetter, EM adultModel, EM babyModel) {
        this(renderLayerParent, assetId, layer, layerType, itemGetter, adultModel, babyModel, 0);
    }

    public void submit(class_4587 poseStack, class_11659 nodeCollector, int packedLight, S renderState, float yRot, float xRot) {
        class_1799 itemStack = this.itemGetter.apply(renderState);
        class_10192 equippable = (class_10192)itemStack.method_58694(class_9334.field_54196);
        if (equippable != null && !equippable.comp_3176().isEmpty()) {
            EM entityModel = ((class_10042)renderState).field_53457 ? this.babyModel : this.adultModel;
            this.renderLayers(this.layerType, (class_5321<class_10394>)((class_5321)equippable.comp_3176().get()), (class_3879<? super S>)entityModel, renderState, itemStack, poseStack, nodeCollector, packedLight, null, ((class_10042)renderState).field_61821, this.order);
        }
    }

    public void renderLayers(String layerType, class_5321<class_10394> equipmentAsset, class_3879<? super S> armorModel, S renderState, class_1799 item, class_4587 poseStack, class_11659 nodeCollector, int packedLight, int outlineColor) {
        this.renderLayers(layerType, equipmentAsset, armorModel, renderState, item, poseStack, nodeCollector, packedLight, null, outlineColor, 1);
    }

    public void renderLayers(String layerType, class_5321<class_10394> equipmentAsset, class_3879<? super S> armorModel, S renderState, class_1799 item, class_4587 poseStack, class_11659 nodeCollector, int packedLight, @Nullable class_2960 texture, int outlineColor, int order) {
        List<class_10186.class_10189> list = this.equipmentAssets.get(equipmentAsset);
        if (!list.isEmpty()) {
            int dyeColor = class_9282.method_57470((class_1799)item, (int)0);
            boolean hasFoil = item.method_7958();
            for (class_10186.class_10189 layer : list) {
                int tintColor = class_10197.method_64076((class_10186.class_10189)layer, (int)dyeColor);
                if (tintColor == 0) continue;
                class_2960 resourceLocation = this.layerTextureLookup(layer, layerType);
                nodeCollector.method_73529(order++).method_73490(armorModel, renderState, poseStack, class_1921.method_25448((class_2960)resourceLocation), packedLight, class_4608.field_21444, tintColor, null, outlineColor, null);
                if (hasFoil) {
                    nodeCollector.method_73529(order++).method_73490(armorModel, renderState, poseStack, class_1921.method_27949(), packedLight, class_4608.field_21444, tintColor, null, outlineColor, null);
                }
                hasFoil = false;
            }
        }
    }

    public class_2960 layerTextureLookup(class_10186.class_10189 layer, String type) {
        return layer.comp_3171().method_45134(string -> "textures/entity/equipment/" + type + "/" + string + ".png");
    }
}

