/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.entity.layers.EnderEnergySwirlLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.class_11659;
import net.minecraft.class_3883;
import net.minecraft.class_4587;

public class MutantEndermanTeleportLayer
extends EnderEnergySwirlLayer<MutantEndermanRenderState, MutantEndermanModel> {
    private boolean isShrinking;

    public MutantEndermanTeleportLayer(class_3883<MutantEndermanRenderState, MutantEndermanModel> renderer) {
        super(renderer);
    }

    public void setShrinking(boolean shrinking) {
        this.isShrinking = shrinking;
    }

    @Override
    public void submit(class_4587 poseStack, class_11659 nodeCollector, int packedLight, MutantEndermanRenderState renderState, float yRot, float xRot) {
        if (renderState.animation == MutantEnderman.TELEPORT_ANIMATION && renderState.animationTime < 10.0f) {
            super.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
        }
    }

    @Override
    protected float getScale(MutantEndermanRenderState renderState) {
        if (this.isShrinking) {
            return 2.2f - renderState.animationTime / 10.0f;
        }
        return 1.2f + renderState.animationTime / 10.0f;
    }

    @Override
    protected void scale(class_4587 poseStack, float scale) {
        poseStack.method_22905(scale, scale * 0.8f, scale);
    }

    @Override
    protected float getAlpha(MutantEndermanRenderState renderState) {
        if (!this.isShrinking && renderState.animationTime >= 8.0f) {
            return 1.0f - (renderState.animationTime - 8.0f) / 2.0f;
        }
        if (this.isShrinking && renderState.animationTime < 2.0f) {
            return renderState.animationTime / 2.0f;
        }
        return 1.0f;
    }
}

