/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.item.v2.EnchantingHelper;
import fuzs.puzzleslib.api.util.v1.DamageHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventsHandler {
    public static EventResult onItemUseTick(class_1309 entity, class_1799 useItem, MutableInt useItemRemaining) {
        if (entity.method_6118(class_1304.field_6174).method_41406(ModItems.MUTANT_SKELETON_CHESTPLATE_ITEM) && useItem.method_7909() instanceof class_1753 && class_1753.method_7722((int)(useItem.method_7935(entity) - useItemRemaining.getAsInt())) < 1.0f) {
            useItemRemaining.mapInt(i -> i - 2);
        }
        return EventResult.PASS;
    }

    public static EventResult onArrowLoose(class_1657 player, class_1799 weapon, class_1937 level, MutableInt charge, boolean hasAmmo) {
        if (player.method_6118(class_1304.field_6169).method_41406(ModItems.MUTANT_SKELETON_SKULL_ITEM) && weapon.method_7909() instanceof class_1753) {
            class_6880 enchantment = EnchantingHelper.lookup((class_4538)level, (class_5321)class_1893.field_9108);
            if (weapon.method_58657().method_57536(enchantment) == 0) {
                class_1799 itemStack = weapon.method_7972();
                itemStack.method_7978(enchantment, 1);
                itemStack.method_7930(level, (class_1309)player, player.method_6014());
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            PlayerEventsHandler.playShoulderEntityAmbientSound(serverPlayer, serverPlayer.method_74074());
            PlayerEventsHandler.playShoulderEntityAmbientSound(serverPlayer, serverPlayer.method_74075());
            SeismicWave seismicWave = SeismicWave.poll(player);
            if (seismicWave != null) {
                PlayerEventsHandler.handleSeismicWave(serverPlayer.method_51469(), player, seismicWave);
            }
        }
    }

    private static void handleSeismicWave(class_3218 serverLevel, class_1657 player, @NotNull SeismicWave seismicWave) {
        seismicWave.affectBlocks(serverLevel, (class_1297)player);
        class_238 box = new class_238((double)seismicWave.method_10263(), (double)seismicWave.method_10264() + 1.0, (double)seismicWave.method_10260(), (double)seismicWave.method_10263() + 1.0, (double)seismicWave.method_10264() + 2.0, (double)seismicWave.method_10260() + 1.0);
        for (class_1309 livingEntity : serverLevel.method_18467(class_1309.class, box)) {
            if (livingEntity == player || player.method_5854() == livingEntity) continue;
            class_1282 damageSource = DamageHelper.damageSource((class_4538)serverLevel, ModRegistry.PLAYER_SEISMIC_WAVE_DAMAGE_TYPE, (class_1297)player);
            livingEntity.method_64397(serverLevel, damageSource, 6.0f + (float)player.method_59922().method_43048(3));
        }
    }

    private static void playShoulderEntityAmbientSound(class_3222 serverPlayer, @Nullable class_2487 compoundTag) {
        class_1299 entityType;
        if (compoundTag != null && !compoundTag.method_33133() && !compoundTag.method_68566("Silent", false) && serverPlayer.method_51469().field_9229.method_43048(500) == 0 && (entityType = (class_1299)compoundTag.method_67491("id", class_1299.field_57582).orElse(null)) == ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.comp_349()) {
            serverPlayer.method_51469().method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), (class_3414)ModSoundEvents.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.comp_349(), serverPlayer.method_5634(), 1.0f, (serverPlayer.method_51469().field_9229.method_43057() - serverPlayer.method_51469().field_9229.method_43057()) * 0.2f + 1.5f);
        }
    }

    public static EventResult onItemToss(class_3222 serverPlayer, class_1799 itemStack) {
        boolean isHoldingEndersoulHand;
        boolean bl = isHoldingEndersoulHand = itemStack.method_41406(ModItems.ENDERSOUL_HAND_ITEM) && itemStack.method_7986();
        if (itemStack.method_31574(class_1802.field_8449) || isHoldingEndersoulHand) {
            int endersoulFragments = 0;
            for (EndersoulFragment endersoulFragment : serverPlayer.method_51469().method_18467(EndersoulFragment.class, serverPlayer.method_5829().method_1014(8.0))) {
                if (!endersoulFragment.ownedBy((class_1297)serverPlayer)) continue;
                ++endersoulFragments;
                endersoulFragment.method_31472();
            }
            if (endersoulFragments > 0) {
                EntityUtil.sendParticlePacket((class_1297)serverPlayer, (class_2394)ModRegistry.ENDERSOUL_PARTICLE_TYPE.comp_349(), 256);
                int additionalDamageValue = endersoulFragments * 60;
                if (isHoldingEndersoulHand) {
                    int damageValue = itemStack.method_7919() - additionalDamageValue;
                    itemStack.method_7974(Math.max(damageValue, 0));
                } else {
                    class_1799 newItemStack = new class_1799(ModItems.ENDERSOUL_HAND_ITEM);
                    newItemStack.method_7974(newItemStack.method_7936() - additionalDamageValue);
                    class_1542 itemEntity = serverPlayer.method_67517(newItemStack, false, true);
                    if (itemEntity != null) {
                        serverPlayer.method_51469().method_8649((class_1297)itemEntity);
                        serverPlayer.method_7342(class_3468.field_15405.method_14956((Object)newItemStack.method_7909()), itemStack.method_7947());
                        serverPlayer.method_7281(class_3468.field_15406);
                        return EventResult.INTERRUPT;
                    }
                }
            }
        }
        return EventResult.PASS;
    }
}

