/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.proxy.Proxy;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.OwnerTargetGoal;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.EnumSet;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1360;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1404;
import net.minecraft.class_1429;
import net.minecraft.class_1471;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class CreeperMinion
extends class_1471 {
    private static final class_2940<Byte> DATA_CREEPER_MINION_FLAGS = class_2945.method_12791(CreeperMinion.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> DATA_EXPLODE_STATE = class_2945.method_12791(CreeperMinion.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DATA_EXPLOSION_RADIUS = class_2945.method_12791(CreeperMinion.class, (class_2941)class_2943.field_13320);
    private static final int TOTAL_FUSE_TIME = 26;
    private int lastActiveTime;
    private int timeSinceIgnited;
    private boolean droppedSkulls;

    public CreeperMinion(class_1299<? extends CreeperMinion> entityType, class_1937 level) {
        super(entityType, level);
        this.setDestroyBlocks(true);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new CreeperMinionSwellGoal());
        this.field_6201.method_6277(3, (class_1352)new AvoidDamageGoal((class_1314)this, 1.2));
        this.field_6201.method_6277(3, (class_1352)new class_1338<class_1429>((class_1314)this, class_1429.class, 6.0f, 1.0, 1.2, EntityUtil::isFeline){

            public boolean method_6264() {
                return !CreeperMinion.this.method_6181() && super.method_6264();
            }
        });
        this.field_6201.method_6277(4, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.2));
        this.field_6201.method_6277(5, (class_1352)new CreeperMinionFollowOwnerGoal());
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1360(this){

            public boolean method_6264() {
                return CreeperMinion.this.method_6181() && CreeperMinion.this.method_35057() instanceof class_1657 && super.method_6264();
            }
        });
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new OwnerTargetGoal((class_1321)this));
        this.field_6185.method_6277(1, (class_1352)new HurtByNearestTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1404((class_1321)this, class_1657.class, true, null));
    }

    public static class_5132.class_5133 createAttributes() {
        return CreeperMinion.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_CREEPER_MINION_FLAGS, (Object)0);
        builder.method_56912(DATA_EXPLODE_STATE, (Object)-1);
        builder.method_56912(DATA_EXPLOSION_RADIUS, (Object)Float.valueOf(2.0f));
    }

    public int getExplodeState() {
        return (Integer)this.field_6011.method_12789(DATA_EXPLODE_STATE);
    }

    public void setExplodeState(int state) {
        this.field_6011.method_12778(DATA_EXPLODE_STATE, (Object)state);
    }

    public boolean isCharged() {
        return ((Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS) & 1) != 0;
    }

    public void setCharged(boolean charged) {
        byte b0 = (Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(DATA_CREEPER_MINION_FLAGS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasIgnited() {
        return ((Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS) & 4) != 0;
    }

    public void ignite() {
        byte b0 = (Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(DATA_CREEPER_MINION_FLAGS, (Object)((byte)(b0 | 4)));
    }

    public boolean canExplodeContinuously() {
        return ((Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS) & 8) != 0;
    }

    public void setCanExplodeContinuously(boolean continuously) {
        byte b0 = (Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(DATA_CREEPER_MINION_FLAGS, (Object)(continuously ? (byte)(b0 | 8) : (byte)(b0 & 0xFFFFFFF7)));
    }

    public boolean canDestroyBlocks() {
        return ((Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS) & 0x10) != 0;
    }

    public void setDestroyBlocks(boolean destroy) {
        byte b0 = (Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(DATA_CREEPER_MINION_FLAGS, (Object)(destroy ? (byte)(b0 | 0x10) : (byte)(b0 & 0xFFFFFFEF)));
    }

    public boolean canRideOnShoulder() {
        return ((Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS) & 0x20) != 0;
    }

    public void setCanRideOnShoulder(boolean canRide) {
        byte b0 = (Byte)this.field_6011.method_12789(DATA_CREEPER_MINION_FLAGS);
        this.field_6011.method_12778(DATA_CREEPER_MINION_FLAGS, (Object)(canRide ? (byte)(b0 | 0x20) : (byte)(b0 & 0xFFFFFFDF)));
    }

    public float getExplosionRadius() {
        return ((Float)this.field_6011.method_12789(DATA_EXPLOSION_RADIUS)).floatValue();
    }

    public void setExplosionRadius(float radius) {
        this.field_6011.method_12778(DATA_EXPLOSION_RADIUS, (Object)Float.valueOf(class_3532.method_15363((float)radius, (float)0.0f, (float)4.0f)));
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (field_6322.equals(key)) {
            this.method_18382();
        }
    }

    protected class_4048 method_55694(class_4050 pose) {
        return this.method_6172() ? super.method_55694(pose).method_19539(1.0f, 0.75f) : super.method_55694(pose);
    }

    public boolean method_6109() {
        return false;
    }

    public boolean method_6626() {
        return super.method_6626() && this.canRideOnShoulder() && this.method_5968() == null && this.getExplodeState() <= 0;
    }

    public void method_5800(class_3218 level, class_1538 lightning) {
        super.method_5800(level, lightning);
        this.setCharged(true);
    }

    public void method_5982() {
        if (this.method_73183().method_8407() == class_1267.field_5801 && !this.method_6181()) {
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    public boolean method_5747(double fallDistance, float damageMultiplier, class_1282 source) {
        boolean hasFallen = super.method_5747(fallDistance, damageMultiplier, source);
        this.timeSinceIgnited = (int)((double)this.timeSinceIgnited + fallDistance * 1.5);
        if (this.timeSinceIgnited > 21) {
            this.timeSinceIgnited = 21;
        }
        return hasFallen;
    }

    public boolean method_5874(class_3218 level, class_1309 entity, class_1282 damageSource) {
        if (this.method_27071(level) && this.isCharged() && !this.droppedSkulls) {
            entity.method_72396(level, damageSource, false, ModRegistry.CHARGED_CREEPER_MINION_LOOT_TABLE, itemStack -> entity.method_5775(level, itemStack));
            this.droppedSkulls = true;
        }
        return super.method_5874(level, entity, damageSource);
    }

    public void method_5773() {
        if (this.method_5805()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setExplodeState(1);
            }
            if ((i = this.getExplodeState()) > 0 && this.timeSinceIgnited == 0) {
                this.method_5783((class_3414)ModSoundEvents.ENTITY_CREEPER_MINION_PRIMED_SOUND_EVENT.comp_349(), 1.0f, this.method_6017());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 26) {
                this.timeSinceIgnited = 0;
                class_1937 class_19372 = this.method_73183();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    float sizeIn = this.getExplosionRadius() + (this.isCharged() ? 2.0f : 0.0f);
                    class_1937.class_7867 interaction = this.canDestroyBlocks() ? class_1937.class_7867.field_40890 : class_1937.class_7867.field_40888;
                    MutatedExplosionHelper.explode((class_1297)this, sizeIn, false, interaction);
                    if (!this.canExplodeContinuously()) {
                        class_1309 class_13092;
                        if (serverLevel.method_64395().method_8355(class_1928.field_19398) && (class_13092 = this.method_35057()) instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)class_13092;
                            serverPlayer.method_64398((class_2561)class_2561.method_43469((String)"death.attack.explosion", (Object[])new Object[]{this.method_5476()}));
                        }
                        this.field_6272 = true;
                        this.method_31472();
                        EntityUtil.spawnLingeringCloud((class_1309)this);
                    }
                }
                this.setExplodeState(-26);
            }
            if (this.method_18798().method_1027() > (double)0.8f && this.method_5968() != null && this.method_5829().method_18804(this.method_18798()).method_1014(0.5).method_994(this.method_5968().method_5829())) {
                this.timeSinceIgnited = 26;
            }
        }
        super.method_5773();
    }

    public float getSwelling(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / 24.0f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (this.method_6181()) {
            if (itemInHand.method_31574((class_1792)ModItems.CREEPER_MINION_TRACKER_ITEM.comp_349())) {
                if (this.method_73183().method_8608()) {
                    Proxy.INSTANCE.displayCreeperMinionTrackerGUI(this);
                }
                return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
            }
            if (this.method_6171((class_1309)player)) {
                if (itemInHand.method_31574(class_1802.field_8054)) {
                    if (this.method_6032() < this.method_6063() || this.method_6063() < 20.0f) {
                        if (!this.method_73183().method_8608()) {
                            this.method_5996(class_5134.field_23716).method_6192(Math.min(20.0, (double)this.method_6063() + 1.0));
                            this.method_6025(1.0f);
                            itemInHand.method_57008(1, (class_1309)player);
                        } else {
                            double speedX = this.field_5974.method_43059() * 0.02;
                            double speedY = this.field_5974.method_43059() * 0.02;
                            double speedZ = this.field_5974.method_43059() * 0.02;
                            this.method_73183().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), speedX, speedY, speedZ);
                        }
                        return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
                    }
                } else if (itemInHand.method_31574(class_1802.field_8626)) {
                    float explosionRadius = this.getExplosionRadius();
                    if (explosionRadius < 4.0f) {
                        this.field_5947 += 15;
                        if (!this.method_73183().method_8608()) {
                            this.setCanExplodeContinuously(true);
                            this.setExplosionRadius(explosionRadius + 0.2f);
                            itemInHand.method_57008(1, (class_1309)player);
                        }
                        return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
                    }
                } else {
                    if (!this.method_73183().method_8608()) {
                        this.method_24346(!this.method_24345());
                        this.method_6015(null);
                        this.method_5980(null);
                    }
                    return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
                }
            }
            return class_1269.field_5811;
        }
        if (itemInHand.method_31573(class_3489.field_41662) && !this.hasIgnited()) {
            player.method_7259(class_3468.field_15372.method_14956((Object)itemInHand.method_7909()));
            this.method_73183().method_43128((class_1297)player, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15145, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_73183().method_8608()) {
                this.ignite();
                if (!itemInHand.method_7963()) {
                    itemInHand.method_7934(1);
                } else {
                    ItemHelper.hurtAndBreak((class_1799)itemInHand, (int)1, (class_1309)player, (class_1268)interactionHand);
                }
            }
            return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
        }
        if (player.method_68878() && itemInHand.method_31574((class_1792)ModItems.CREEPER_MINION_TRACKER_ITEM.comp_349()) && this.method_35057() == null) {
            if (!this.method_73183().method_8608() && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.method_6173(true, true);
                this.method_6174((class_1309)player);
                serverPlayer.method_64398((class_2561)class_2561.method_43469((String)(((class_1792)ModItems.CREEPER_MINION_TRACKER_ITEM.comp_349()).method_7876() + ".tame_success"), (Object[])new Object[]{this.method_5476(), player.method_5476()}));
            }
            return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
        }
        return class_1269.field_5811;
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        return EntityUtil.shouldAttackEntity(target, owner, true);
    }

    public boolean method_6121(class_3218 serverLevel, class_1297 entity) {
        return true;
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float damageAmount) {
        if (this.method_5679(serverLevel, damageSource)) {
            return false;
        }
        if (damageSource.method_48789(class_8103.field_42249)) {
            if (this.method_6181()) {
                return false;
            }
            if (damageAmount >= 2.0f) {
                damageAmount = 2.0f;
            }
        }
        this.method_24346(false);
        return super.method_64397(serverLevel, damageSource, damageAmount);
    }

    public boolean method_5659(class_1927 explosion) {
        return this.method_6181();
    }

    public boolean method_5931() {
        return super.method_5931() && this.method_6181();
    }

    public boolean method_5973(class_1299<?> entityType) {
        return super.method_5973(entityType) && entityType != ModEntityTypes.MUTANT_CREEPER_ENTITY_TYPE.comp_349();
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_6181();
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.72f * this.method_5751()), (double)(this.method_17681() * 0.2f));
    }

    @Nullable
    public class_268 method_5781() {
        class_1309 owner = this.method_35057();
        return owner != null ? owner.method_5781() : super.method_5781();
    }

    public class_1296 method_5613(class_3218 level, class_1296 otherParent) {
        return null;
    }

    public void method_5966() {
        if (this.method_5968() == null && this.getExplodeState() <= 0) {
            super.method_5966();
        }
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.5f;
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSoundEvents.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.comp_349();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSoundEvents.ENTITY_CREEPER_MINION_HURT_SOUND_EVENT.comp_349();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSoundEvents.ENTITY_CREEPER_MINION_DEATH_SOUND_EVENT.comp_349();
    }

    public class_3419 method_5634() {
        return this.method_6181() ? class_3419.field_15254 : class_3419.field_15251;
    }

    public void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71472("Tamed", this.method_6181());
        valueOutput.method_71472("ExplodesContinuously", this.canExplodeContinuously());
        valueOutput.method_71472("DestroysBlocks", this.canDestroyBlocks());
        valueOutput.method_71472("CanRideOnShoulder", this.canRideOnShoulder());
        valueOutput.method_71472("Ignited", this.hasIgnited());
        valueOutput.method_71464("ExplosionRadius", this.getExplosionRadius());
        valueOutput.method_71472("Powered", this.isCharged());
        valueOutput.method_71472("dropped_skulls", this.droppedSkulls);
    }

    public void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.method_6173(valueInput.method_71433("Tamed", false), false);
        this.setCanExplodeContinuously(valueInput.method_71433("ExplodesContinuously", false));
        this.setDestroyBlocks(valueInput.method_71433("DestroysBlocks", false));
        this.setCanRideOnShoulder(valueInput.method_71433("CanRideOnShoulder", false));
        if (valueInput.method_71433("Ignited", false)) {
            this.ignite();
        }
        this.setExplosionRadius(valueInput.method_71423("ExplosionRadius", 0.0f));
        this.setCharged(valueInput.method_71433("Powered", false));
        this.droppedSkulls = valueInput.method_71433("dropped_skulls", false);
    }

    class CreeperMinionSwellGoal
    extends class_1352 {
        public CreeperMinionSwellGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 livingentity = CreeperMinion.this.method_5968();
            return !CreeperMinion.this.method_24345() && (CreeperMinion.this.getExplodeState() > 0 || livingentity != null && CreeperMinion.this.method_5858((class_1297)livingentity) < 9.0 && CreeperMinion.this.method_6057((class_1297)livingentity));
        }

        public void method_6268() {
            CreeperMinion.this.setExplodeState(CreeperMinion.this.method_5968() != null && !(CreeperMinion.this.method_5858((class_1297)CreeperMinion.this.method_5968()) > 36.0) && CreeperMinion.this.method_5985().method_6369((class_1297)CreeperMinion.this.method_5968()) ? 1 : -1);
        }

        public void method_6269() {
            CreeperMinion.this.method_5942().method_6340();
        }
    }

    class CreeperMinionFollowOwnerGoal
    extends class_1350 {
        public CreeperMinionFollowOwnerGoal() {
            super((class_1321)CreeperMinion.this, 1.2, 10.0f, 5.0f);
        }

        public void method_6268() {
            if (!CreeperMinion.this.method_6181()) {
                if (CreeperMinion.this.method_35057() != null) {
                    CreeperMinion.this.method_5942().method_6335((class_1297)CreeperMinion.this.method_35057(), 1.2);
                }
            } else {
                super.method_6268();
            }
        }
    }
}

