/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.services.CommonAbstractions;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10583;
import net.minecraft.class_10584;
import net.minecraft.class_10599;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_6025;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class CreeperMinionEgg
extends class_1297
implements class_6025 {
    private static final class_2940<Boolean> DATA_CHARGED = class_2945.method_12791(CreeperMinionEgg.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<class_10583<class_1309>>> DATA_OWNERUUID_ID = class_2945.method_12791(CreeperMinionEgg.class, (class_2941)class_2943.field_55584);
    private final class_10584 interpolation = new class_10584((class_1297)this);
    private int health = 8;
    private int age = (60 + this.field_5974.method_43048(40)) * 1200;
    private int recentlyHit;
    private int dismountTicks;

    public CreeperMinionEgg(class_1299<? extends CreeperMinionEgg> entityType, class_1937 level) {
        super(entityType, level);
        this.field_23807 = true;
    }

    public CreeperMinionEgg(MutantCreeper spawner) {
        this((class_1299<? extends CreeperMinionEgg>)((class_1299)ModEntityTypes.CREEPER_MINION_EGG_ENTITY_TYPE.comp_349()), spawner.method_73183());
        this.method_5814(spawner.method_23317(), spawner.method_23318(), spawner.method_23321());
        this.setCharged(spawner.isCharged());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_CHARGED, (Object)false);
        builder.method_56912(DATA_OWNERUUID_ID, Optional.empty());
    }

    private void setHealth(int health) {
        this.health = health;
    }

    private void setAge(int age) {
        this.age = age;
    }

    @Nullable
    public class_10583<class_1309> method_66287() {
        return ((Optional)this.field_6011.method_12789(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwner(@Nullable class_1657 livingEntity) {
        this.field_6011.method_12778(DATA_OWNERUUID_ID, Optional.ofNullable(livingEntity).map(class_10583::method_73299));
    }

    public void setOwnerReference(@Nullable class_10583<class_1309> entityReference) {
        this.field_6011.method_12778(DATA_OWNERUUID_ID, Optional.ofNullable(entityReference));
    }

    public boolean isCharged() {
        return (Boolean)this.field_6011.method_12789(DATA_CHARGED);
    }

    public void setCharged(boolean charged) {
        this.field_6011.method_12778(DATA_CHARGED, (Object)charged);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public boolean method_30949(class_1297 entity) {
        return class_1690.method_64486((class_1297)this, (class_1297)entity);
    }

    public boolean method_5863() {
        return this.method_5805();
    }

    public boolean method_5810() {
        return this.method_5805();
    }

    public class_10584 method_66233() {
        return this.interpolation;
    }

    public void method_5800(class_3218 serverLevel, class_1538 lightningBolt) {
        super.method_5800(serverLevel, lightningBolt);
        this.setCharged(true);
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1023(0.0, 0.04, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.98));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.7, 0.0, 0.7));
        }
        if (this.method_5765()) {
            if (this.method_31483() != null) {
                this.dismountTicks = 10;
            } else if (this.dismountTicks > 0) {
                --this.dismountTicks;
            }
            class_1297 rootVehicle = this.method_5668();
            if (this.method_5757() || !rootVehicle.method_41328(class_4050.field_18076) && !rootVehicle.method_41328(class_4050.field_18081) || this.dismountTicks <= 0 && rootVehicle.method_5715() || rootVehicle.method_7325()) {
                this.method_5848();
                this.playMountingSound(false);
            }
        }
        if ((class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.health < 8 && this.field_6012 - this.recentlyHit > 80 && this.field_6012 % 20 == 0) {
                ++this.health;
            }
            if (--this.age <= 0) {
                class_10583<class_1309> entityReference = this.method_66287();
                if (entityReference != null) {
                    class_1657 player;
                    class_10599 class_105992 = entityReference.method_73298(this.method_73183(), class_1309.class);
                    if (class_105992 instanceof class_1657 && this.method_5858((class_1297)(player = (class_1657)class_105992)) < 4096.0) {
                        this.hatch(player);
                    } else {
                        this.age = 1200;
                    }
                } else {
                    this.method_64397(serverLevel, this.method_48923().method_48831(), 1000.0f);
                }
            }
        }
    }

    private void hatch(class_1657 player) {
        CreeperMinion creeperMinion = (CreeperMinion)((class_1299)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.comp_349()).method_5883(this.method_73183(), class_3730.field_16466);
        if (creeperMinion != null) {
            if (!CommonAbstractions.INSTANCE.onAnimalTame((class_1429)creeperMinion, player)) {
                creeperMinion.method_6170(player);
                creeperMinion.method_24346(true);
            }
            creeperMinion.setCharged(this.isCharged());
            creeperMinion.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
            this.method_73183().method_8649((class_1297)creeperMinion);
            this.method_5783((class_3414)ModSoundEvents.ENTITY_CREEPER_MINION_EGG_HATCH_SOUND_EVENT.comp_349(), 0.7f, 0.9f + this.field_5974.method_43057() * 0.1f);
            this.method_31472();
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        if (!player.method_21823() && player.method_41328(class_4050.field_18076) && !player.method_5626((class_1297)this) && this.method_5804(this.getTopPassenger((class_1297)player))) {
            if (!this.method_73183().method_8608()) {
                this.setOwner(player);
                this.playMountingSound(true);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"mount.onboard", (Object[])new Object[]{class_2561.method_43472((String)"key.sneak")}), true);
            }
            return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
        }
        return super.method_5688(player, interactionHand);
    }

    private class_1297 getTopPassenger(class_1297 entity) {
        List list = entity.method_5685();
        return !list.isEmpty() ? this.getTopPassenger((class_1297)list.getFirst()) : entity;
    }

    private void playMountingSound(boolean isMounting) {
        this.method_5783(class_3417.field_15197, 0.7f, (isMounting ? 0.6f : 0.3f) + this.field_5974.method_43057() * 0.1f);
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float damageAmount) {
        if (this.method_64421(damageSource)) {
            return false;
        }
        if (this.method_5805()) {
            this.method_5785();
            if (damageSource.method_48789(class_8103.field_42249)) {
                this.age = (int)((float)this.age - damageAmount * 80.0f);
                EntityUtil.sendParticlePacket(this, (class_2394)class_2398.field_11201, (int)(damageAmount / 2.0f));
                return false;
            }
            this.recentlyHit = this.field_6012;
            this.method_18800(0.0, 0.2, 0.0);
            this.health = (int)((float)this.health - damageAmount);
            if (this.health <= 0) {
                float sizeIn = this.isCharged() ? 2.0f : 0.0f;
                MutatedExplosionHelper.explode(this, sizeIn, false, class_1937.class_7867.field_40891);
                if (serverLevel.method_64395().method_8355(class_1928.field_19393)) {
                    if (!this.isCharged() && this.field_5974.method_43048(3) != 0) {
                        for (int i = 5 + this.field_5974.method_43048(6); i > 0; --i) {
                            this.method_5706(serverLevel, (class_1935)class_1802.field_8054);
                        }
                    } else {
                        this.method_5706(serverLevel, (class_1935)ModItems.CREEPER_SHARD_ITEM.comp_349());
                    }
                }
                this.method_31472();
            }
            return true;
        }
        return false;
    }

    protected void method_5652(class_11372 valueOutput) {
        valueOutput.method_71465("Health", this.health);
        valueOutput.method_71465("Age", this.age);
        valueOutput.method_71465("RecentlyHit", this.recentlyHit);
        valueOutput.method_71472("Charged", this.isCharged());
        valueOutput.method_71462("DismountTicks", (byte)this.dismountTicks);
        class_10583<class_1309> entityReference = this.method_66287();
        if (entityReference != null) {
            entityReference.method_66259(valueOutput, "Owner");
        }
    }

    protected void method_5749(class_11368 valueInput) {
        valueInput.method_71439("Health").ifPresent(this::setHealth);
        valueInput.method_71439("Age").ifPresent(this::setAge);
        this.recentlyHit = valueInput.method_71424("RecentlyHit", 0);
        this.setCharged(valueInput.method_71433("Charged", false));
        this.dismountTicks = valueInput.method_71421("DismountTicks", (byte)0);
        this.setOwnerReference((class_10583<class_1309>)class_10583.method_66260((class_11368)valueInput, (String)"Owner", (class_1937)this.method_73183()));
    }
}

