/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.puzzleslib.api.util.v1.DamageHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4538;
import net.minecraft.class_4844;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public class EndersoulFragment
extends class_1297
implements class_8046 {
    @Nullable
    private final MutantEnderman spawner;
    public final float[][] stickRotations = new float[8][3];
    private int explodeTick = 20 + this.field_5974.method_43048(20);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private class_1297 cachedOwner;

    private EndersoulFragment(class_1299<? extends EndersoulFragment> entityType, class_1937 level, MutantEnderman mutantEnderman) {
        super(entityType, level);
        this.spawner = mutantEnderman;
        for (int i = 0; i < this.stickRotations.length; ++i) {
            for (int j = 0; j < this.stickRotations[i].length; ++j) {
                this.stickRotations[i][j] = this.field_5974.method_43057() * 2.0f * (float)Math.PI;
            }
        }
    }

    public EndersoulFragment(class_1299<? extends EndersoulFragment> entityType, class_1937 level) {
        this(entityType, level, null);
    }

    public EndersoulFragment(class_1937 level, MutantEnderman mutantEnderman) {
        this((class_1299<? extends EndersoulFragment>)((class_1299)ModEntityTypes.ENDERSOUL_FRAGMENT_ENTITY_TYPE.comp_349()), level, mutantEnderman);
    }

    public static boolean isProtected(class_1297 entity) {
        class_1309 livingEntity;
        return entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_24518((class_1792)ModItems.ENDERSOUL_HAND_ITEM.comp_349());
    }

    private void setExplodeTick(int explodeTick) {
        this.explodeTick = explodeTick;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void setOwner(@Nullable class_1297 owner) {
        if (owner != null) {
            this.ownerUUID = owner.method_5667();
            this.cachedOwner = owner;
        }
    }

    @Nullable
    public class_1297 method_24921() {
        if (this.cachedOwner != null && !this.cachedOwner.method_31481()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null) {
            this.cachedOwner = this.findOwner(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @Nullable
    protected class_1297 findOwner(UUID entityUuid) {
        class_1297 class_12972;
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_12972 = serverLevel.method_66347(entityUuid);
        } else {
            class_12972 = null;
        }
        return class_12972;
    }

    public boolean ownedBy(class_1297 entity) {
        return entity.method_5667().equals(this.ownerUUID);
    }

    protected void setOwnerThroughUUID(@Nullable UUID uuid) {
        if (!Objects.equals(this.ownerUUID, uuid)) {
            this.ownerUUID = uuid;
            this.cachedOwner = uuid != null ? this.findOwner(uuid) : null;
        }
    }

    public void method_5878(class_1297 entity) {
        super.method_5878(entity);
        if (entity instanceof EndersoulFragment) {
            EndersoulFragment endersoulFragment = (EndersoulFragment)entity;
            this.ownerUUID = endersoulFragment.ownerUUID;
            this.cachedOwner = endersoulFragment.cachedOwner;
        }
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5863() {
        return this.method_5805();
    }

    public boolean method_5810() {
        return this.method_5805();
    }

    public void method_5711(byte id) {
        if (id == 3) {
            EntityUtil.spawnEndersoulParticles(this, this.field_5974, 64, 0.8f);
        } else {
            super.method_5711(id);
        }
    }

    public void method_5773() {
        super.method_5773();
        class_1297 owner = this.method_24921();
        if (owner == null) {
            vec3 = this.method_18798();
            if (vec3.field_1351 > -0.05 && !this.method_5740()) {
                this.method_18800(vec3.field_1352, Math.max(-0.05, vec3.field_1351 - 0.1), vec3.field_1350);
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            this.field_5960 = true;
            vec3 = new class_243(owner.method_23317() - this.method_23317(), owner.method_23318() + (double)owner.method_5751() / 2.0 - this.method_23318(), owner.method_23321() - this.method_23321());
            this.method_23327(this.method_23317(), this.method_23318() + vec3.field_1351 * 0.015, this.method_23321());
            this.method_18799(this.method_18798().method_1021(0.9).method_1019(vec3.method_1029().method_1021(0.05)));
            this.method_33574(this.method_73189().method_1019(this.method_18798()));
            this.method_61409();
        }
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (--this.explodeTick <= 0) {
                this.explode(serverLevel);
            }
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        if (!this.ownedBy((class_1297)player) && !player.method_21823()) {
            this.setOwner((class_1297)player);
            this.explodeTick += 600;
            this.method_5783(class_3417.field_15210, 1.0f, 0.8f + this.method_73183().field_9229.method_43057() * 0.4f);
            return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
        }
        return super.method_5688(player, interactionHand);
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float amount) {
        if (this.method_64421(damageSource)) {
            return false;
        }
        if (this.method_5805() && this.field_6012 > 0) {
            this.explode(serverLevel);
        }
        return true;
    }

    private void explode(class_3218 serverLevel) {
        this.method_5783((class_3414)ModSoundEvents.ENTITY_ENDERSOUL_FRAGMENT_EXPLODE_SOUND_EVENT.comp_349(), 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        serverLevel.method_8421((class_1297)this, (byte)3);
        for (class_1297 entity : serverLevel.method_8333((class_1297)this, this.method_5829().method_1014(5.0), MutantEnderman.ENDER_TARGETS)) {
            boolean hitChance;
            if (this.ownedBy(entity)) continue;
            boolean bl = hitChance = this.field_5974.method_43048(3) != 0;
            if (EndersoulFragment.isProtected(entity)) {
                hitChance = this.field_5974.method_43048(3) == 0;
            } else {
                double x = entity.method_23317() - this.method_23317();
                double z = entity.method_23321() - this.method_23321();
                double d = Math.sqrt(x * x + z * z);
                entity.method_18800(0.8 * x / d, (double)(this.field_5974.method_43057() * 0.6f - 0.1f), 0.8 * z / d);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
            if (!hitChance) continue;
            class_1282 damageSource = DamageHelper.damageSource((class_4538)serverLevel, ModRegistry.ENDERSOUL_FRAGMENT_EXPLOSION_DAMAGE_TYPE, (class_1297)this, (class_1297)(this.spawner != null ? this.spawner : this));
            entity.method_64397(serverLevel, damageSource, 1.0f);
        }
        this.method_31472();
    }

    protected void method_5652(class_11372 valueOutput) {
        valueOutput.method_71477("Owner", class_4844.field_25122, (Object)this.ownerUUID);
        valueOutput.method_71465("ExplodeTick", this.explodeTick);
    }

    protected void method_5749(class_11368 valueInput) {
        this.setOwnerThroughUUID(valueInput.method_71426("Owner", class_4844.field_25122).orElse(null));
        valueInput.method_71439("ExplodeTick").ifPresent(this::setExplodeTick);
    }
}

