/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.init.ModTags;
import fuzs.mutantmonsters.services.CommonAbstractions;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.OwnerTargetGoal;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_10179;
import net.minecraft.class_10192;
import net.minecraft.class_10583;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1316;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1404;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2560;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4174;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SpiderPig
extends class_1321
implements class_1316,
class_5354 {
    private static final class_2960 STEP_HEIGHT_MODIFIER_WITH_PASSENGER_ID = MutantMonsters.id("with_passenger");
    private static final class_1322 STEP_HEIGHT_MODIFIER_WITH_PASSENGER = new class_1322(STEP_HEIGHT_MODIFIER_WITH_PASSENGER_ID, 0.4, class_1322.class_1323.field_6328);
    private static final class_2940<Boolean> DATA_CLIMBING = class_2945.method_12791(SpiderPig.class, (class_2941)class_2943.field_13323);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private final List<WebPos> webs = new ArrayList<WebPos>(12);
    private int leapCooldown;
    private int leapTick;
    private boolean isLeaping;
    private float chargePower;
    private int chargingTick;
    private int chargeExhaustion;
    private boolean chargeExhausted;
    private int angerTime;
    private UUID angerTarget;

    public SpiderPig(class_1299<? extends SpiderPig> type, class_1937 level) {
        super(type, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return SpiderPig.method_61457().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23719, 0.25).method_26867(class_5134.field_47761);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.1).setMaxAttackTick(16));
        this.field_6201.method_6277(2, (class_1352)new LeapAttackGoal());
        this.field_6201.method_6277(3, (class_1352)new AvoidDamageGoal((class_1314)this, 1.1, () -> ((SpiderPig)this).method_6109()));
        this.field_6201.method_6277(4, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 5.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1391((class_1314)this, 1.1, (Predicate)class_1856.method_8101((class_1935)class_1802.field_8184), false));
        this.field_6201.method_6277(6, (class_1352)new class_1391((class_1314)this, 1.1, this::method_6481, false));
        this.field_6201.method_6277(7, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new OwnerTargetGoal(this));
        this.field_6185.method_6277(1, (class_1352)new HurtByNearestTargetGoal((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, (arg_0, arg_1) -> ((SpiderPig)this).method_29515(arg_0, arg_1)));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, class_1308.class, true, (livingEntity, serverLevel) -> livingEntity.method_5864().method_20210(ModTags.SPIDER_PIG_TARGETS_ENTITY_TYPE_TAG)));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, true));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_CLIMBING, (Object)false);
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_6011.method_12789(DATA_CLIMBING);
    }

    private void setBesideClimbableBlock(boolean climbing) {
        this.field_6011.method_12778(DATA_CLIMBING, (Object)climbing);
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new class_1410((class_1308)this, worldIn);
    }

    public boolean method_6049(class_1293 mobEffect) {
        return mobEffect.method_5579() != class_1294.field_5899 && super.method_6049(mobEffect);
    }

    public boolean method_6481(class_1799 itemStack) {
        return itemStack.method_31573(ModTags.SPIDER_PIG_FOOD_ITEM_TAG);
    }

    public void method_5773() {
        super.method_5773();
        this.setBesideClimbableBlock(this.field_5976);
        if (this.chargeExhaustion >= 120) {
            this.chargeExhausted = true;
        }
        if (this.chargeExhaustion <= 0) {
            this.chargeExhausted = false;
        }
        this.chargeExhaustion = Math.max(0, this.chargeExhaustion - 1);
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.method_29510(serverLevel, true);
            this.leapCooldown = Math.max(0, this.leapCooldown - 1);
            if (this.leapTick > 10 && this.method_24828()) {
                this.isLeaping = false;
            }
            this.updateWebList(serverLevel, false);
            this.updateChargeState(serverLevel);
            if (this.method_5805() && this.method_6181() && this.field_6012 % 600 == 0) {
                this.method_6025(1.0f);
            }
        }
    }

    private void updateWebList(class_3218 serverLevel, boolean onlyCheckSize) {
        WebPos first;
        if (!onlyCheckSize) {
            for (int i = 0; i < this.webs.size(); ++i) {
                WebPos coord = this.webs.get(i);
                if (this.method_73183().method_8320((class_2338)coord) != class_2246.field_10343.method_9564()) {
                    this.webs.remove(i);
                    --i;
                    continue;
                }
                --coord.timeLeft;
            }
            if (!this.webs.isEmpty()) {
                first = this.webs.get(0);
                if (first.timeLeft < 0) {
                    this.webs.remove(0);
                    this.removeWeb(serverLevel, first);
                }
            }
        }
        while (this.webs.size() > 12) {
            first = this.webs.remove(0);
            this.removeWeb(serverLevel, first);
        }
    }

    private void removeWeb(class_3218 serverLevel, class_2338 pos) {
        if (this.method_73183().method_8320(pos).method_27852(class_2246.field_10343) && EntityHelper.isMobGriefingAllowed((class_3218)serverLevel, (class_1297)this)) {
            this.method_73183().method_8651(pos, false, (class_1297)this);
        }
    }

    private void updateChargeState(class_3218 serverLevel) {
        if (this.chargingTick > 0) {
            for (class_1309 livingEntity : this.method_73183().method_8390(class_1309.class, this.method_5829(), class_1301.method_5913((class_1297)this))) {
                if (livingEntity == this || livingEntity == this.method_35057() || !livingEntity.method_6102()) continue;
                this.method_6121(serverLevel, (class_1297)livingEntity);
            }
        }
        this.chargingTick = Math.max(0, this.chargingTick - 1);
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (!this.method_5782()) {
            if (this.method_6481(itemInHand) && itemInHand.method_57826(class_9334.field_50075) && this.method_6032() < this.method_6063()) {
                this.method_6475(player, interactionHand, itemInHand);
                this.method_6025(((class_4174)itemInHand.method_58694(class_9334.field_50075)).comp_2491());
                return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
            }
            class_1269 interactionResult = super.method_5992(player, interactionHand);
            if (!interactionResult.method_23665()) {
                if (this.method_66672() && !player.method_21823() && this.method_6171((class_1309)player)) {
                    if (!this.method_73183().method_8608()) {
                        player.method_5804((class_1297)this);
                    }
                    return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
                }
                if (this.method_63623(itemInHand, class_1304.field_55946)) {
                    return itemInHand.method_7920(player, (class_1309)this, interactionHand);
                }
            } else {
                return interactionResult;
            }
        }
        return class_1269.field_5811;
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        return EntityUtil.shouldAttackEntity(target, owner, false);
    }

    public boolean method_6121(class_3218 serverLevel, class_1297 target) {
        class_1282 damageSource;
        this.isLeaping = false;
        if (this.field_5974.method_43048(2) == 0 && EntityHelper.isMobGriefingAllowed((class_3218)serverLevel, (class_1297)this)) {
            double dx = target.method_23317() - target.field_6014;
            double dz = target.method_23321() - target.field_5969;
            class_2338 pos = new class_2338((int)(target.method_23317() + dx * 0.5), class_3532.method_15357((double)this.method_5829().field_1322), (int)(target.method_23321() + dz * 0.5));
            class_2680 state = serverLevel.method_8320(pos);
            if (!(state.method_51367() || state.method_51176() || state.method_26204() instanceof class_2560)) {
                serverLevel.method_8501(pos, class_2246.field_10343.method_9564());
                this.webs.add(new WebPos(pos, this.chargingTick > 0 ? 600 : 1200));
                this.updateWebList(serverLevel, true);
                this.method_18800(0.0, Math.max(0.25, this.method_18798().field_1351), 0.0);
                this.field_6017 = 0.0;
            }
        }
        float damageAmount = (float)this.method_45325(class_5134.field_23721);
        if (target.method_5864() != this.method_5864() && !target.method_5864().method_20210(ModTags.SPIDER_PIG_FRIENDS_ENTITY_TYPE_TAG)) {
            if (this.method_73183().method_29546(target.method_5829()).anyMatch(arg_0 -> ((class_2680)class_2246.field_10343.method_9564()).equals(arg_0))) {
                damageAmount += 4.0f;
            }
        }
        if (target.method_64397(serverLevel, damageSource = this.method_73183().method_48963().method_48812((class_1309)this), damageAmount)) {
            class_1890.method_60107((class_3218)serverLevel, (class_1297)target, (class_1282)damageSource);
            return true;
        }
        return false;
    }

    public boolean method_6153() {
        return this.method_66672() && !this.chargeExhausted && !this.field_5976;
    }

    public void method_6154(int jumpPowerIn) {
        this.chargeExhaustion += 50 * jumpPowerIn / 100;
        this.chargePower = (float)jumpPowerIn / 100.0f;
    }

    public void method_6155(int jumpPowerIn) {
        this.chargingTick = 8 * jumpPowerIn / 100;
    }

    public void method_6156() {
    }

    public boolean method_56991(class_1304 slot) {
        return slot != class_1304.field_55946 ? super.method_56991(slot) : this.method_5805() && this.method_6181() && !this.method_6109();
    }

    protected boolean method_63626(class_1304 slot) {
        return slot == class_1304.field_55946 || super.method_63626(slot);
    }

    protected class_6880<class_3414> method_66667(class_1304 equipmentSlot, class_1799 itemStack, class_10192 equippable) {
        return equipmentSlot == class_1304.field_55946 ? class_3417.field_14824 : super.method_66667(equipmentSlot, itemStack, equippable);
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID method_29508() {
        return this.angerTarget;
    }

    public void method_29513(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    protected boolean method_6062() {
        return super.method_6062() || this.method_5782() && this.method_66672();
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 entity;
        class_1297 class_12972 = this.method_31483();
        return class_12972 instanceof class_1309 ? (entity = (class_1309)class_12972) : null;
    }

    public class_243 method_24829(class_1309 livingEntity) {
        class_2350 direction = this.method_5755();
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return super.method_24829(livingEntity);
        }
        int[][] aint = class_5275.method_27934((class_2350)direction);
        class_2338 blockpos = this.method_24515();
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (class_4050 pose : livingEntity.method_24831()) {
            class_238 axisalignedbb = livingEntity.method_24833(pose);
            for (int[] aint1 : aint) {
                blockpos$mutable.method_10103(blockpos.method_10263() + aint1[0], blockpos.method_10264(), blockpos.method_10260() + aint1[1]);
                double d0 = this.method_73183().method_30347((class_2338)blockpos$mutable);
                if (!class_5275.method_27932((double)d0)) continue;
                class_243 vector3d = class_243.method_26410((class_2382)blockpos$mutable, (double)d0);
                if (!class_5275.method_27933((class_1941)this.method_73183(), (class_1309)livingEntity, (class_238)axisalignedbb.method_997(vector3d))) continue;
                livingEntity.method_18380(pose);
                return vector3d;
            }
        }
        return super.method_24829(livingEntity);
    }

    public void method_6091(class_243 travelVector) {
        class_1324 attribute = this.method_5996(class_5134.field_47761);
        if (this.method_5782() && this.method_5642() != null && this.method_66672()) {
            class_1309 passenger = this.method_5642();
            if (!attribute.method_6196(STEP_HEIGHT_MODIFIER_WITH_PASSENGER_ID)) {
                attribute.method_26835(STEP_HEIGHT_MODIFIER_WITH_PASSENGER);
            }
            this.method_36456(passenger.method_36454());
            this.field_5982 = this.method_36454();
            this.method_36457(passenger.method_36455() * 0.5f);
            this.method_5710(this.method_36454(), this.method_36455());
            this.field_6241 = this.field_6283 = this.method_36454();
            if (this.chargeExhausted || !(this.chargePower > 0.0f) || !this.method_24828() && this.method_55667().method_26227().method_15769()) {
                this.chargePower = 0.0f;
            } else {
                double power = 1.6 * (double)this.chargePower;
                class_243 lookVector = this.method_5720();
                this.method_18800(lookVector.field_1352 * power, 0.3 * (double)this.method_23313(), lookVector.field_1350 * power);
                this.chargePower = 0.0f;
            }
            if (this.method_66247()) {
                float strafe = passenger.field_6212 * 0.8f;
                float forward = passenger.field_6250 * 0.6f;
                this.method_6125((float)this.method_45325(class_5134.field_23719));
                super.method_6091(new class_243((double)strafe, travelVector.field_1351, (double)forward));
            } else if (passenger instanceof class_1657) {
                this.method_18799(class_243.field_1353);
            } else {
                this.method_29242(false);
            }
        } else {
            attribute.method_6200(STEP_HEIGHT_MODIFIER_WITH_PASSENGER_ID);
            super.method_6091(travelVector);
        }
    }

    public boolean method_5874(class_3218 serverLevel, class_1309 livingEntity, class_1282 damageSource) {
        if (livingEntity instanceof CreeperMinion) {
            CreeperMinion minion = (CreeperMinion)livingEntity;
            if (!this.method_6181()) {
                class_1309 owner = minion.method_35057();
                if (owner instanceof class_1657 && !CommonAbstractions.INSTANCE.onAnimalTame((class_1429)this, (class_1657)owner)) {
                    serverLevel.method_8421((class_1297)this, (byte)7);
                    this.method_6170((class_1657)owner);
                    minion.method_31472();
                    return false;
                }
                serverLevel.method_8421((class_1297)this, (byte)6);
            }
        }
        if (livingEntity.method_5864().method_20210(ModTags.SPIDER_PIG_TARGETS_ENTITY_TYPE_TAG) && livingEntity instanceof class_1308) {
            class_1308 mob = (class_1308)livingEntity;
            return mob.method_29243((class_1299)ModEntityTypes.SPIDER_PIG_ENTITY_TYPE.comp_349(), class_10179.method_63607((class_1308)this, (boolean)false, (boolean)false), Function.identity()::apply) == null;
        }
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_6181();
    }

    public boolean method_6101() {
        return this.isBesideClimbableBlock();
    }

    public void method_5844(class_2680 blockState, class_243 motionMultiplier) {
        if (!blockState.method_27852(class_2246.field_10343)) {
            super.method_5844(blockState, motionMultiplier);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableEntity) {
        if (this.field_5974.method_43048(20) == 0) {
            return (class_1296)class_1299.field_6093.method_5883((class_1937)serverLevel, class_3730.field_16466);
        }
        SpiderPig spiderPig = (SpiderPig)((class_1299)ModEntityTypes.SPIDER_PIG_ENTITY_TYPE.comp_349()).method_5883((class_1937)serverLevel, class_3730.field_16466);
        class_10583 ownerReference = this.method_66287();
        if (spiderPig != null && ownerReference != null) {
            spiderPig.method_66288(ownerReference);
            spiderPig.method_6173(true, true);
        }
        return spiderPig;
    }

    public void method_6078(class_1282 damageSource) {
        Object object;
        super.method_6078(damageSource);
        if (this.field_6272 && (object = this.method_73183()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)object;
            if (!this.webs.isEmpty()) {
                for (WebPos webPos : this.webs) {
                    this.removeWeb(serverLevel, webPos);
                }
            }
        }
    }

    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        this.method_29517(valueOutput);
        valueOutput.method_71468("Webs", WebPos.LIST_CODEC, this.webs);
    }

    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.method_29512(this.method_73183(), valueInput);
        valueInput.method_71426("Webs", WebPos.LIST_CODEC).ifPresent(this.webs::addAll);
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSoundEvents.ENTITY_SPIDER_PIG_AMBIENT_SOUND_EVENT.comp_349();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSoundEvents.ENTITY_SPIDER_PIG_HURT_SOUND_EVENT.comp_349();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSoundEvents.ENTITY_SPIDER_PIG_DEATH_SOUND_EVENT.comp_349();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
        this.method_5783(class_3417.field_14760, 0.15f, 1.0f);
    }

    class LeapAttackGoal
    extends class_1352 {
        LeapAttackGoal() {
        }

        public boolean method_6264() {
            class_1309 target = SpiderPig.this.method_5968();
            return target != null && SpiderPig.this.leapCooldown <= 0 && (SpiderPig.this.method_24828() || !SpiderPig.this.method_55667().method_26227().method_15769()) && (SpiderPig.this.method_5858((class_1297)target) < 64.0 && SpiderPig.this.field_5974.method_43048(8) == 0 || SpiderPig.this.method_5858((class_1297)target) < 6.25);
        }

        public void method_6269() {
            SpiderPig.this.isLeaping = true;
            SpiderPig.this.leapCooldown = 15;
            class_1309 target = SpiderPig.this.method_5968();
            double x = target.method_23317() - SpiderPig.this.method_23317();
            double y = target.method_23318() - SpiderPig.this.method_23318();
            double z = target.method_23321() - SpiderPig.this.method_23321();
            double d = class_3532.method_15355((float)((float)(x * x + y * y + z * z)));
            double scale = 2.0f + 0.2f * SpiderPig.this.field_5974.method_43057() * SpiderPig.this.field_5974.method_43057();
            SpiderPig.this.method_18800(x / d * scale, (y / d * scale * 0.5 + 0.3) * (double)SpiderPig.this.method_23313(), z / d * scale);
        }

        public boolean method_6266() {
            return SpiderPig.this.isLeaping && SpiderPig.this.leapTick < 40;
        }

        public void method_6268() {
            ++SpiderPig.this.leapTick;
        }

        public void method_6270() {
            SpiderPig.this.leapTick = 0;
        }
    }

    static final class WebPos
    extends class_2338 {
        public static final Codec<WebPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("block_pos").forGetter(WebPos::getBlockPos), (App)Codec.INT.fieldOf("time_left").forGetter(WebPos::getTimeLeft)).apply((Applicative)instance, WebPos::new));
        public static final Codec<List<WebPos>> LIST_CODEC = CODEC.listOf();
        int timeLeft;

        public WebPos(class_2338 pos, int timeLeft) {
            super((class_2382)pos);
            this.timeLeft = timeLeft;
        }

        public class_2338 getBlockPos() {
            return this;
        }

        public int getTimeLeft() {
            return this.timeLeft;
        }
    }
}

