/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.projectile;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.OptionalInt;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;

public class ThrowableBlock
extends class_1682 {
    private static final class_2940<OptionalInt> DATA_OWNER_ENTITY_ID = class_2945.method_12791(ThrowableBlock.class, (class_2941)class_2943.field_17910);
    private static final class_2940<class_2680> DATA_BLOCK_STATE_ID = class_2945.method_12791(ThrowableBlock.class, (class_2941)class_2943.field_13312);
    private static final class_2940<Boolean> DATA_IS_HELD = class_2945.method_12791(ThrowableBlock.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_LARGE = class_2945.method_12791(ThrowableBlock.class, (class_2941)class_2943.field_13323);

    public ThrowableBlock(class_1299<? extends ThrowableBlock> type, class_1937 level) {
        super(type, level);
    }

    public ThrowableBlock(double x, double y, double z, class_1309 livingEntity) {
        super((class_1299)ModEntityTypes.THROWABLE_BLOCK_ENTITY_TYPE.comp_349(), x, y, z, livingEntity.method_73183());
        this.method_7432((class_1297)livingEntity);
    }

    public ThrowableBlock(MutantEnderman mutantEnderman, int armIndex) {
        this(mutantEnderman.method_23317(), mutantEnderman.method_23318() + 4.7, mutantEnderman.method_23321(), (class_1309)mutantEnderman);
        this.setBlockState(mutantEnderman.getHeldBlock(armIndex).orElseGet(() -> ((class_2248)class_2246.field_10124).method_9564()));
        boolean outer = armIndex <= 1;
        boolean right = (armIndex & 1) == 0;
        class_1309 attackTarget = mutantEnderman.method_5968();
        class_243 forward = EntityUtil.getDirVector(this.method_36454(), outer ? 2.7f : 1.4f);
        class_243 strafe = EntityUtil.getDirVector(this.method_36454() + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.method_5814(this.method_23317() + forward.field_1352 + strafe.field_1352, this.method_23318() + (double)(outer ? 2.8f : 1.1f) - 4.8, this.method_23321() + forward.field_1350 + strafe.field_1350);
        if (attackTarget != null) {
            double d0 = attackTarget.method_23317() - this.method_23317();
            double d1 = attackTarget.method_23323(0.33) - this.method_23318();
            double d2 = attackTarget.method_23321() - this.method_23321();
            double d3 = class_3532.method_15355((float)((float)(d0 * d0 + d2 * d2)));
            this.method_7485(d0, d1 + d3 * 0.1, d2, 1.4f, 1.0f);
        } else {
            this.throwBlock((class_1309)mutantEnderman);
        }
    }

    public ThrowableBlock(MutantSnowGolem mutantSnowGolem) {
        this(mutantSnowGolem.method_23317(), mutantSnowGolem.method_23318() + 1.955 - 0.1 + 1.0, mutantSnowGolem.method_23321(), (class_1309)mutantSnowGolem);
        this.method_36456(mutantSnowGolem.method_36454());
        this.setBlockState(class_2246.field_10295.method_9564());
    }

    public ThrowableBlock(class_1657 player, class_2680 blockState, class_2338 blockPos) {
        this((double)blockPos.method_10263() + 0.5, blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, (class_1309)player);
        this.setBlockState(blockState);
        this.setHeld(true);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_OWNER_ENTITY_ID, (Object)OptionalInt.empty());
        builder.method_56912(DATA_BLOCK_STATE_ID, (Object)class_2246.field_10219.method_9564());
        builder.method_56912(DATA_IS_HELD, (Object)false);
        builder.method_56912(DATA_IS_LARGE, (Object)false);
    }

    public class_2680 getBlockState() {
        return (class_2680)this.field_6011.method_12789(DATA_BLOCK_STATE_ID);
    }

    private void setBlockState(class_2680 blockState) {
        this.field_6011.method_12778(DATA_BLOCK_STATE_ID, (Object)blockState);
    }

    public boolean isHeld() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_HELD);
    }

    private void setHeld(boolean held) {
        this.field_6011.method_12778(DATA_IS_HELD, (Object)held);
    }

    public boolean isLarge() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_LARGE);
    }

    public void method_7432(class_1297 entity) {
        super.method_7432(entity);
        if (entity != null) {
            this.field_6011.method_12778(DATA_OWNER_ENTITY_ID, (Object)OptionalInt.of(entity.method_5628()));
            this.field_6011.method_12778(DATA_IS_LARGE, (Object)this.isThrownBySnowGolem());
        }
    }

    public boolean isThrownBySnowGolem() {
        return this.method_24921() != null && this.method_24921().method_5864() == ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.comp_349();
    }

    protected double method_7490() {
        class_1299 entityType;
        class_1299 class_12992 = entityType = this.method_24921() != null ? this.method_24921().method_5864() : null;
        if (entityType == class_1299.field_6097) {
            return 0.04;
        }
        if (entityType == ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.comp_349()) {
            return 0.06;
        }
        return 0.01;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public boolean method_5863() {
        return this.method_5805() && !this.isThrownBySnowGolem();
    }

    public boolean method_5810() {
        return this.isHeld() && this.method_5805();
    }

    public void method_5697(class_1297 entityIn) {
        if (entityIn != this.method_24921()) {
            super.method_5697(entityIn);
        }
    }

    public void method_5711(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681();
                double y = this.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * this.method_17682());
                double z = this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681();
                double motx = (this.field_5974.method_43057() - this.field_5974.method_43057()) * 3.0f;
                double moty = 0.5f + this.field_5974.method_43057() * 2.0f;
                double motz = (this.field_5974.method_43057() - this.field_5974.method_43057()) * 3.0f;
                this.method_73183().method_8406((class_2394)new class_2388(class_2398.field_11217, this.getBlockState()), x, y, z, motx, moty, motz);
            }
        }
    }

    public void method_5773() {
        if (this.isHeld()) {
            if (!this.method_73183().method_8608()) {
                this.method_5729(6, this.method_36361());
            }
            this.method_5670();
            class_1297 thrower = this.method_24921();
            if (thrower == null) {
                class_1297 entity;
                OptionalInt optionalInt = (OptionalInt)this.field_6011.method_12789(DATA_OWNER_ENTITY_ID);
                if (optionalInt.isPresent() && (entity = this.method_73183().method_8469(optionalInt.getAsInt())) instanceof class_1309) {
                    thrower = entity;
                }
                if (thrower != null) {
                    this.method_7432(thrower);
                }
            } else if (thrower instanceof class_1309) {
                class_243 vec = thrower.method_5720();
                double x = thrower.method_23317() + vec.field_1352 * 1.6 - this.method_23317();
                double y = thrower.method_23320() + vec.field_1351 * 1.6 - this.method_23318();
                double z = thrower.method_23321() + vec.field_1350 * 1.6 - this.method_23321();
                double offset = 0.6;
                this.method_18800(x * offset, y * offset, z * offset);
                this.method_5784(class_1313.field_6308, this.method_18798());
                if (!(this.method_73183().method_8608() || thrower.method_5805() && !thrower.method_7325() && ((class_1309)thrower).method_24518((class_1792)ModItems.ENDERSOUL_HAND_ITEM.comp_349()))) {
                    this.setHeld(false);
                }
            }
        } else {
            super.method_5773();
            this.field_6007 = true;
        }
    }

    protected boolean method_26958(class_1297 entity) {
        if (!super.method_26958(entity)) {
            return false;
        }
        return !this.isThrownBySnowGolem() || MutantSnowGolem.canHarm(this.method_24921(), entity);
    }

    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (itemStack.method_7909() != ModItems.ENDERSOUL_HAND_ITEM.comp_349()) {
            return class_1269.field_5811;
        }
        if (this.isHeld()) {
            if (this.method_24921() == player) {
                if (!this.method_73183().method_8608()) {
                    this.setHeld(false);
                    this.throwBlock((class_1309)player);
                }
                ItemHelper.hurtAndBreak((class_1799)itemStack, (int)1, (class_1309)player, (class_1268)interactionHand);
                return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
            }
            return class_1269.field_5811;
        }
        if (!this.method_73183().method_8608()) {
            this.setHeld(true);
            this.method_7432((class_1297)player);
        }
        return InteractionResultHelper.sidedSuccess((boolean)this.method_73183().method_8608());
    }

    private void throwBlock(class_1309 thrower) {
        this.method_36456(thrower.method_36454());
        this.method_36457(thrower.method_36455());
        float f = 0.4f;
        this.method_7485(-class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180))) * f, -class_3532.method_15374((float)(this.method_36455() * ((float)Math.PI / 180))) * f, class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180))) * f, 1.4f, 1.0f);
    }

    protected void method_7488(class_239 hitResult) {
        class_1309 livingEntity;
        class_1297 thrower = this.method_24921();
        class_1309 class_13092 = livingEntity = thrower instanceof class_1309 ? (class_1309)thrower : null;
        if (this.isThrownBySnowGolem()) {
            class_1937 class_19372 = this.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                for (class_1308 mob : this.method_73183().method_8390(class_1308.class, this.method_5829().method_1009(2.5, 2.0, 2.5), this::method_26958)) {
                    if (!(this.method_5858((class_1297)mob) <= 6.25)) continue;
                    class_1282 damageSource = this.method_73183().method_48963().method_48800((class_1297)this, livingEntity);
                    mob.method_64397(serverLevel, damageSource, 4.0f + (float)this.field_5974.method_43048(3));
                }
                if (hitResult.method_17783() == class_239.class_240.field_1331) {
                    class_1297 entity = ((class_3966)hitResult).method_17782();
                    class_1282 damageSource = this.method_73183().method_48963().method_48811((class_1297)this, (class_1297)livingEntity);
                    entity.method_64397(serverLevel, damageSource, 4.0f);
                }
                if (!this.method_73183().method_8608()) {
                    this.method_73183().method_8421((class_1297)this, (byte)3);
                    this.method_31472();
                }
            }
            this.method_5783(this.getBlockState().method_26231().method_10595(), 0.8f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 0.8f);
        } else {
            class_3218 serverLevel;
            boolean throwerAllowedToPlace = ThrowableBlock.isThrowerAllowedToPlace(livingEntity);
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                blockHitResult = (class_3965)hitResult;
                this.method_24920(blockHitResult);
                class_1937 class_19373 = this.method_73183();
                if (class_19373 instanceof class_3218) {
                    class_3218 serverLevel2 = (class_3218)class_19373;
                    class_2338 blockPos = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
                    if (throwerAllowedToPlace && this.method_73183().method_8320(blockPos).method_45474() && this.getBlockState().method_26184((class_4538)this.method_73183(), blockPos)) {
                        this.method_73183().method_8501(blockPos, this.getBlockState());
                        this.getBlockState().method_26204().method_9567(this.method_73183(), blockPos, this.getBlockState(), livingEntity, class_1799.field_8037);
                        class_2498 soundType = this.getBlockState().method_26231();
                        this.method_5783(soundType.method_10598(), (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
                    } else {
                        this.method_73183().method_20290(2001, blockPos, class_2248.method_9507((class_2680)this.getBlockState()));
                        if (serverLevel2.method_64395().method_8355(class_1928.field_19393)) {
                            class_2248.method_9497((class_2680)this.getBlockState(), (class_1937)serverLevel2, (class_2338)this.method_24515());
                        }
                    }
                }
            } else {
                blockHitResult = this.method_73183();
                if (blockHitResult instanceof class_3218) {
                    serverLevel = (class_3218)blockHitResult;
                    if (hitResult.method_17783() == class_239.class_240.field_1331) {
                        class_1297 entity = ((class_3966)hitResult).method_17782();
                        class_1282 damageSource = serverLevel.method_48963().method_48811((class_1297)this, (class_1297)livingEntity);
                        entity.method_64397(serverLevel, damageSource, 4.0f);
                        this.method_73183().method_20290(2001, this.method_24515(), class_2248.method_9507((class_2680)this.getBlockState()));
                        if (serverLevel.method_64395().method_8355(class_1928.field_19393)) {
                            class_2248.method_9497((class_2680)this.getBlockState(), (class_1937)serverLevel, (class_2338)this.method_24515());
                        }
                    }
                }
            }
            class_1937 class_19374 = this.method_73183();
            if (class_19374 instanceof class_3218) {
                serverLevel = (class_3218)class_19374;
                for (class_1297 entity : this.method_73183().method_8333((class_1297)this, this.method_5829().method_1014(2.0), this::method_26958)) {
                    if (entity.method_5779((class_1297)livingEntity) || !(this.method_5858(entity) <= 4.0)) continue;
                    entity.method_64397(serverLevel, this.method_73183().method_48963().method_48800((class_1297)this, livingEntity), (float)(6 + this.field_5974.method_43048(3)));
                }
                this.method_31472();
            }
        }
    }

    public static boolean isThrowerAllowedToPlace(class_1309 livingEntity) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            return player.method_7294();
        }
        if (livingEntity instanceof class_1308) {
            class_1308 mob = (class_1308)livingEntity;
            class_1937 class_19372 = mob.method_73183();
            if (!(class_19372 instanceof class_3218)) {
                return true;
            }
            class_3218 serverLevel = (class_3218)class_19372;
            return EntityHelper.isMobGriefingAllowed((class_3218)serverLevel, (class_1297)livingEntity);
        }
        return false;
    }

    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71472("Held", this.isHeld());
        valueOutput.method_71468("BlockState", class_2680.field_24734, (Object)this.getBlockState());
    }

    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.setHeld(valueInput.method_71433("Held", false));
        valueInput.method_71426("BlockState", class_2680.field_24734).ifPresent(this::setBlockState);
    }
}

