/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level;

import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.entity.SkullSpirit;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5362;
import net.minecraft.class_9892;

public class MutatedExplosionHelper {
    public static void onExplosionDetonate(class_3218 serverLevel, class_9892 explosion, List<class_2338> affectedBlocks, List<class_1297> affectedEntities) {
        if (explosion.field_52627 instanceof MutatedExplosionDamageCalculator) {
            affectedEntities.removeIf(entity -> !MutatedExplosionHelper.isAffectedByExplosion(serverLevel, explosion, entity));
        }
    }

    private static boolean isAffectedByExplosion(class_3218 serverLevel, class_9892 explosion, class_1297 entity) {
        if (entity.method_5659((class_1927)explosion)) {
            return false;
        }
        if (entity instanceof MutantCreeper) {
            return false;
        }
        class_1297 class_12972 = explosion.method_46406();
        if (class_12972 instanceof SkullSpirit) {
            class_1309 livingEntity;
            SkullSpirit skullSpirit = (SkullSpirit)class_12972;
            if (entity == skullSpirit.getTarget()) {
                return !skullSpirit.isAttached();
            }
            return !(entity instanceof class_1309) || ChemicalXMobEffect.IS_APPLICABLE.method_18303(livingEntity = (class_1309)entity, serverLevel);
        }
        return true;
    }

    public static void explode(class_1297 entity, float radius, boolean fire, class_1937.class_7867 explosionInteraction) {
        class_1282 damageSource = class_1927.method_55108((class_1937)entity.method_73183(), (class_1297)entity);
        MutatedExplosionDamageCalculator damageCalculator = new MutatedExplosionDamageCalculator();
        entity.method_73183().method_55117(entity, damageSource, (class_5362)damageCalculator, entity.method_23317(), entity.method_23318(), entity.method_23321(), radius, fire, explosionInteraction);
    }

    public static class MutatedExplosionDamageCalculator
    extends class_5362 {
        public boolean method_55504(class_1927 explosion, class_1297 entity) {
            if (explosion instanceof class_9892) {
                class_1297 class_12972;
                class_3222 serverPlayer;
                class_9892 serverExplosion = (class_9892)explosion;
                if (entity instanceof class_3222 && (serverPlayer = (class_3222)entity).method_6039() && (class_12972 = explosion.method_46406()) instanceof MutantCreeper) {
                    MutantCreeper mutantCreeper = (MutantCreeper)class_12972;
                    float seenPercent = this.method_57007(entity) == 0.0f ? 0.0f : class_9892.method_61731((class_243)explosion.method_55109(), (class_1297)entity);
                    float damageAmount = this.method_55115(explosion, entity, seenPercent);
                    if (!entity.method_64397(serverPlayer.method_51469(), serverExplosion.field_52626, damageAmount)) {
                        if (mutantCreeper.isJumpAttacking()) {
                            EntityUtil.disableShield((class_1309)serverPlayer, mutantCreeper.isCharged() ? 200 : 100);
                        } else {
                            ItemHelper.hurtAndBreak((class_1799)serverPlayer.method_6030(), (int)((int)(damageAmount * 2.0f)), (class_1309)serverPlayer, (class_1268)serverPlayer.method_6058());
                        }
                        entity.method_64397(serverPlayer.method_51469(), serverExplosion.field_52626, damageAmount * 0.5f);
                    }
                    return false;
                }
            }
            return super.method_55504(explosion, entity);
        }
    }
}

