/*
 * Decompiled with CFR 0.152.
 */
package jamdoggie.betterbattletowers;

import jamdoggie.betterbattletowers.block.ModBlocks;
import jamdoggie.betterbattletowers.entity.EntityGolem;
import jamdoggie.betterbattletowers.entity.TileEntityChestTower;
import jamdoggie.betterbattletowers.worldgen.WorldGenTower;
import java.util.Properties;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.gui.guidebook.mobs.MobInfoRegistry;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.helper.EntityHelper;
import turniplabs.halplibe.util.ClientStartEntrypoint;
import turniplabs.halplibe.util.ConfigHandler;
import turniplabs.halplibe.util.GameStartEntrypoint;
import turniplabs.halplibe.util.RecipeEntrypoint;

public class BetterBattleTowers
implements ModInitializer,
GameStartEntrypoint,
RecipeEntrypoint,
ClientModInitializer,
ClientStartEntrypoint {
    public static final String MOD_ID = "betterbattletowers";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"betterbattletowers");
    public static ConfigHandler config;
    public static BetterBattleTowers instance;
    public static int towercount;
    public static int rarity;
    private final int DEFAULT_RARITY = 3;

    public BetterBattleTowers() {
        instance = this;
    }

    public void onInitialize() {
        LOGGER.info("Better than Battle Towers initialized.");
        CommandHelper.registerWorldFeatureClass(WorldGenTower.class, (String)"BattleTower");
    }

    public void beforeGameStart() {
        ModBlocks.createBlocks();
        EntityHelper.createEntity(EntityGolem.class, (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"golem"), (String)"TowerGolem");
        EntityHelper.createTileEntity(TileEntityChestTower.class, (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"tile_tower_chest"), (String)"TileTowerChest");
    }

    public void beforeClientStart() {
        SoundRepository.registerNamespace((String)MOD_ID);
    }

    public void afterClientStart() {
    }

    public void afterGameStart() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            MobInfoRegistry.register(EntityGolem.class, (String)"betterbattletowers.golem.name", (String)"betterbattletowers.golem.desc", (int)300, (int)10000, (MobInfoRegistry.MobDrop[])new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Blocks.SLAB_STONE_POLISHED), 1.0f, 9, 12), new MobInfoRegistry.MobDrop(new ItemStack(Items.DIAMOND), 1.0f, 1, 6)});
        }
    }

    public void onRecipesReady() {
    }

    public void initNamespaces() {
    }

    public void onInitializeClient() {
    }

    public void GenerateSurface(World world, Random random, int chunkX, int chunkZ) {
        if (towercount >= rarity * 100) {
            int i1;
            int l;
            int k;
            if (random.nextInt(2) == 0 && new WorldGenTower().place(world, random, k = chunkX + random.nextInt(16) + 8, l = world.getHeightValue(k, i1 = chunkZ + random.nextInt(16) + 8), i1)) {
                towercount = 0;
            }
        } else {
            ++towercount;
        }
    }

    static {
        Properties prop = new Properties();
        prop.setProperty("starting_block_id", "6340");
        prop.setProperty("starting_item_id", "26340");
        prop.setProperty("towercount", "200");
        prop.setProperty("rarity", "10");
        prop.setProperty("lootitem1_0", "Item.stick");
        prop.setProperty("lootitem1_1", "Item.seeds.wheat");
        prop.setProperty("lootitem1_2", "Item.ammo.pebble");
        prop.setProperty("lootitem1_3", "Block.sand");
        prop.setProperty("lootitem2_0", "Item.coal");
        prop.setProperty("lootitem2_1", "Item.stick");
        prop.setProperty("lootitem2_2", "Block.planks.oak");
        prop.setProperty("lootitem2_3", "Block.wool");
        prop.setProperty("lootitem3_0", "Item.feather.chicken");
        prop.setProperty("lootitem3_1", "Item.food.bread");
        prop.setProperty("lootitem3_2", "Block.glass");
        prop.setProperty("lootitem3_3", "Block.mushroom.brown");
        prop.setProperty("lootitem4_0", "Item.feather.chicken");
        prop.setProperty("lootitem4_1", "Item.food.bread");
        prop.setProperty("lootitem4_2", "Block.glass");
        prop.setProperty("lootitem4_3", "Block.mushroom.brown");
        prop.setProperty("lootitem5_0", "Block.stairs.planks.oak");
        prop.setProperty("lootitem5_1", "Block.brick.clay");
        prop.setProperty("lootitem5_2", "Item.ingot.iron");
        prop.setProperty("lootitem5_3", "Item.rope");
        prop.setProperty("lootitem6_0", "Block.ladder.oak");
        prop.setProperty("lootitem6_1", "Item.flint");
        prop.setProperty("lootitem6_2", "Item.dust.redstone");
        prop.setProperty("lootitem6_3", "Item.ingot.gold");
        prop.setProperty("lootitem7_0", "Block.pumpkin.carved.active");
        prop.setProperty("lootitem7_1", "Block.rail");
        prop.setProperty("lootitem7_2", "Item.ore.raw.iron");
        prop.setProperty("lootitem7_3", "Item.bucket.lava");
        prop.setProperty("lootitem8_0", "Block.tnt");
        prop.setProperty("lootitem8_1", "Block.slate");
        prop.setProperty("lootitem8_2", "Item.ore.raw.gold");
        prop.setProperty("lootitem8_3", "Item.chainlink");
        prop.setProperty("lootitem9_0", "Item.quartz");
        prop.setProperty("lootitem9_1", "Item.olivine");
        prop.setProperty("lootitem9_2", "Item.dust.redstone");
        prop.setProperty("lootitem9_3", "Block.mesh");
        prop.setProperty("lootitemtop_0", "Block.mesh.gold");
        prop.setProperty("lootitemtop_1", "Item.ingot.gold");
        prop.setProperty("lootitemtop_2", "Item.ingot.iron");
        prop.setProperty("lootitemtop_3", "Item.diamond");
        config = new ConfigHandler(MOD_ID, prop);
        towercount = config.getInt("towercount");
        rarity = config.getInt("rarity");
        config.updateConfig();
    }
}

