/*
 * Decompiled with CFR 0.152.
 */
package jamdoggie.betterbattletowers.worldgen;

import jamdoggie.betterbattletowers.worldgen.BlockPallet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;

public class BlockPallets {
    static WeightedRandomBag<Integer> iceBiom = new WeightedRandomBag();
    static WeightedRandomBag<Integer> desertBiom = new WeightedRandomBag();
    static WeightedRandomBag<Integer> birchBiom = new WeightedRandomBag();
    static WeightedRandomBag<Integer> forestBiom = new WeightedRandomBag();
    static List<WeightedRandomBag<Integer>> randomBiom = new ArrayList<WeightedRandomBag<Integer>>();

    private static void addBiomes(List<WeightedRandomBag<Integer>> randomBiom, BlockPallet ... idAndChances) {
        WeightedRandomBag pallet = new WeightedRandomBag();
        for (BlockPallet idAndChance : idAndChances) {
            pallet.addEntry((Object)idAndChance.blockID, (double)idAndChance.chance);
        }
        randomBiom.add((WeightedRandomBag<Integer>)pallet);
    }

    private static WeightedRandomBag<Integer> getBiomesBag(int index) {
        if (index >= randomBiom.size() || index < 0) {
            return randomBiom.get(0);
        }
        return randomBiom.get(index);
    }

    public static WeightedRandomBag<Integer> getRandomCobbledBlockBag(Biome biome, int index) {
        if (biome.hasSurfaceSnow()) {
            return iceBiom;
        }
        if (biome == Biomes.OVERWORLD_DESERT) {
            return desertBiom;
        }
        if (biome == Biomes.OVERWORLD_BIRCH_FOREST) {
            return birchBiom;
        }
        if (biome == Biomes.OVERWORLD_FOREST) {
            return forestBiom;
        }
        return BlockPallets.getBiomesBag(index);
    }

    static {
        iceBiom.addEntry((Object)Blocks.BRICK_PERMAFROST.id(), 50.0);
        iceBiom.addEntry((Object)Blocks.COBBLE_PERMAFROST.id(), 50.0);
        desertBiom.addEntry((Object)Blocks.BRICK_SANDSTONE.id(), 50.0);
        desertBiom.addEntry((Object)Blocks.SANDSTONE.id(), 50.0);
        birchBiom.addEntry((Object)Blocks.BRICK_STONE_POLISHED.id(), 67.0);
        birchBiom.addEntry((Object)Blocks.BRICK_STONE_POLISHED_MOSSY.id(), 33.0);
        forestBiom.addEntry((Object)Blocks.COBBLE_STONE.id(), 67.0);
        forestBiom.addEntry((Object)Blocks.COBBLE_STONE_MOSSY.id(), 33.0);
        BlockPallets.addBiomes(randomBiom, BlockPallet.ipair(Blocks.COBBLE_STONE.id(), 67.0f), BlockPallet.ipair(Blocks.COBBLE_STONE_MOSSY.id(), 33.0f));
        BlockPallets.addBiomes(randomBiom, BlockPallet.ipair(Blocks.COBBLE_BASALT.id(), 100.0f));
        BlockPallets.addBiomes(randomBiom, BlockPallet.ipair(Blocks.COBBLE_LIMESTONE.id(), 100.0f));
        BlockPallets.addBiomes(randomBiom, BlockPallet.ipair(Blocks.COBBLE_GRANITE.id(), 100.0f));
        BlockPallets.addBiomes(randomBiom, BlockPallet.ipair(Blocks.BRICK_STONE.id(), 100.0f));
        BlockPallets.addBiomes(randomBiom, BlockPallet.ipair(Blocks.BRICK_STONE_POLISHED.id(), 67.0f), BlockPallet.ipair(Blocks.BRICK_STONE_POLISHED_MOSSY.id(), 33.0f));
        BlockPallets.addBiomes(randomBiom, BlockPallet.ipair(Blocks.BRICK_LIMESTONE.id(), 100.0f));
        BlockPallets.addBiomes(randomBiom, BlockPallet.ipair(Blocks.BRICK_GRANITE.id(), 100.0f));
    }
}

