/*
 * Decompiled with CFR 0.152.
 */
package jamdoggie.betterbattletowers.worldgen;

import jamdoggie.betterbattletowers.BetterBattleTowers;
import jamdoggie.betterbattletowers.block.ModBlocks;
import jamdoggie.betterbattletowers.entity.EntityGolem;
import jamdoggie.betterbattletowers.worldgen.BlockPallets;
import jamdoggie.betterbattletowers.worldgen.LootTable;
import java.util.Random;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.type.overworld.WorldTypeOverworld;

public class WorldGenTower
extends WorldFeature {
    public static final int LOOT_AMOUNT = 12;
    public static final int MAX_HEIGHT = 120;
    private int currentFloor = 1;
    private boolean isTopFloor = false;
    private WeightedRandomBag<Integer> cobbleBag;
    private World world;
    private Random random;
    private int towerDecoBlockID;
    private int offset = 0;
    public static final int FLOOR_HEIGHT = 7;
    public static final int FLOOR_LENGTH = 7;
    public static final int FLOOR_WIDTH = 7;

    public boolean place(World world, Random random, int x, int y, int z) {
        int blockId = world.getBlockId(x, y, z);
        if (blockId == Blocks.FLUID_WATER_STILL.id() || blockId == 0) {
            return false;
        }
        this.world = world;
        this.random = random;
        this.towerDecoBlockID = random.nextInt(11);
        this.cobbleBag = BlockPallets.getRandomCobbledBlockBag(this.world.getBlockBiome(x, y, z), this.towerDecoBlockID);
        if (world.worldType instanceof WorldTypeOverworld) {
            this.offset = 64;
        }
        for (int currentHight = y - 6; currentHight < 120 + this.offset; currentHight += 7) {
            if (currentHight + 7 >= 120 + this.offset) {
                this.isTopFloor = true;
            }
            for (int height = 0; height < 7; ++height) {
                if (currentHight == y - 6 && height < 4) {
                    height = 4;
                }
                for (int width = -7; width < 7; ++width) {
                    for (int length = -7; length < 7; ++length) {
                        int ix = width + x;
                        int iy = height + currentHight;
                        int iz = length + z;
                        if (length == -7) {
                            if (width <= -5 || width >= 4) continue;
                            world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                            continue;
                        }
                        if (length == -6 || length == -5) {
                            if (width == -5 || width == 4) {
                                world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                                continue;
                            }
                            if (length == -6) {
                                if (width == (height + 1) % 7 - 3) {
                                    world.setBlock(ix, iy, iz, Blocks.STONE_POLISHED.id());
                                    if (height == 5) {
                                        world.setBlock(ix - 7, iy, iz, Blocks.STONE_POLISHED.id());
                                    }
                                    if (height != 6 || !this.isTopFloor) continue;
                                    world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                                    continue;
                                }
                                if (width >= 4 || width <= -5) continue;
                                world.setBlock(ix, iy, iz, 0);
                                continue;
                            }
                            if (width <= -5 || width >= 5) continue;
                            if (height != 0 && height != 6 || width != -4 && width != 3) {
                                if (height == 5 && (width == 3 || width == -4)) {
                                    world.setBlock(ix, iy, iz, Blocks.STONE_POLISHED.id());
                                    continue;
                                }
                                world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                                continue;
                            }
                            world.setBlock(ix, iy, iz, 0);
                            continue;
                        }
                        if (length == -4 || length == -3 || length == 2 || length == 3) {
                            if (width == -6 || width == 5) {
                                world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                                continue;
                            }
                            if (width <= -6 || width >= 5 || height != 5) continue;
                            world.setBlock(ix, iy, iz, Blocks.STONE_POLISHED.id());
                            continue;
                        }
                        if (length < 2) {
                            if (width == -7 || width == 6) {
                                if (height < 0 || height > 3 || length != -1 && length != 0) {
                                    world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                                    continue;
                                }
                                world.setBlock(ix, iy, iz, 0);
                                continue;
                            }
                            if (height == 5) {
                                world.setBlock(ix, iy, iz, Blocks.STONE_POLISHED.id());
                                continue;
                            }
                            world.setBlock(ix, iy, iz, 0);
                            continue;
                        }
                        if (length == 4) {
                            if (width == -5 || width == 4) {
                                world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                                continue;
                            }
                            if (width <= -5 || width >= 4) continue;
                            if (height == 5) {
                                world.setBlock(ix, iy, iz, Blocks.STONE_POLISHED.id());
                                continue;
                            }
                            world.setBlock(ix, iy, iz, 0);
                            continue;
                        }
                        if (length == 5) {
                            if (width == -4 || width == -3 || width == 2 || width == 3) {
                                world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                                continue;
                            }
                            if (width <= -3 || width >= 2) continue;
                            if (height == 5) {
                                world.setBlock(ix, iy, iz, Blocks.STONE_POLISHED.id());
                                continue;
                            }
                            world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                            continue;
                        }
                        if (width <= -3 || width >= 2) continue;
                        if (height < 0 || height > 3 || width != -1 && width != 0) {
                            world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                            continue;
                        }
                        world.setBlock(ix, iy, iz, ((Integer)this.cobbleBag.getRandom(random)).intValue());
                    }
                }
            }
            if (this.currentFloor == 2) {
                world.setBlock(x + 3, currentHight, z - 5, Blocks.BLOCK_LAPIS.id());
                world.setBlock(x + 3, currentHight - 1, z - 5, Blocks.BLOCK_LAPIS.id());
            }
            this.placeWholesInFloor(x, currentHight, z);
            this.placeHostileDecorations(x, currentHight, z);
            this.skipAFloor(currentHight);
            this.placeChests(x, currentHight, z);
            ++this.currentFloor;
        }
        return true;
    }

    private void skipAFloor(int currentHight) {
        if (currentHight + 56 >= 120 && this.currentFloor == 1) {
            ++this.currentFloor;
        }
    }

    private void placeWholesInFloor(int x, int y, int z) {
        if (this.isTopFloor) {
            return;
        }
        for (int count = 0; count < this.currentFloor * 4 + 3; ++count) {
            int ix = 5 - this.random.nextInt(12);
            int iy = y + 5;
            int iz = 5 - this.random.nextInt(10);
            if (iz < -2 && ix < 4 && ix > -5 && ix != 1 && ix != -2 || this.world.getBlockId(ix += x, iy, iz += z) != Blocks.STONE_POLISHED.id()) continue;
            this.world.setBlock(ix, iy, iz, 0);
        }
    }

    private void placeHostileDecorations(int x, int y, int z) {
        if (this.isTopFloor) {
            this.spawnGolem(x, y + 6, (double)z + 0.5);
        } else {
            this.setSpawners(x, y, z);
        }
        this.world.setBlock(x, y + 6, z - 3, Blocks.STONE_POLISHED.id());
        this.world.setBlock(x - 1, y + 6, z - 3, Blocks.STONE_POLISHED.id());
    }

    private void placeChests(int x, int y, int z) {
        this.placeChest(x, y + 7, z - 3);
        this.placeChest(x - 1, y + 7, z - 3);
        BlockLogicChest.setType((World)this.world, (int)x, (int)(y + 7), (int)(z - 3), (BlockLogicChest.Type)BlockLogicChest.Type.RIGHT);
        BlockLogicChest.setType((World)this.world, (int)(x - 1), (int)(y + 7), (int)(z - 3), (BlockLogicChest.Type)BlockLogicChest.Type.LEFT);
    }

    private void placeChest(int x, int y, int z) {
        this.world.setBlockWithNotify(x, y, z, ModBlocks.ChestTower.id());
        this.world.setBlockMetadataWithNotify(x, y, z, BlockLogicChest.getMetaWithType((int)BlockLogicChest.getMetaWithDirection((int)this.world.getBlockMetadata(x, y, z), (Direction)Direction.SOUTH), (BlockLogicChest.Type)BlockLogicChest.Type.SINGLE));
        TileEntity tile = this.world.getTileEntity(x, y, z);
        if (!(tile instanceof TileEntityChest)) {
            return;
        }
        TileEntityChest tileEntityChest = (TileEntityChest)tile;
        for (int i = 0; i < 12; ++i) {
            ItemStack itemstack = LootTable.generateRandomChestLoot(this.currentFloor, this.random, this.isTopFloor);
            if (itemstack == null) continue;
            tileEntityChest.setItem(this.random.nextInt(tileEntityChest.getContainerSize()), itemstack);
        }
    }

    private String getRandomSpawnerMob() {
        int i = this.random.nextInt(5);
        switch (i) {
            case 0: {
                return "Skeleton";
            }
            case 1: 
            case 4: {
                return "Zombie";
            }
            case 2: 
            case 3: {
                return "Spider";
            }
        }
        return "Scorpion";
    }

    private void spawnGolem(double x, double y, double z) {
        EntityGolem entitygolem = new EntityGolem(this.world, this.towerDecoBlockID);
        entitygolem.spawnInit();
        entitygolem.moveTo(x, y, z, this.world.rand.nextFloat() * 360.0f, 0.0f);
        this.world.entityJoinedWorld((Entity)entitygolem);
        BetterBattleTowers.LOGGER.info("Spawned golem at {} {} {}", new Object[]{x, y, z});
    }

    private void setSpawners(int x, int y, int z) {
        this.setSpawner(x + 2, y + 6, z + 2);
        this.setSpawner(x - 3, y + 6, z + 2);
    }

    private void setSpawner(int x, int y, int z) {
        this.world.setBlockWithNotify(x, y, z, Blocks.MOBSPAWNER.id());
        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)this.world.getTileEntity(x, y, z);
        tileentitymobspawner.setMobId(this.getRandomSpawnerMob());
    }
}

