/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.net.core;

import dev.anye.mc.net.core.NetHandle;
import dev.anye.mc.net.core.NetReg;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class NetPack {
    public static final String NET_KEY = "net.key";

    public static NetworkPack createClientPack(CompoundTag data, String handle) {
        data.putString(NET_KEY, handle);
        return new NetworkPack(data);
    }

    public static NetworkPack createClientPack(CompoundTag data, @NotNull NetHandle handle) {
        return NetPack.createClientPack(data, NetPack.getHandleKey(handle));
    }

    public static NetworkPack createClientPack(CompoundTag data, DeferredHolder<NetHandle, NetHandle> handle) {
        return NetPack.createClientPack(data, handle.getId().toString());
    }

    public static NetworkPack createServerPack(CompoundTag data, String handle) {
        data.putString(NET_KEY, handle);
        return new NetworkPack(data);
    }

    public static NetworkPack createServerPack(CompoundTag data, @NotNull NetHandle handle) {
        return NetPack.createServerPack(data, NetPack.getHandleKey(handle));
    }

    public static NetworkPack createServerPack(CompoundTag data, DeferredHolder<NetHandle, NetHandle> handle) {
        return NetPack.createServerPack(data, handle.getId().toString());
    }

    public static String getHandleKey(@NotNull NetHandle handle) {
        return NetReg.REGISTRY.getKey((Object)handle).toString();
    }

    public static NetHandle getHandle(String key) {
        return (NetHandle)NetReg.REGISTRY.get(ResourceLocation.tryParse((String)key));
    }

    public record NetworkPack(CompoundTag data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<NetworkPack> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"net", (String)"net_pack"));
        public static final StreamCodec<ByteBuf, NetworkPack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, NetworkPack::data, NetworkPack::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public static class STS {
        public static void handleData(NetworkPack data, IPayloadContext context) {
            context.enqueueWork(() -> {
                NetHandle easyNet = NetPack.getHandle(data.data().getString(NetPack.NET_KEY));
                if (easyNet != null) {
                    easyNet.server(context, data.data());
                }
            });
        }
    }

    public static class STC {
        public static void handleData(NetworkPack data, IPayloadContext context) {
            context.enqueueWork(() -> {
                NetHandle easyNet = NetPack.getHandle(data.data().getString(NetPack.NET_KEY));
                if (easyNet != null) {
                    easyNet.client(context, data.data());
                }
            });
        }
    }
}

