/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.funmod.util.handlers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.icarusfell.funmod.Main;
import com.icarusfell.funmod.lists.ItemList;
import com.icarusfell.funmod.util.handlers.MobSkillHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.ServerBossInfo;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MobSpawnHandler {
    public static StringTextComponent emptyTextComponent = new StringTextComponent("");
    static HashMap<Entity, ServerBossInfo> bossbarmap = new HashMap();
    static Multimap<Entity, ServerPlayerEntity> unusedplayermap = ArrayListMultimap.create();

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof MonsterEntity && !(event.getEntity() instanceof WitherEntity) && !(event.getEntity() instanceof EnderDragonEntity) && !(event.getEntity() instanceof CreeperEntity) && new Random().nextInt(300) + 1 == 5) {
            CompoundNBT nbt = event.getEntity().getPersistentData();
            nbt.func_74757_a("isKeeper", true);
            nbt.func_74768_a("ID", new Random().nextInt(999999999));
            if (new Random().nextInt(100) + 1 < 60) {
                nbt.func_74768_a("tier", 1);
            } else if (new Random().nextInt(100) + 1 < 60) {
                nbt.func_74768_a("tier", 2);
            } else if (new Random().nextInt(100) + 1 < 60) {
                nbt.func_74768_a("tier", 3);
            } else {
                nbt.func_74768_a("tier", 4);
            }
            nbt.func_74776_a("attackDamage", 10.0f);
            nbt.func_74776_a("health", 250.0f);
            nbt.func_74780_a("armor", 7.5);
            nbt.func_74780_a("armorT", 5.0);
            if (nbt.func_74762_e("tier") == 1) {
                ((LivingEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196204_et));
            }
            if (nbt.func_74762_e("tier") == 2) {
                ((LivingEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196195_ek));
            }
            if (nbt.func_74762_e("tier") == 3) {
                ((LivingEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196205_eu));
            }
            if (nbt.func_74762_e("tier") == 4) {
                ((LivingEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196201_eq));
            }
            IAttributeInstance health = ((LivingEntity)event.getEntity()).func_110148_a(SharedMonsterAttributes.field_111267_a);
            IAttributeInstance speed = ((LivingEntity)event.getEntity()).func_110148_a(SharedMonsterAttributes.field_111263_d);
            IAttributeInstance armor = ((LivingEntity)event.getEntity()).func_110148_a(SharedMonsterAttributes.field_188791_g);
            IAttributeInstance armorT = ((LivingEntity)event.getEntity()).func_110148_a(SharedMonsterAttributes.field_189429_h);
            health.func_111128_a((double)(nbt.func_74760_g("health") * (float)nbt.func_74762_e("tier")));
            speed.func_111128_a(speed.func_111125_b() + speed.func_111125_b() / 5.0 * (double)nbt.func_74762_e("tier"));
            armor.func_111128_a(nbt.func_74769_h("armor") * (double)nbt.func_74762_e("tier"));
            armorT.func_111128_a(nbt.func_74769_h("armor") * (double)nbt.func_74762_e("tier"));
            ((LivingEntity)event.getEntity()).func_70691_i(nbt.func_74760_g("health") * (float)nbt.func_74762_e("tier"));
            event.getEntity().func_174805_g(true);
            int chancei = new Random().nextInt(7);
            if (chancei == 0) {
                nbt.func_74757_a("blinding", true);
                nbt.func_74778_a("tiersuffix", " of Blinding");
            }
            if (chancei == 1) {
                nbt.func_74757_a("poisoning", true);
                nbt.func_74778_a("tiersuffix", " of Poisoning");
            }
            if (chancei == 2) {
                nbt.func_74757_a("withering", true);
                nbt.func_74778_a("tiersuffix", " of Withering");
            }
            if (chancei == 3) {
                nbt.func_74757_a("slowing", true);
                nbt.func_74778_a("tiersuffix", " of Slowing");
            }
            if (chancei == 4) {
                nbt.func_74757_a("burning", true);
                nbt.func_74778_a("tiersuffix", " of Burning");
            }
            if (chancei == 5) {
                nbt.func_74757_a("resistance", true);
                nbt.func_74778_a("tiersuffix", " of Resistance");
            }
            if (chancei == 6) {
                nbt.func_74757_a("regeneration", true);
                nbt.func_74778_a("tiersuffix", " of Regeneration");
            }
            if (nbt.func_74762_e("tier") == 1) {
                nbt.func_74778_a("tiercolor", "\u00a7a");
            }
            if (nbt.func_74762_e("tier") == 2) {
                nbt.func_74778_a("tiercolor", "\u00a7e");
            }
            if (nbt.func_74762_e("tier") == 3) {
                nbt.func_74778_a("tiercolor", "\u00a7c");
            }
            if (nbt.func_74762_e("tier") == 4) {
                nbt.func_74778_a("tiercolor", "\u00a75");
            }
            nbt.func_74768_a("tierability", new Random().nextInt(3) + 1);
            if (nbt.func_74762_e("tierability") == 1) {
                nbt.func_74778_a("tierprefix", "Leaping ");
            }
            if (nbt.func_74762_e("tierability") == 2) {
                nbt.func_74778_a("tierprefix", "Smacking ");
            }
            if (nbt.func_74762_e("tierability") == 3) {
                nbt.func_74778_a("tierprefix", "Thrusting ");
            }
            StringTextComponent finalname = new StringTextComponent(nbt.func_74779_i("tiercolor") + nbt.func_74779_i("tierprefix") + MobSpawnHandler.returnRandomName() + nbt.func_74779_i("tiersuffix"));
            event.getEntity().func_200203_b((ITextComponent)finalname);
        }
    }

    @SubscribeEvent
    public void keeperHit(LivingHurtEvent event) {
        CompoundNBT nbt;
        if (event.getSource().func_76346_g() instanceof MonsterEntity && event.getEntity() instanceof PlayerEntity && (nbt = event.getSource().func_76346_g().getPersistentData()).func_74767_n("isKeeper")) {
            if (nbt.func_74767_n("blinding")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effect.func_188412_a((int)15), 100, 2));
            }
            if (nbt.func_74767_n("withering")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effect.func_188412_a((int)20), 100, 2));
            }
            if (nbt.func_74767_n("poisoning")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effect.func_188412_a((int)19), 100, 2));
            }
            if (nbt.func_74767_n("slowing")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effect.func_188412_a((int)2), 100, 2));
            }
            if (nbt.func_74767_n("burning")) {
                ((LivingEntity)event.getEntity()).func_70015_d(5);
            }
            MobSkillHandler.LKAbility(event.getSource().func_76346_g(), event.getEntity(), 100, nbt.func_74762_e("tierability"), event.getEntity().func_130014_f_());
            event.getEntity().func_70097_a(new DamageSource("lootkeeper"), 10.0f * (float)nbt.func_74762_e("tier"));
            if (nbt.func_74762_e("tier") == 5) {
                if (event.getEntity().getPersistentData().func_74762_e("tierfivehits") > 3) {
                    event.getEntity().getPersistentData().func_74768_a("tierfivehits", 0);
                    event.getEntity().func_70097_a(new DamageSource("lootkeeper"), 100.0f);
                } else {
                    event.getEntity().getPersistentData().func_74768_a("tierfivehits", event.getEntity().getPersistentData().func_74762_e("tierfivehits") + 1);
                }
            }
        }
    }

    @SubscribeEvent
    public void keeperHurt(LivingHurtEvent event) {
        CompoundNBT nbt;
        if (event.getEntity() instanceof MonsterEntity && event.getSource().func_76346_g() instanceof PlayerEntity && (nbt = event.getEntity().getPersistentData()).func_74767_n("isKeeper") && new Random().nextInt(3) + 1 == 2) {
            event.getEntity().func_70024_g(event.getSource().func_76346_g().func_70040_Z().field_72450_a * 2.5, event.getSource().func_76346_g().func_70040_Z().field_72448_b * 2.0, event.getSource().func_76346_g().func_70040_Z().field_72449_c * 2.5);
        }
    }

    @SubscribeEvent
    public void keeperDeath(LivingDeathEvent event) {
        CompoundNBT nbt;
        if (event.getEntity() instanceof MonsterEntity && event.getSource().func_76346_g() instanceof PlayerEntity && (nbt = event.getEntity().getPersistentData()).func_74767_n("isKeeper")) {
            this.getBar(event.getEntity()).func_201360_b();
            this.removeBarFromList(event.getEntity());
            ItemStack i = nbt.func_74762_e("tier") == 1 ? new ItemStack((IItemProvider)ItemList.lootchest_keeper1) : (nbt.func_74762_e("tier") == 2 ? new ItemStack((IItemProvider)ItemList.lootchest_keeper2) : (nbt.func_74762_e("tier") == 3 ? new ItemStack((IItemProvider)ItemList.lootchest_keeper3) : (nbt.func_74762_e("tier") == 4 ? new ItemStack((IItemProvider)ItemList.lootchest_keeper4) : new ItemStack((IItemProvider)ItemList.lootchest_keeper5))));
            ItemEntity ie = new ItemEntity(event.getEntity().func_130014_f_(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, i);
            event.getEntity().func_130014_f_().func_217376_c((Entity)ie);
            ie.func_184195_f(true);
            ie.func_200203_b(i.func_200301_q());
            ie.func_174805_g(true);
        }
    }

    public void addBarToList(Entity entity, ServerBossInfo serverbossinfo) {
        bossbarmap.put(entity, serverbossinfo);
    }

    public boolean barExists(Entity entity) {
        return bossbarmap.containsKey(entity);
    }

    public void removeBarFromList(Entity entity) {
        bossbarmap.remove(entity);
    }

    public void clearList() {
        bossbarmap.clear();
    }

    public ServerBossInfo getBar(Entity entity) {
        return bossbarmap.get(entity);
    }

    public void markUnused(Entity entity, ServerPlayerEntity serverplayer) {
        unusedplayermap.get((Object)entity).add(serverplayer);
    }

    public void cleanUnusedBars(Entity entity) {
        for (ServerPlayerEntity sp : unusedplayermap.get((Object)entity)) {
            this.getBar(entity).func_186761_b(sp);
        }
    }

    public void removePlayerFromAll(ServerPlayerEntity serverplayer) {
        bossbarmap.forEach((e, s) -> s.func_186761_b(serverplayer));
    }

    public boolean hasNearbyPlayersIn(Entity entity, int radius) {
        List playerlist = entity.func_130014_f_().func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(entity.field_70165_t - (double)radius, entity.field_70163_u - (double)radius, entity.field_70161_v - (double)radius, entity.field_70165_t + (double)radius, entity.field_70163_u + (double)radius, entity.field_70161_v + (double)radius));
        return !playerlist.isEmpty();
    }

    public boolean hasNearbyPlayerIn(Entity entity, int radius, ServerPlayerEntity serverplayer) {
        List playerlist = entity.func_130014_f_().func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(entity.field_70165_t - (double)radius, entity.field_70163_u - (double)radius, entity.field_70161_v - (double)radius, entity.field_70165_t + (double)radius, entity.field_70163_u + (double)radius, entity.field_70161_v + (double)radius));
        return playerlist.contains(serverplayer);
    }

    @SubscribeEvent
    public void justWandering(LivingEvent.LivingUpdateEvent event) {
        CompoundNBT nbt;
        if (event.getEntity() instanceof MonsterEntity && (nbt = event.getEntity().getPersistentData()).func_74767_n("isKeeper")) {
            List players;
            if (nbt.func_74767_n("resistance")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effects.field_76429_m, 5, 1));
            }
            if (nbt.func_74767_n("regeneration")) {
                ((LivingEntity)event.getEntity()).func_70691_i(0.05f);
            }
            if (!(players = event.getEntity().func_130014_f_().func_217357_a(PlayerEntity.class, new AxisAlignedBB(event.getEntity().field_70165_t - 20.0, event.getEntity().field_70163_u - 20.0, event.getEntity().field_70161_v - 20.0, event.getEntity().field_70165_t + 20.0, event.getEntity().field_70163_u + 20.0, event.getEntity().field_70161_v + 20.0))).isEmpty() && Main.returnIntegerBetween(300, 1) == 1) {
                event.getEntity().func_70024_g(event.getEntity().func_70040_Z().field_72450_a * 2.5, event.getEntity().func_70040_Z().field_72448_b * 2.0, event.getEntity().func_70040_Z().field_72449_c * 2.5);
            }
            if (nbt.func_74762_e("tier") == 5) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effects.field_76429_m, 5, 3));
                ((LivingEntity)event.getEntity()).func_70691_i(0.05f);
            }
            if (!event.getEntity().field_70170_p.field_72995_K) {
                if (this.barExists(event.getEntity())) {
                    List serverplayers = event.getEntity().func_130014_f_().func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(event.getEntity().field_70165_t - 35.0, event.getEntity().field_70163_u - 35.0, event.getEntity().field_70161_v - 35.0, event.getEntity().field_70165_t + 35.0, event.getEntity().field_70163_u + 35.0, event.getEntity().field_70161_v + 35.0));
                    block0: for (Map.Entry<Entity, ServerBossInfo> e : bossbarmap.entrySet()) {
                        for (ServerPlayerEntity p : serverplayers) {
                            if (!e.getKey().func_70089_S()) {
                                e.getValue().func_186761_b(p);
                                e.getKey().func_184203_c(p);
                                this.removeBarFromList(e.getKey());
                                return;
                            }
                            if (e.getKey().getPersistentData().func_74762_e("tier") == 1) {
                                e.getValue().func_186745_a(BossInfo.Color.GREEN);
                            }
                            if (e.getKey().getPersistentData().func_74762_e("tier") == 2) {
                                e.getValue().func_186745_a(BossInfo.Color.YELLOW);
                            }
                            if (e.getKey().getPersistentData().func_74762_e("tier") == 3) {
                                e.getValue().func_186745_a(BossInfo.Color.RED);
                            }
                            if (e.getKey().getPersistentData().func_74762_e("tier") == 4) {
                                e.getValue().func_186745_a(BossInfo.Color.PURPLE);
                            }
                            if (e.getKey().getPersistentData().func_74762_e("tier") == 5) {
                                e.getValue().func_186745_a(BossInfo.Color.WHITE);
                            }
                            float percent = ((LivingEntity)e.getKey()).func_110143_aJ() / ((LivingEntity)e.getKey()).func_110138_aP();
                            e.getValue().func_186739_a(e.getKey().func_200201_e());
                            e.getValue().func_186735_a(percent);
                            e.getKey().func_184178_b(p);
                            e.getValue().func_186760_a(p);
                        }
                        for (ServerPlayerEntity sp : this.getBar(e.getKey()).func_186757_c()) {
                            if (this.hasNearbyPlayerIn(e.getKey(), 35, sp)) continue;
                            this.markUnused(e.getKey(), sp);
                            this.cleanUnusedBars(e.getKey());
                            continue block0;
                        }
                    }
                    if (event.getEntity().func_130014_f_().func_175659_aa().equals((Object)Difficulty.PEACEFUL)) {
                        this.getBar(event.getEntity()).func_201360_b();
                        this.removeBarFromList(event.getEntity());
                    }
                } else {
                    ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo((ITextComponent)emptyTextComponent, BossInfo.Color.WHITE, BossInfo.Overlay.NOTCHED_10).func_186741_a(false);
                    bossInfo.func_186739_a(event.getEntity().func_200201_e());
                    if (nbt.func_74762_e("tier") == 1) {
                        bossInfo.func_186745_a(BossInfo.Color.GREEN);
                    }
                    if (nbt.func_74762_e("tier") == 2) {
                        bossInfo.func_186745_a(BossInfo.Color.YELLOW);
                    }
                    if (nbt.func_74762_e("tier") == 3) {
                        bossInfo.func_186745_a(BossInfo.Color.RED);
                    }
                    if (nbt.func_74762_e("tier") == 4) {
                        bossInfo.func_186745_a(BossInfo.Color.PURPLE);
                    }
                    if (nbt.func_74762_e("tier") == 5) {
                        bossInfo.func_186745_a(BossInfo.Color.WHITE);
                    }
                    float percent = ((LivingEntity)event.getEntity()).func_110143_aJ() / ((LivingEntity)event.getEntity()).func_110138_aP();
                    bossInfo.func_186735_a(percent);
                    this.addBarToList(event.getEntity(), bossInfo);
                }
            }
        }
    }

    public static String returnRandomName() {
        String[] namelist = new String[]{"Baran", "Berkan", "Batu", "Ata", "Derek", "Berek", "Azomyte", "Colin", "Artaya", "Kitava", "Malachai", "Mordekai", "Tukohama", "Quin", "Alper", "Furkan", "Ozan", "Gruthkul", "Garukhan", "Kayne", "Felix", "Janus", "Frygon", "Sigrismarr", "Heredur", "Shamx", "Bob", "Biu"};
        String[] titlelist = new String[]{"the Brutal", "the Savage", "the Smart", "the Swift", "the Tinkerer", "the Mighty", "the Undefeated", "the Shadow", "the Unseen", "the Heathen", "the Magnificent", "the Dangereous", "the Maniac", "the Tremendous", "the Insatiable", "the Spooky", "the Scary", "the Menacing", "the Deadly"};
        return namelist[new Random().nextInt(28)] + " " + titlelist[new Random().nextInt(19)];
    }

    @SubscribeEvent
    public void onEntitySpawn(PlayerEvent.PlayerRespawnEvent event) {
        CompoundNBT nbt = event.getPlayer().getPersistentData();
        AttributeModifier HEALTH_BONUS = new AttributeModifier(UUID.fromString("84ae7419-dbe9-445a-8d36-7979f2fa10f6"), SharedMonsterAttributes.field_111267_a.func_111108_a(), 20.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
        event.getPlayer().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(HEALTH_BONUS);
        nbt.func_74757_a("SetBonus", false);
        nbt.func_74757_a("joinedBefore", true);
    }
}

