/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.funmod.render;

import com.baranhan123.funmod.util.handlers.MethodHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Render {
    private static final ResourceLocation ICONS = new ResourceLocation("funmod", "textures/icons/bossbar.png");

    public static void renderOuterBossbar(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (MethodHelper.isBossbarOn((Player)mc.f_91074_)) {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            int x = mc.m_91268_().m_85445_() / 2 - 85;
            int y = 20;
            guiGraphics.m_280218_(ICONS, x, y, Render.getOuterBarLocX(), Render.getOuterBarLocY(), 171, 8);
        }
    }

    public static void renderInnerBossbar(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (MethodHelper.isBossbarOn((Player)mc.f_91074_)) {
            int health = (int)MethodHelper.getInheritedDefaultHealth((Player)mc.f_91074_);
            int maxHealth = (int)MethodHelper.getInheritedMaxHealth((Player)mc.f_91074_);
            if (maxHealth <= 0) {
                maxHealth = 1;
            }
            float percent = Math.min((float)health / (float)maxHealth, 1.0f);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            int x = mc.m_91268_().m_85445_() / 2 - 84;
            int y = 21;
            int width = (int)(percent * 169.0f);
            guiGraphics.m_280218_(ICONS, x, y, Render.getInnerBarLocX(), Render.getInnerBarLocY(), width, 6);
        }
    }

    public static void renderBarName(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (MethodHelper.isBossbarOn((Player)mc.f_91074_)) {
            String name = MethodHelper.getInheritedName((Player)mc.f_91074_);
            int stringWidth = mc.f_91062_.m_92895_(name);
            int x = mc.m_91268_().m_85445_() / 2 - stringWidth / 2;
            guiGraphics.m_280056_(mc.f_91062_, name, x, 7, Render.getHexColor(), true);
        }
    }

    public static int getOuterBarLocX() {
        return 0;
    }

    public static int getOuterBarLocY() {
        return 0;
    }

    public static int getInnerBarLocX() {
        return 1;
    }

    public static int getInnerBarLocY() {
        Minecraft mc = Minecraft.m_91087_();
        int tier = mc.f_91074_.getPersistentData().m_128451_("funmodinheritedTier");
        return 8 + (tier - 1) * 6;
    }

    public static int getHexColor() {
        Minecraft mc = Minecraft.m_91087_();
        int tier = mc.f_91074_.getPersistentData().m_128451_("funmodinheritedTier");
        int color = 0xFFFFFF;
        if (tier == 1) {
            color = 65314;
        } else if (tier == 2) {
            color = 16766208;
        } else if (tier == 3) {
            color = 0xFF0000;
        } else if (tier == 4) {
            color = 12321023;
        } else if (tier == 5) {
            color = 5197906;
        }
        return color;
    }
}

