/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.funmod.specialblocks;

import com.baranhan123.funmod.lists.ItemList;
import com.baranhan123.funmod.specialblocks.MagicTableContainer;
import com.baranhan123.funmod.specialblocks.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class MagicTableTile
extends BlockEntity
implements BlockEntityTicker<MagicTableTile>,
MenuProvider {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private int counter;

    public MagicTableTile(BlockPos pos, BlockState state) {
        super(ModBlocks.MAGICTABLE_TILE, pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state, MagicTableTile tile) {
        if (!this.itemHandler.getStackInSlot(4).m_41619_()) {
            this.itemHandler.getStackInSlot(4).m_41784_().m_128379_("canBeInOutput", false);
        }
    }

    public void getClicked() {
        ItemStack blueprintStack;
        if (!this.itemHandler.getStackInSlot(4).m_41619_()) {
            this.itemHandler.getStackInSlot(4).m_41784_().m_128379_("canBeInOutput", false);
        }
        if ((blueprintStack = this.itemHandler.getStackInSlot(3)).m_41782_()) {
            CompoundTag tag = blueprintStack.m_41783_();
            if (tag.m_128461_("result").contains("fortune")) {
                ItemStack s0 = this.itemHandler.getStackInSlot(0);
                ItemStack s1 = this.itemHandler.getStackInSlot(1);
                ItemStack s2 = this.itemHandler.getStackInSlot(2);
                int amt1 = tag.m_128451_("material1amount");
                int amt2 = tag.m_128451_("material2amount");
                int amt3 = tag.m_128451_("material3amount");
                if (s0.m_41720_().equals(Items.f_41912_) && s0.m_41613_() >= amt1 && s1.m_41720_().equals(ItemList.g_essence_of_greed) && s1.m_41613_() >= amt2 && s2.m_41720_().equals(ItemList.e_power_crystal) && s2.m_41613_() >= amt3 && this.itemHandler.getStackInSlot(4).m_41619_()) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    s0.m_41774_(amt1);
                    s1.m_41774_(amt2);
                    s2.m_41774_(amt3);
                    ItemStack result = new ItemStack((ItemLike)ItemList.sword_of_fortune);
                    result.m_41663_(Enchantments.f_44982_, 10);
                    result.m_41784_().m_128379_("canBeInOutput", true);
                    this.itemHandler.setStackInSlot(4, result);
                }
            } else {
                ItemStack s0 = this.itemHandler.getStackInSlot(0);
                ItemStack s1 = this.itemHandler.getStackInSlot(1);
                ItemStack s2 = this.itemHandler.getStackInSlot(2);
                int amt1 = tag.m_128451_("material1amount");
                int amt2 = tag.m_128451_("material2amount");
                int amt3 = tag.m_128451_("material3amount");
                if (s0.m_41720_().equals(ForgeRegistries.ITEMS.getValue(new ResourceLocation("funmod", tag.m_128461_("material1name")))) && s0.m_41613_() >= amt1 && s1.m_41720_().equals(ForgeRegistries.ITEMS.getValue(new ResourceLocation("funmod", tag.m_128461_("material2name")))) && s1.m_41613_() >= amt2 && s2.m_41720_().equals(ForgeRegistries.ITEMS.getValue(new ResourceLocation("funmod", tag.m_128461_("material3name")))) && s2.m_41613_() >= amt3 && this.itemHandler.getStackInSlot(4).m_41619_()) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    s0.m_41774_(amt1);
                    s1.m_41774_(amt2);
                    s2.m_41774_(amt3);
                    ItemStack result = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("funmod", tag.m_128461_("result"))));
                    result.m_41784_().m_128379_("canBeInOutput", true);
                    this.itemHandler.setStackInSlot(4, result);
                }
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        this.counter = tag.m_128451_("counter");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("counter", this.counter);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                MagicTableTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                String key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
                if (slot == 0) {
                    return key.contains("ingot") || key.contains("gold") || key.contains("diamond") || key.contains("iron") || key.contains("emerald") || key.contains("charged_ns") || key.contains("nether") || key.contains("darkness");
                }
                if (slot == 1) {
                    return key.contains("greed");
                }
                if (slot == 2) {
                    return key.contains("power_crystal");
                }
                if (slot == 3) {
                    return key.contains("blueprint") && stack.m_41782_();
                }
                return false;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.funmod.magictable");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new MagicTableContainer(id, this.f_58857_, this.f_58858_, inv, player);
    }
}

