/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.funmod.network;

import com.baranhan123.funmod.util.config.CommonConfig;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class SummonKeeper {
    private final BlockPos pos;
    private final int tier;

    public SummonKeeper(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.tier = buf.readInt();
    }

    public SummonKeeper(int tier, BlockPos pos) {
        this.pos = pos;
        this.tier = tier;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.tier);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (new Random().nextInt(100) + 1 < 50) {
                ((NetworkEvent.Context)ctx.get()).getSender().m_6844_(EquipmentSlot.MAINHAND).m_41774_(1);
                Zombie monster = new Zombie(EntityType.f_20501_, ((NetworkEvent.Context)ctx.get()).getSender().f_19853_);
                CompoundTag nbt = monster.getPersistentData();
                nbt.m_128379_("isKeeper", true);
                nbt.m_128405_("ID", new Random().nextInt(999999999));
                nbt.m_128405_("tier", this.tier);
                nbt.m_128350_("health", (float)((Double)CommonConfig.lootkeeperHealth.get()).doubleValue());
                nbt.m_128347_("armor", ((Double)CommonConfig.lootkeeperArmor.get()).doubleValue());
                nbt.m_128347_("armorT", ((Double)CommonConfig.lootkeeperArmorToughness.get()).doubleValue());
                if (nbt.m_128451_("tier") == 1) {
                    monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42673_));
                }
                if (nbt.m_128451_("tier") == 2) {
                    monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42664_));
                }
                if (nbt.m_128451_("tier") == 3) {
                    monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42727_));
                }
                if (nbt.m_128451_("tier") == 4) {
                    monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42670_));
                }
                AttributeInstance health = monster.m_21051_(Attributes.f_22276_);
                AttributeInstance speed = monster.m_21051_(Attributes.f_22279_);
                AttributeInstance armor = monster.m_21051_(Attributes.f_22284_);
                AttributeInstance armorT = monster.m_21051_(Attributes.f_22285_);
                health.m_22100_((double)(nbt.m_128457_("health") * (float)nbt.m_128451_("tier")));
                speed.m_22100_(speed.m_22115_() + speed.m_22115_() / 5.0 * (double)nbt.m_128451_("tier"));
                armor.m_22100_(nbt.m_128459_("armor") * (double)nbt.m_128451_("tier"));
                armorT.m_22100_(nbt.m_128459_("armor") * (double)nbt.m_128451_("tier"));
                monster.m_5634_(nbt.m_128457_("health") * (float)nbt.m_128451_("tier"));
                monster.m_20340_(true);
                int chancei = new Random().nextInt(7);
                if (chancei == 0) {
                    nbt.m_128379_("blinding", true);
                    nbt.m_128359_("tiersuffix", " of Blinding");
                }
                if (chancei == 1) {
                    nbt.m_128379_("poisoning", true);
                    nbt.m_128359_("tiersuffix", " of Plague");
                }
                if (chancei == 2) {
                    nbt.m_128379_("withering", true);
                    nbt.m_128359_("tiersuffix", " of Doom");
                }
                if (chancei == 3) {
                    nbt.m_128379_("slowing", true);
                    nbt.m_128359_("tiersuffix", " of Ice");
                }
                if (chancei == 4) {
                    nbt.m_128379_("burning", true);
                    nbt.m_128359_("tiersuffix", " of Fire");
                }
                if (chancei == 5) {
                    nbt.m_128379_("resistance", true);
                    nbt.m_128359_("tiersuffix", " of Resistance");
                }
                if (chancei == 6) {
                    nbt.m_128379_("regeneration", true);
                    nbt.m_128359_("tiersuffix", " of Regeneration");
                }
                if (nbt.m_128451_("tier") == 1) {
                    nbt.m_128359_("tiercolor", ChatFormatting.GREEN.toString());
                }
                if (nbt.m_128451_("tier") == 2) {
                    nbt.m_128359_("tiercolor", ChatFormatting.YELLOW.toString());
                }
                if (nbt.m_128451_("tier") == 3) {
                    nbt.m_128359_("tiercolor", ChatFormatting.RED.toString());
                }
                if (nbt.m_128451_("tier") == 4) {
                    nbt.m_128359_("tiercolor", ChatFormatting.DARK_PURPLE.toString());
                }
                nbt.m_128405_("tierability", new Random().nextInt(3) + 1);
                if (nbt.m_128451_("tierability") == 1) {
                    nbt.m_128359_("tierprefix", "Leaping ");
                }
                if (nbt.m_128451_("tierability") == 2) {
                    nbt.m_128359_("tierprefix", "Smacking ");
                }
                if (nbt.m_128451_("tierability") == 3) {
                    nbt.m_128359_("tierprefix", "Thrusting ");
                }
                MutableComponent finalname = Component.m_237113_((String)(nbt.m_128461_("tiercolor") + nbt.m_128461_("tierprefix") + SummonKeeper.returnRandomName() + nbt.m_128461_("tiersuffix")));
                monster.m_6593_((Component)finalname);
                monster.m_6034_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_());
                ((NetworkEvent.Context)ctx.get()).getSender().f_19853_.m_7967_((Entity)monster);
                monster.m_6034_(((NetworkEvent.Context)ctx.get()).getSender().m_20185_(), ((NetworkEvent.Context)ctx.get()).getSender().m_20186_(), ((NetworkEvent.Context)ctx.get()).getSender().m_20189_());
            } else {
                ((NetworkEvent.Context)ctx.get()).getSender().m_6844_(EquipmentSlot.MAINHAND).m_41774_(1);
                Skeleton monster = new Skeleton(EntityType.f_20524_, ((NetworkEvent.Context)ctx.get()).getSender().f_19853_);
                CompoundTag nbt = monster.getPersistentData();
                monster.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                nbt.m_128379_("isKeeper", true);
                nbt.m_128405_("ID", new Random().nextInt(999999999));
                nbt.m_128405_("tier", this.tier);
                nbt.m_128350_("health", 250.0f);
                nbt.m_128347_("armor", 7.5);
                nbt.m_128347_("armorT", 5.0);
                if (nbt.m_128451_("tier") == 1) {
                    monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42673_));
                }
                if (nbt.m_128451_("tier") == 2) {
                    monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42664_));
                }
                if (nbt.m_128451_("tier") == 3) {
                    monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42727_));
                }
                if (nbt.m_128451_("tier") == 4) {
                    monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42670_));
                }
                AttributeInstance health = monster.m_21051_(Attributes.f_22276_);
                AttributeInstance speed = monster.m_21051_(Attributes.f_22279_);
                AttributeInstance armor = monster.m_21051_(Attributes.f_22284_);
                AttributeInstance armorT = monster.m_21051_(Attributes.f_22285_);
                health.m_22100_((double)(nbt.m_128457_("health") * (float)nbt.m_128451_("tier")));
                speed.m_22100_(speed.m_22115_() + speed.m_22115_() / 5.0 * (double)nbt.m_128451_("tier"));
                armor.m_22100_(nbt.m_128459_("armor") * (double)nbt.m_128451_("tier"));
                armorT.m_22100_(nbt.m_128459_("armor") * (double)nbt.m_128451_("tier"));
                monster.m_5634_(nbt.m_128457_("health") * (float)nbt.m_128451_("tier"));
                monster.m_20340_(true);
                int chancei = new Random().nextInt(7);
                if (chancei == 0) {
                    nbt.m_128379_("blinding", true);
                    nbt.m_128359_("tiersuffix", " of Blinding");
                }
                if (chancei == 1) {
                    nbt.m_128379_("poisoning", true);
                    nbt.m_128359_("tiersuffix", " of Poisoning");
                }
                if (chancei == 2) {
                    nbt.m_128379_("withering", true);
                    nbt.m_128359_("tiersuffix", " of Withering");
                }
                if (chancei == 3) {
                    nbt.m_128379_("slowing", true);
                    nbt.m_128359_("tiersuffix", " of Slowing");
                }
                if (chancei == 4) {
                    nbt.m_128379_("burning", true);
                    nbt.m_128359_("tiersuffix", " of Burning");
                }
                if (chancei == 5) {
                    nbt.m_128379_("resistance", true);
                    nbt.m_128359_("tiersuffix", " of Resistance");
                }
                if (chancei == 6) {
                    nbt.m_128379_("regeneration", true);
                    nbt.m_128359_("tiersuffix", " of Regeneration");
                }
                if (nbt.m_128451_("tier") == 1) {
                    nbt.m_128359_("tiercolor", ChatFormatting.GREEN.toString());
                }
                if (nbt.m_128451_("tier") == 2) {
                    nbt.m_128359_("tiercolor", ChatFormatting.YELLOW.toString());
                }
                if (nbt.m_128451_("tier") == 3) {
                    nbt.m_128359_("tiercolor", ChatFormatting.RED.toString());
                }
                if (nbt.m_128451_("tier") == 4) {
                    nbt.m_128359_("tiercolor", ChatFormatting.DARK_PURPLE.toString());
                }
                nbt.m_128405_("tierability", new Random().nextInt(3) + 1);
                if (nbt.m_128451_("tierability") == 1) {
                    nbt.m_128359_("tierprefix", "Leaping ");
                }
                if (nbt.m_128451_("tierability") == 2) {
                    nbt.m_128359_("tierprefix", "Smacking ");
                }
                if (nbt.m_128451_("tierability") == 3) {
                    nbt.m_128359_("tierprefix", "Thrusting ");
                }
                MutableComponent finalname = Component.m_237113_((String)(nbt.m_128461_("tiercolor") + nbt.m_128461_("tierprefix") + SummonKeeper.returnRandomName() + nbt.m_128461_("tiersuffix")));
                monster.m_6593_((Component)finalname);
                monster.m_6034_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_());
                ((NetworkEvent.Context)ctx.get()).getSender().f_19853_.m_7967_((Entity)monster);
                monster.m_6034_(((NetworkEvent.Context)ctx.get()).getSender().m_20185_(), ((NetworkEvent.Context)ctx.get()).getSender().m_20186_(), ((NetworkEvent.Context)ctx.get()).getSender().m_20189_());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static String returnRandomName() {
        String[] namelist = new String[]{"Baran", "Berkan", "Batu", "Ata", "Derek", "Berek", "Azomyte", "Colin", "Artaya", "Kitava", "Malachai", "Melih", "Habesh", "Mordekai", "Tukohama", "Quin", "Alper", "Furkan", "Ozan", "Gruthkul", "Garukhan", "Kayne", "Felix", "Janus", "Frygon", "Sigrismarr", "Heredur", "Shamx", "Bob", "Biu"};
        String[] titlelist = new String[]{"the Brutal", "the Savage", "the Smart", "the Swift", "the Tinkerer", "the Mighty", "the Undefeated", "the Shadow", "the Scavenger", "the Unseen", "the Heathen", "the Magnificent", "the Dangerous", "the Maniac", "the Tremendous", "the Insatiable", "the Spooky", "the Scary", "the Menacing", "the Deadly", "the Devious", "the Cursed", "the Damned", "the Cursed", "the Disastrous", "the Inconsolable", "the Unchained", "the Flayer", "the Dauntless", "the Indefensible", "the Unjust", "the Laggard", "the Slacker", "the Slouchy", "the Sullied", "the Defamed", "the Intrepid", "the Fearless", "the Unflinching", "the Stalwart", "the Faithful", "the Disloyal", "the Devoted", "the Bigot", "the Unfaltering", "the Unwavering", "the Unswerving", "the Loyalist", "the Forsaken", "the Wicked", "the Sinister", "the Ominous", "the Baneful", "the Baleful", "the Battered", "the Derelict", "the Dreadful", "the Awful", "the Indolent", "the Forsworn", "the Wayward", "the Hallowed", "the Wayfarer", "the Rebel", "the Bruiser", "the Pestilent", "the Languishing", "the Shambled", "the Aberrant", "the Incongruous", "the Sticky", "the Frigid", "the Erratic", "the Unpredictable", "the Unfazed", "the Unhinged", "the Unstable", "the Frenetic", "the Spiteful", "the Hated"};
        return namelist[new Random().nextInt(namelist.length)] + " " + titlelist[new Random().nextInt(titlelist.length)];
    }
}

