/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.funmod.network;

import com.baranhan123.funmod.util.config.CommonConfig;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class SummonKeeperBoss {
    private final BlockPos pos;
    private final int tier;

    public SummonKeeperBoss(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.tier = buf.readInt();
    }

    public SummonKeeperBoss(int tier, BlockPos pos) {
        this.pos = pos;
        this.tier = tier;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.tier);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.tier == 5) {
                ((NetworkEvent.Context)ctx.get()).getSender().m_6844_(EquipmentSlot.MAINHAND).m_41774_(1);
                WitherSkeleton monster = new WitherSkeleton(EntityType.f_20497_, ((NetworkEvent.Context)ctx.get()).getSender().f_19853_);
                CompoundTag nbt = monster.getPersistentData();
                nbt.m_128379_("isKeeper", true);
                nbt.m_128405_("ID", new Random().nextInt(999999999));
                nbt.m_128405_("tier", this.tier);
                nbt.m_128350_("health", (float)((Double)CommonConfig.lootkeeperBossHealth.get()).doubleValue());
                nbt.m_128347_("armor", ((Double)CommonConfig.lootkeeperArmor.get()).doubleValue());
                nbt.m_128347_("armorT", ((Double)CommonConfig.lootkeeperArmorToughness.get()).doubleValue());
                monster.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42728_));
                AttributeInstance health = monster.m_21051_(Attributes.f_22276_);
                AttributeInstance speed = monster.m_21051_(Attributes.f_22279_);
                AttributeInstance armor = monster.m_21051_(Attributes.f_22284_);
                AttributeInstance armorT = monster.m_21051_(Attributes.f_22285_);
                health.m_22100_((double)(nbt.m_128457_("health") * (float)nbt.m_128451_("tier")));
                speed.m_22100_(speed.m_22115_() + speed.m_22115_() / 5.0 * (double)nbt.m_128451_("tier"));
                armor.m_22100_(nbt.m_128459_("armor") * (double)nbt.m_128451_("tier"));
                armorT.m_22100_(nbt.m_128459_("armor") * (double)nbt.m_128451_("tier"));
                monster.m_5634_(nbt.m_128457_("health") * (float)nbt.m_128451_("tier"));
                monster.m_20340_(true);
                nbt.m_128379_("blinding", true);
                nbt.m_128379_("poisoning", true);
                nbt.m_128379_("withering", true);
                nbt.m_128379_("slowing", true);
                nbt.m_128379_("burning", true);
                nbt.m_128359_("tiercolor", ChatFormatting.DARK_GRAY.toString());
                nbt.m_128405_("tierability", new Random().nextInt(3) + 1);
                MutableComponent finalname = Component.m_237113_((String)(nbt.m_128461_("tiercolor") + SummonKeeperBoss.returnRandomName() + " the Nigh-Omnipotent"));
                monster.m_6593_((Component)finalname);
                monster.m_6034_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_());
                ((NetworkEvent.Context)ctx.get()).getSender().f_19853_.m_7967_((Entity)monster);
                monster.m_6034_(((NetworkEvent.Context)ctx.get()).getSender().m_20185_(), ((NetworkEvent.Context)ctx.get()).getSender().m_20186_(), ((NetworkEvent.Context)ctx.get()).getSender().m_20189_());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static String returnRandomName() {
        String[] namelist = new String[]{"Baran", "Berkan", "Batu", "Ata", "Derek", "Berek", "Azomyte", "Colin", "Artaya", "Kitava", "Malachai", "Mordekai", "Tukohama", "Quin", "Alper", "Furkan", "Ozan", "Gruthkul", "Garukhan", "Kayne", "Felix", "Janus", "Frygon", "Sigrismarr", "Heredur", "Shamx", "Bob", "Biu"};
        return namelist[new Random().nextInt(28)];
    }
}

