/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.funmod.items.armor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.icarusfell.funmod.lists.ItemList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class AngelChestplate
extends ArmorItem {
    public AngelChestplate(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        StringTextComponent lore1 = new StringTextComponent(I18n.func_135052_a((String)"tooltip.angelset_1", (Object[])new Object[0]));
        StringTextComponent lore2 = new StringTextComponent(I18n.func_135052_a((String)"tooltip.angelset_2", (Object[])new Object[0]));
        tooltip.add((ITextComponent)lore1);
        tooltip.add((ITextComponent)lore2);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap oldmodifiers = super.getAttributeModifiers(slot, stack);
        ArrayListMultimap newmodifiers = ArrayListMultimap.create();
        newmodifiers.putAll(oldmodifiers);
        if (slot == EquipmentSlotType.CHEST && stack.func_77973_b().equals(ItemList.angel_chestplate)) {
            newmodifiers.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(UUID.fromString("FFCCDFA1-ADE8-4CEC-9889-76A601463311"), "", 10.0, AttributeModifier.Operation.ADDITION));
        }
        if (slot == EquipmentSlotType.LEGS && stack.func_77973_b().equals(ItemList.angel_leggings)) {
            newmodifiers.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(UUID.fromString("E9143A69-B830-429F-A78E-CFCEE29CF214"), "", 10.0, AttributeModifier.Operation.ADDITION));
        }
        return newmodifiers;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int itemSlot, boolean isSelected) {
        boolean cond1 = false;
        boolean cond2 = false;
        CompoundNBT tag = player.getPersistentData();
        AttributeModifier HEALTH_BONUS = new AttributeModifier(UUID.fromString("84ae7419-dbe9-445a-8d36-7979f2fa10f6"), Attributes.field_233818_a_.func_233754_c_(), 20.0, AttributeModifier.Operation.ADDITION);
        if (((PlayerEntity)player).func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == ItemList.angel_chestplate) {
            cond1 = true;
        }
        if (((PlayerEntity)player).func_184582_a(EquipmentSlotType.LEGS).func_77973_b() == ItemList.angel_leggings) {
            cond2 = true;
        }
        if (cond1 && cond2 && !tag.func_74767_n("SetBonus")) {
            ((PlayerEntity)player).func_110148_a(Attributes.field_233818_a_).func_233767_b_(HEALTH_BONUS);
            tag.func_74757_a("SetBonus", true);
        }
        if (!cond1 && tag.func_74767_n("SetBonus")) {
            ((PlayerEntity)player).func_110148_a(Attributes.field_233818_a_).func_111124_b(HEALTH_BONUS);
            tag.func_74757_a("SetBonus", false);
        }
        if (!cond2 && tag.func_74767_n("SetBonus")) {
            ((PlayerEntity)player).func_110148_a(Attributes.field_233818_a_).func_111124_b(HEALTH_BONUS);
            tag.func_74757_a("SetBonus", false);
        }
    }
}

