/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.funmod.network;

import com.icarusfell.funmod.config.CommonConfig;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class SummonKeeper {
    private final BlockPos pos;
    private final int tier;

    public SummonKeeper(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.tier = buf.readInt();
    }

    public SummonKeeper(int tier, BlockPos pos) {
        this.pos = pos;
        this.tier = tier;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.tier);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (new Random().nextInt(100) + 1 < 50) {
                ((NetworkEvent.Context)ctx.get()).getSender().func_184582_a(EquipmentSlotType.MAINHAND).func_190918_g(1);
                ZombieEntity monster = new ZombieEntity(EntityType.field_200725_aD, ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p);
                CompoundNBT nbt = monster.getPersistentData();
                nbt.func_74757_a("isKeeper", true);
                nbt.func_74768_a("ID", new Random().nextInt(999999999));
                nbt.func_74768_a("tier", this.tier);
                nbt.func_74776_a("health", (float)((Double)CommonConfig.lootkeeperHealth.get()).doubleValue());
                nbt.func_74780_a("armor", ((Double)CommonConfig.lootkeeperArmor.get()).doubleValue());
                nbt.func_74780_a("armorT", ((Double)CommonConfig.lootkeeperArmorToughness.get()).doubleValue());
                if (nbt.func_74762_e("tier") == 1) {
                    monster.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196204_et));
                }
                if (nbt.func_74762_e("tier") == 2) {
                    monster.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196195_ek));
                }
                if (nbt.func_74762_e("tier") == 3) {
                    monster.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196205_eu));
                }
                if (nbt.func_74762_e("tier") == 4) {
                    monster.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196201_eq));
                }
                ModifiableAttributeInstance health = monster.func_110148_a(Attributes.field_233818_a_);
                ModifiableAttributeInstance speed = monster.func_110148_a(Attributes.field_233821_d_);
                ModifiableAttributeInstance armor = monster.func_110148_a(Attributes.field_233826_i_);
                ModifiableAttributeInstance armorT = monster.func_110148_a(Attributes.field_233827_j_);
                health.func_111128_a((double)(nbt.func_74760_g("health") * (float)nbt.func_74762_e("tier")));
                speed.func_111128_a(speed.func_111125_b() + speed.func_111125_b() / 5.0 * (double)nbt.func_74762_e("tier"));
                armor.func_111128_a(nbt.func_74769_h("armor") * (double)nbt.func_74762_e("tier"));
                armorT.func_111128_a(nbt.func_74769_h("armor") * (double)nbt.func_74762_e("tier"));
                monster.func_70691_i(nbt.func_74760_g("health") * (float)nbt.func_74762_e("tier"));
                monster.func_174805_g(true);
                int chancei = new Random().nextInt(7);
                if (chancei == 0) {
                    nbt.func_74757_a("blinding", true);
                    nbt.func_74778_a("tiersuffix", " of Blinding");
                }
                if (chancei == 1) {
                    nbt.func_74757_a("poisoning", true);
                    nbt.func_74778_a("tiersuffix", " of Poisoning");
                }
                if (chancei == 2) {
                    nbt.func_74757_a("withering", true);
                    nbt.func_74778_a("tiersuffix", " of Withering");
                }
                if (chancei == 3) {
                    nbt.func_74757_a("slowing", true);
                    nbt.func_74778_a("tiersuffix", " of Slowing");
                }
                if (chancei == 4) {
                    nbt.func_74757_a("burning", true);
                    nbt.func_74778_a("tiersuffix", " of Burning");
                }
                if (chancei == 5) {
                    nbt.func_74757_a("resistance", true);
                    nbt.func_74778_a("tiersuffix", " of Resistance");
                }
                if (chancei == 6) {
                    nbt.func_74757_a("regeneration", true);
                    nbt.func_74778_a("tiersuffix", " of Regeneration");
                }
                if (nbt.func_74762_e("tier") == 1) {
                    nbt.func_74778_a("tiercolor", "\u00a7a");
                }
                if (nbt.func_74762_e("tier") == 2) {
                    nbt.func_74778_a("tiercolor", "\u00a7e");
                }
                if (nbt.func_74762_e("tier") == 3) {
                    nbt.func_74778_a("tiercolor", "\u00a7c");
                }
                if (nbt.func_74762_e("tier") == 4) {
                    nbt.func_74778_a("tiercolor", "\u00a75");
                }
                nbt.func_74768_a("tierability", new Random().nextInt(3) + 1);
                if (nbt.func_74762_e("tierability") == 1) {
                    nbt.func_74778_a("tierprefix", "Leaping ");
                }
                if (nbt.func_74762_e("tierability") == 2) {
                    nbt.func_74778_a("tierprefix", "Smacking ");
                }
                if (nbt.func_74762_e("tierability") == 3) {
                    nbt.func_74778_a("tierprefix", "Thrusting ");
                }
                StringTextComponent finalname = new StringTextComponent(nbt.func_74779_i("tiercolor") + nbt.func_74779_i("tierprefix") + SummonKeeper.returnRandomName() + nbt.func_74779_i("tiersuffix"));
                monster.func_200203_b((ITextComponent)finalname);
                monster.func_70107_b((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
                ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_217376_c((Entity)monster);
                monster.func_70107_b(((NetworkEvent.Context)ctx.get()).getSender().func_226277_ct_(), ((NetworkEvent.Context)ctx.get()).getSender().func_226278_cu_(), ((NetworkEvent.Context)ctx.get()).getSender().func_226281_cx_());
            } else {
                ((NetworkEvent.Context)ctx.get()).getSender().func_184582_a(EquipmentSlotType.MAINHAND).func_190918_g(1);
                SkeletonEntity monster = new SkeletonEntity(EntityType.field_200741_ag, ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p);
                CompoundNBT nbt = monster.getPersistentData();
                monster.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
                nbt.func_74757_a("isKeeper", true);
                nbt.func_74768_a("ID", new Random().nextInt(999999999));
                nbt.func_74768_a("tier", this.tier);
                nbt.func_74776_a("health", 250.0f);
                nbt.func_74780_a("armor", 7.5);
                nbt.func_74780_a("armorT", 5.0);
                if (nbt.func_74762_e("tier") == 1) {
                    monster.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196204_et));
                }
                if (nbt.func_74762_e("tier") == 2) {
                    monster.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196195_ek));
                }
                if (nbt.func_74762_e("tier") == 3) {
                    monster.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196205_eu));
                }
                if (nbt.func_74762_e("tier") == 4) {
                    monster.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196201_eq));
                }
                ModifiableAttributeInstance health = monster.func_110148_a(Attributes.field_233818_a_);
                ModifiableAttributeInstance speed = monster.func_110148_a(Attributes.field_233821_d_);
                ModifiableAttributeInstance armor = monster.func_110148_a(Attributes.field_233826_i_);
                ModifiableAttributeInstance armorT = monster.func_110148_a(Attributes.field_233827_j_);
                health.func_111128_a((double)(nbt.func_74760_g("health") * (float)nbt.func_74762_e("tier")));
                speed.func_111128_a(speed.func_111125_b() + speed.func_111125_b() / 5.0 * (double)nbt.func_74762_e("tier"));
                armor.func_111128_a(nbt.func_74769_h("armor") * (double)nbt.func_74762_e("tier"));
                armorT.func_111128_a(nbt.func_74769_h("armor") * (double)nbt.func_74762_e("tier"));
                monster.func_70691_i(nbt.func_74760_g("health") * (float)nbt.func_74762_e("tier"));
                monster.func_174805_g(true);
                int chancei = new Random().nextInt(7);
                if (chancei == 0) {
                    nbt.func_74757_a("blinding", true);
                    nbt.func_74778_a("tiersuffix", " of Blinding");
                }
                if (chancei == 1) {
                    nbt.func_74757_a("poisoning", true);
                    nbt.func_74778_a("tiersuffix", " of Poisoning");
                }
                if (chancei == 2) {
                    nbt.func_74757_a("withering", true);
                    nbt.func_74778_a("tiersuffix", " of Withering");
                }
                if (chancei == 3) {
                    nbt.func_74757_a("slowing", true);
                    nbt.func_74778_a("tiersuffix", " of Slowing");
                }
                if (chancei == 4) {
                    nbt.func_74757_a("burning", true);
                    nbt.func_74778_a("tiersuffix", " of Burning");
                }
                if (chancei == 5) {
                    nbt.func_74757_a("resistance", true);
                    nbt.func_74778_a("tiersuffix", " of Resistance");
                }
                if (chancei == 6) {
                    nbt.func_74757_a("regeneration", true);
                    nbt.func_74778_a("tiersuffix", " of Regeneration");
                }
                if (nbt.func_74762_e("tier") == 1) {
                    nbt.func_74778_a("tiercolor", "\u00a7a");
                }
                if (nbt.func_74762_e("tier") == 2) {
                    nbt.func_74778_a("tiercolor", "\u00a7e");
                }
                if (nbt.func_74762_e("tier") == 3) {
                    nbt.func_74778_a("tiercolor", "\u00a7c");
                }
                if (nbt.func_74762_e("tier") == 4) {
                    nbt.func_74778_a("tiercolor", "\u00a75");
                }
                nbt.func_74768_a("tierability", new Random().nextInt(3) + 1);
                if (nbt.func_74762_e("tierability") == 1) {
                    nbt.func_74778_a("tierprefix", "Leaping ");
                }
                if (nbt.func_74762_e("tierability") == 2) {
                    nbt.func_74778_a("tierprefix", "Smacking ");
                }
                if (nbt.func_74762_e("tierability") == 3) {
                    nbt.func_74778_a("tierprefix", "Thrusting ");
                }
                StringTextComponent finalname = new StringTextComponent(nbt.func_74779_i("tiercolor") + nbt.func_74779_i("tierprefix") + SummonKeeper.returnRandomName() + nbt.func_74779_i("tiersuffix"));
                monster.func_200203_b((ITextComponent)finalname);
                monster.func_70107_b((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
                ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_217376_c((Entity)monster);
                monster.func_70107_b(((NetworkEvent.Context)ctx.get()).getSender().func_226277_ct_(), ((NetworkEvent.Context)ctx.get()).getSender().func_226278_cu_(), ((NetworkEvent.Context)ctx.get()).getSender().func_226281_cx_());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static String returnRandomName() {
        String[] namelist = new String[]{"Baran", "Berkan", "Batu", "Ata", "Derek", "Berek", "Azomyte", "Colin", "Artaya", "Kitava", "Malachai", "Mordekai", "Tukohama", "Quin", "Alper", "Furkan", "Ozan", "Gruthkul", "Garukhan", "Kayne", "Felix", "Janus", "Frygon", "Sigrismarr", "Heredur", "Shamx", "Bob", "Biu"};
        String[] titlelist = new String[]{"the Brutal", "the Savage", "the Smart", "the Swift", "the Tinkerer", "the Mighty", "the Undefeated", "the Shadow", "the Unseen", "the Heathen", "the Magnificent", "the Dangereous", "the Maniac", "the Tremendous", "the Insatiable", "the Spooky", "the Scary", "the Menacing", "the Deadly"};
        return namelist[new Random().nextInt(28)] + " " + titlelist[new Random().nextInt(19)];
    }
}

