/*
 * Decompiled with CFR 0.152.
 */
package com.icarusfell.funmod.util.handlers;

import com.icarusfell.funmod.Main;
import com.icarusfell.funmod.config.CommonConfig;
import com.icarusfell.funmod.lists.ItemList;
import com.icarusfell.funmod.network.Networking;
import com.icarusfell.funmod.network.SyncValues;
import com.icarusfell.funmod.util.handlers.MethodHelper;
import com.icarusfell.funmod.util.handlers.MobSkillHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MobSpawnHandler {
    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (!(!(event.getEntity() instanceof MonsterEntity) || event.getEntity() instanceof WitherEntity || event.getEntity() instanceof EnderDragonEntity || event.getEntity() instanceof CreeperEntity || new Random().nextInt((Integer)CommonConfig.lootkeeperChanceIn.get()) >= (Integer)CommonConfig.lootkeeperChance.get() || event.getEntity().getPersistentData().func_74767_n("isKeeper"))) {
            CompoundNBT nbt = event.getEntity().getPersistentData();
            nbt.func_74757_a("isKeeper", true);
            nbt.func_74768_a("ID", new Random().nextInt(999999999));
            if (new Random().nextInt(100) + 1 < 60) {
                nbt.func_74768_a("tier", 1);
            } else if (new Random().nextInt(100) + 1 < 60) {
                nbt.func_74768_a("tier", 2);
            } else if (new Random().nextInt(100) + 1 < 60) {
                nbt.func_74768_a("tier", 3);
            } else {
                nbt.func_74768_a("tier", 4);
            }
            nbt.func_74776_a("attackDamage", 10.0f);
            nbt.func_74776_a("health", (float)((Double)CommonConfig.lootkeeperHealth.get()).doubleValue());
            nbt.func_74780_a("armor", ((Double)CommonConfig.lootkeeperArmor.get()).doubleValue());
            nbt.func_74780_a("armorT", ((Double)CommonConfig.lootkeeperArmorToughness.get()).doubleValue());
            if (nbt.func_74762_e("tier") == 1) {
                ((LivingEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196204_et));
            }
            if (nbt.func_74762_e("tier") == 2) {
                ((LivingEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196195_ek));
            }
            if (nbt.func_74762_e("tier") == 3) {
                ((LivingEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196205_eu));
            }
            if (nbt.func_74762_e("tier") == 4) {
                ((LivingEntity)event.getEntity()).func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_196201_eq));
            }
            ModifiableAttributeInstance health = ((LivingEntity)event.getEntity()).func_110148_a(Attributes.field_233818_a_);
            ModifiableAttributeInstance speed = ((LivingEntity)event.getEntity()).func_110148_a(Attributes.field_233821_d_);
            ModifiableAttributeInstance armor = ((LivingEntity)event.getEntity()).func_110148_a(Attributes.field_233826_i_);
            ModifiableAttributeInstance armorT = ((LivingEntity)event.getEntity()).func_110148_a(Attributes.field_233827_j_);
            health.func_111128_a((double)(nbt.func_74760_g("health") * (float)nbt.func_74762_e("tier")));
            speed.func_111128_a(speed.func_111125_b() + speed.func_111125_b() / 5.0 * (double)nbt.func_74762_e("tier"));
            armor.func_111128_a(nbt.func_74769_h("armor") * (double)nbt.func_74762_e("tier"));
            armorT.func_111128_a(nbt.func_74769_h("armor") * (double)nbt.func_74762_e("tier"));
            ((LivingEntity)event.getEntity()).func_70691_i(nbt.func_74760_g("health") * (float)nbt.func_74762_e("tier"));
            event.getEntity().func_174805_g(true);
            int chancei = new Random().nextInt(7);
            if (chancei == 0) {
                nbt.func_74757_a("blinding", true);
                nbt.func_74778_a("tiersuffix", " of Blinding");
            }
            if (chancei == 1) {
                nbt.func_74757_a("poisoning", true);
                nbt.func_74778_a("tiersuffix", " of Poisoning");
            }
            if (chancei == 2) {
                nbt.func_74757_a("withering", true);
                nbt.func_74778_a("tiersuffix", " of Withering");
            }
            if (chancei == 3) {
                nbt.func_74757_a("slowing", true);
                nbt.func_74778_a("tiersuffix", " of Slowing");
            }
            if (chancei == 4) {
                nbt.func_74757_a("burning", true);
                nbt.func_74778_a("tiersuffix", " of Burning");
            }
            if (chancei == 5) {
                nbt.func_74757_a("resistance", true);
                nbt.func_74778_a("tiersuffix", " of Resistance");
            }
            if (chancei == 6) {
                nbt.func_74757_a("regeneration", true);
                nbt.func_74778_a("tiersuffix", " of Regeneration");
            }
            if (nbt.func_74762_e("tier") == 1) {
                nbt.func_74778_a("tiercolor", "\u00a7a");
            }
            if (nbt.func_74762_e("tier") == 2) {
                nbt.func_74778_a("tiercolor", "\u00a7e");
            }
            if (nbt.func_74762_e("tier") == 3) {
                nbt.func_74778_a("tiercolor", "\u00a7c");
            }
            if (nbt.func_74762_e("tier") == 4) {
                nbt.func_74778_a("tiercolor", "\u00a75");
            }
            nbt.func_74768_a("tierability", new Random().nextInt(3) + 1);
            if (nbt.func_74762_e("tierability") == 1) {
                nbt.func_74778_a("tierprefix", "Leaping ");
            }
            if (nbt.func_74762_e("tierability") == 2) {
                nbt.func_74778_a("tierprefix", "Smacking ");
            }
            if (nbt.func_74762_e("tierability") == 3) {
                nbt.func_74778_a("tierprefix", "Thrusting ");
            }
            StringTextComponent finalname = new StringTextComponent(nbt.func_74779_i("tiercolor") + nbt.func_74779_i("tierprefix") + MobSpawnHandler.returnRandomName() + nbt.func_74779_i("tiersuffix"));
            event.getEntity().func_200203_b((ITextComponent)finalname);
        }
    }

    @SubscribeEvent
    public void keeperHit(LivingHurtEvent event) {
        CompoundNBT nbt;
        if (event.getSource().func_76346_g() instanceof MonsterEntity && event.getEntity() instanceof PlayerEntity && (nbt = event.getSource().func_76346_g().getPersistentData()).func_74767_n("isKeeper")) {
            if (nbt.func_74767_n("blinding")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effect.func_188412_a((int)15), 100, 2));
            }
            if (nbt.func_74767_n("withering")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effect.func_188412_a((int)20), 100, 2));
            }
            if (nbt.func_74767_n("poisoning")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effect.func_188412_a((int)19), 100, 2));
            }
            if (nbt.func_74767_n("slowing")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effect.func_188412_a((int)2), 100, 2));
            }
            if (nbt.func_74767_n("burning")) {
                ((LivingEntity)event.getEntity()).func_70015_d(5);
            }
            MobSkillHandler.LKAbility(event.getSource().func_76346_g(), event.getEntity(), 100, nbt.func_74762_e("tierability"), event.getEntity().field_70170_p);
            event.getEntity().func_70097_a(DamageSource.func_76358_a((LivingEntity)event.getEntityLiving()), 10.0f * (float)nbt.func_74762_e("tier"));
            if (nbt.func_74762_e("tier") == 5) {
                if (event.getEntity().getPersistentData().func_74762_e("tierfivehits") > 3) {
                    event.getEntity().getPersistentData().func_74768_a("tierfivehits", 0);
                    event.getEntity().func_70097_a(DamageSource.func_76358_a((LivingEntity)event.getEntityLiving()), 10.0f * (float)nbt.func_74762_e("tier"));
                } else {
                    event.getEntity().getPersistentData().func_74768_a("tierfivehits", event.getEntity().getPersistentData().func_74762_e("tierfivehits") + 1);
                }
            }
        }
    }

    @SubscribeEvent
    public void keeperHurt(LivingHurtEvent event) {
        CompoundNBT nbt;
        if (event.getEntity() instanceof MonsterEntity && event.getSource().func_76346_g() instanceof PlayerEntity && (nbt = event.getEntity().getPersistentData()).func_74767_n("isKeeper") && new Random().nextInt(3) + 1 == 2) {
            event.getEntity().func_213293_j(event.getSource().func_76346_g().func_70040_Z().field_72450_a * 2.5, event.getSource().func_76346_g().func_70040_Z().field_72448_b * 2.0, event.getSource().func_76346_g().func_70040_Z().field_72449_c * 2.5);
        }
    }

    @SubscribeEvent
    public void keeperDeath(LivingDeathEvent event) {
        CompoundNBT nbt;
        if (event.getEntity() instanceof MonsterEntity && event.getSource().func_76346_g() instanceof PlayerEntity && (nbt = event.getEntity().getPersistentData()).func_74767_n("isKeeper")) {
            ItemStack i = nbt.func_74762_e("tier") == 1 ? new ItemStack((IItemProvider)ItemList.lootchest_keeper1) : (nbt.func_74762_e("tier") == 2 ? new ItemStack((IItemProvider)ItemList.lootchest_keeper2) : (nbt.func_74762_e("tier") == 3 ? new ItemStack((IItemProvider)ItemList.lootchest_keeper3) : (nbt.func_74762_e("tier") == 4 ? new ItemStack((IItemProvider)ItemList.lootchest_keeper4) : new ItemStack((IItemProvider)ItemList.lootchest_keeper5))));
            ItemEntity ie = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), i);
            event.getEntity().field_70170_p.func_217376_c((Entity)ie);
            ie.func_184195_f(true);
            ie.func_200203_b(i.func_151000_E());
            ie.func_174805_g(true);
        }
    }

    @SubscribeEvent
    public void justWandering(LivingEvent.LivingUpdateEvent event) {
        CompoundNBT nbt;
        if (event.getEntity() instanceof MonsterEntity && (nbt = event.getEntity().getPersistentData()).func_74767_n("isKeeper")) {
            List players;
            if (nbt.func_74767_n("resistance")) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effects.field_76429_m, 5, 1));
            }
            if (nbt.func_74767_n("regeneration")) {
                ((LivingEntity)event.getEntity()).func_70691_i(0.05f);
            }
            if (!(players = event.getEntity().field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(event.getEntity().func_226277_ct_() - 20.0, event.getEntity().func_226278_cu_() - 20.0, event.getEntity().func_226281_cx_() - 20.0, event.getEntity().func_226277_ct_() + 20.0, event.getEntity().func_226278_cu_() + 20.0, event.getEntity().func_226281_cx_() + 20.0))).isEmpty() && Main.returnIntegerBetween(300, 1) == 1) {
                event.getEntity().func_213293_j(event.getEntity().func_70040_Z().field_72450_a * 2.5, event.getEntity().func_70040_Z().field_72448_b * 2.0, event.getEntity().func_70040_Z().field_72449_c * 2.5);
            }
            if (nbt.func_74762_e("tier") == 5) {
                ((LivingEntity)event.getEntity()).func_195064_c(new EffectInstance(Effects.field_76429_m, 5, 3));
                ((LivingEntity)event.getEntity()).func_70691_i(0.05f);
            }
        }
    }

    @SubscribeEvent
    public void searchMobsAndApply(TickEvent.PlayerTickEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            PlayerEntity player = e.player;
            ArrayList<Entity> undefeatableList = new ArrayList<Entity>();
            List<Entity> entityList = MethodHelper.getEntitiesInRadius(player, 30);
            HashMap<Entity, Integer> entityMap = new HashMap<Entity, Integer>();
            for (Entity en : entityList) {
                if (!MethodHelper.isKeeper(en)) continue;
                undefeatableList.add(en);
            }
            if (undefeatableList.isEmpty()) {
                MethodHelper.setBossbar(player, false);
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SyncValues(MethodHelper.getInheritedDefaultHealth(player), MethodHelper.getInheritedMaxHealth(player), MethodHelper.getInheritedTier(player), MethodHelper.isBossbarOn(player), MethodHelper.getInheritedName(player)));
                return;
            }
            MethodHelper.setBossbar(player, true);
            for (Entity en : undefeatableList) {
                int distance = (int)MethodHelper.getDistanceTo(en, (Entity)player);
                entityMap.put(en, distance);
            }
            Map.Entry min = null;
            for (Map.Entry entry : entityMap.entrySet()) {
                if (min != null && (Integer)min.getValue() <= (Integer)entry.getValue()) continue;
                min = entry;
            }
            if (MethodHelper.getInheritedDefaultHealth(player) != ((LivingEntity)min.getKey()).func_110143_aJ()) {
                MethodHelper.setInheritedDefaultHealth(player, ((LivingEntity)min.getKey()).func_110143_aJ());
            }
            if (MethodHelper.getInheritedMaxHealth(player) != ((LivingEntity)min.getKey()).func_110138_aP()) {
                MethodHelper.setInheritedMaxHealth(player, ((LivingEntity)min.getKey()).func_110138_aP());
            }
            if (MethodHelper.getInheritedTier(player) != MethodHelper.getTier((Entity)min.getKey())) {
                MethodHelper.setInheritedTier(player, MethodHelper.getTier((Entity)min.getKey()));
            }
            if (!MethodHelper.getInheritedName(player).contains(((LivingEntity)min.getKey()).func_145748_c_().getString())) {
                MethodHelper.setInheritedName(player, ((LivingEntity)min.getKey()).func_145748_c_().getString());
            }
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SyncValues(MethodHelper.getInheritedDefaultHealth(player), MethodHelper.getInheritedMaxHealth(player), MethodHelper.getInheritedTier(player), MethodHelper.isBossbarOn(player), MethodHelper.getInheritedName(player)));
        }
    }

    public static String returnRandomName() {
        String[] namelist = new String[]{"Baran", "Berkan", "Batu", "Ata", "Derek", "Berek", "Azomyte", "Colin", "Artaya", "Kitava", "Malachai", "Mordekai", "Tukohama", "Quin", "Alper", "Furkan", "Ozan", "Gruthkul", "Garukhan", "Kayne", "Felix", "Janus", "Frygon", "Sigrismarr", "Heredur", "Shamx", "Bob", "Biu"};
        String[] titlelist = new String[]{"the Brutal", "the Savage", "the Smart", "the Swift", "the Tinkerer", "the Mighty", "the Undefeated", "the Shadow", "the Unseen", "the Heathen", "the Magnificent", "the Dangereous", "the Maniac", "the Tremendous", "the Insatiable", "the Spooky", "the Scary", "the Menacing", "the Deadly"};
        return namelist[new Random().nextInt(28)] + " " + titlelist[new Random().nextInt(19)];
    }

    @SubscribeEvent
    public void onEntitySpawn(PlayerEvent.PlayerRespawnEvent event) {
        CompoundNBT nbt = event.getPlayer().getPersistentData();
        AttributeModifier HEALTH_BONUS = new AttributeModifier(UUID.fromString("84ae7419-dbe9-445a-8d36-7979f2fa10f6"), Attributes.field_233818_a_.func_233754_c_(), 20.0, AttributeModifier.Operation.ADDITION);
        event.getPlayer().func_110148_a(Attributes.field_233818_a_).func_111124_b(HEALTH_BONUS);
        nbt.func_74757_a("SetBonus", false);
        nbt.func_74757_a("joinedBefore", true);
    }
}

