/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AbstractPrimitiveMachineBlock;
import com.yanny.ytech.configuration.block.AmphoraBlock;
import com.yanny.ytech.configuration.block.BronzeAnvilBlock;
import com.yanny.ytech.configuration.block.DryingRackBlock;
import com.yanny.ytech.configuration.block.FirePitBlock;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block.MillstoneBlock;
import com.yanny.ytech.configuration.block.PottersWheelBlock;
import com.yanny.ytech.configuration.block.TanningRackBlock;
import com.yanny.ytech.configuration.block.ToolRackBlock;
import com.yanny.ytech.configuration.block.TreeStumpBlock;
import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.configuration.block_entity.AmphoraBlockEntity;
import com.yanny.ytech.configuration.block_entity.AqueductFertilizerBlockEntity;
import com.yanny.ytech.configuration.block_entity.AqueductHydratorBlockEntity;
import com.yanny.ytech.configuration.block_entity.BronzeAnvilBlockEntity;
import com.yanny.ytech.configuration.block_entity.DryingRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.FirePitBlockEntity;
import com.yanny.ytech.configuration.block_entity.IrrigationBlockEntity;
import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.block_entity.PottersWheelBlockEntity;
import com.yanny.ytech.configuration.block_entity.TanningRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.ToolRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.TreeStumpBlockEntity;
import com.yanny.ytech.configuration.block_entity.WoodenBoxBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class JadeCompatibility
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)DryingRackProvider.INSTANCE, DryingRackBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)MillstoneProvider.INSTANCE, MillstoneBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)TanningRackProvider.INSTANCE, TanningRackBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)PrimitiveMachineProvider.INSTANCE, AbstractPrimitiveMachineBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)IrrigationProvider.INSTANCE, IrrigationBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)FirePitProvider.INSTANCE, FirePitBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)TreeStumpProvider.INSTANCE, TreeStumpBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)BronzeAnvilProvider.INSTANCE, BronzeAnvilBlock.class);
        registration.registerBlockComponent((IComponentProvider)DryingRackProvider.INSTANCE, DryingRackBlock.class);
        registration.registerBlockComponent((IComponentProvider)MillstoneProvider.INSTANCE, MillstoneBlock.class);
        registration.registerBlockComponent((IComponentProvider)TanningRackProvider.INSTANCE, TanningRackBlock.class);
        registration.registerBlockComponent((IComponentProvider)PrimitiveMachineProvider.INSTANCE, AbstractPrimitiveMachineBlock.class);
        registration.registerBlockComponent((IComponentProvider)IrrigationProvider.INSTANCE, IrrigationBlock.class);
        registration.registerBlockComponent((IComponentProvider)PottersWheelProvider.INSTANCE, PottersWheelBlock.class);
        registration.registerBlockComponent((IComponentProvider)FirePitProvider.INSTANCE, FirePitBlock.class);
        registration.registerBlockComponent((IComponentProvider)TreeStumpProvider.INSTANCE, TreeStumpBlock.class);
        registration.registerBlockComponent((IComponentProvider)AmphoraProvider.INSTANCE, AmphoraBlock.class);
        registration.registerBlockComponent((IComponentProvider)WoodenBoxProvider.INSTANCE, WoodenBoxBlock.class);
        registration.registerBlockComponent((IComponentProvider)ToolRackProvider.INSTANCE, ToolRackBlock.class);
    }

    private static class DryingRackProvider
    implements IBlockComponentProvider,
    StreamServerDataProvider<BlockAccessor, Data> {
        private static final DryingRackProvider INSTANCE = new DryingRackProvider();

        private DryingRackProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            this.decodeFromData((Accessor)blockAccessor).ifPresent(data -> iTooltip.add((Component)Component.translatable((String)"text.ytech.top.drying_rack.progress", (Object[])new Object[]{data.progress})));
        }

        @Nullable
        public Data streamData(BlockAccessor accessor) {
            DryingRackBlockEntity blockEntity = (DryingRackBlockEntity)accessor.getBlockEntity();
            if (!blockEntity.getItem().isEmpty()) {
                return new Data(blockEntity.getProgress());
            }
            return null;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
            return Data.STREAM_CODEC.cast();
        }

        public ResourceLocation getUid() {
            return Utils.modLoc("drying_racks");
        }

        private record Data(int progress) {
            private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::progress, Data::new);
        }
    }

    private static class MillstoneProvider
    implements IBlockComponentProvider,
    StreamServerDataProvider<BlockAccessor, Data> {
        private static final MillstoneProvider INSTANCE = new MillstoneProvider();

        private MillstoneProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            this.decodeFromData((Accessor)blockAccessor).ifPresent(data -> {
                if (!data.item.isEmpty()) {
                    IElementHelper elements = IElementHelper.get();
                    iTooltip.add(elements.item(data.item));
                }
            });
        }

        @Nullable
        public Data streamData(BlockAccessor accessor) {
            MillstoneBlockEntity blockEntity = (MillstoneBlockEntity)accessor.getBlockEntity();
            return new Data(blockEntity.getInputItem());
        }

        public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
            return Data.STREAM_CODEC.cast();
        }

        public ResourceLocation getUid() {
            return YTechBlocks.MILLSTONE.getId();
        }

        private record Data(ItemStack item) {
            private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, Data::item, Data::new);
        }
    }

    private static class TanningRackProvider
    implements IBlockComponentProvider,
    StreamServerDataProvider<BlockAccessor, Data> {
        private static final TanningRackProvider INSTANCE = new TanningRackProvider();

        private TanningRackProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            this.decodeFromData((Accessor)blockAccessor).ifPresent(data -> iTooltip.add((Component)Component.translatable((String)"text.ytech.top.tanning_rack.progress", (Object[])new Object[]{data.progress})));
        }

        @Nullable
        public Data streamData(BlockAccessor accessor) {
            TanningRackBlockEntity blockEntity = (TanningRackBlockEntity)accessor.getBlockEntity();
            if (!blockEntity.getItem().isEmpty()) {
                return new Data(blockEntity.getProgress());
            }
            return null;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
            return Data.STREAM_CODEC.cast();
        }

        public ResourceLocation getUid() {
            return Utils.modLoc("tanning_racks");
        }

        private record Data(int progress) {
            private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::progress, Data::new);
        }
    }

    private static class PrimitiveMachineProvider
    implements IBlockComponentProvider,
    StreamServerDataProvider<BlockAccessor, Data> {
        private static final PrimitiveMachineProvider INSTANCE = new PrimitiveMachineProvider();

        private PrimitiveMachineProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor accessor, IPluginConfig iPluginConfig) {
            this.decodeFromData((Accessor)accessor).ifPresent(data -> {
                if (data.activeRecipe) {
                    iTooltip.add((Component)Component.translatable((String)"text.ytech.top.smelter.progress", (Object[])new Object[]{data.progress}));
                }
                iTooltip.add((Component)Component.translatable((String)"text.ytech.top.smelter.temperature", (Object[])new Object[]{data.temperature}));
            });
        }

        @Nullable
        public Data streamData(BlockAccessor accessor) {
            AbstractPrimitiveMachineBlockEntity blockEntity = (AbstractPrimitiveMachineBlockEntity)accessor.getBlockEntity();
            return new Data(blockEntity.progress(), blockEntity.temperature(), blockEntity.hasActiveRecipe());
        }

        public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
            return Data.STREAM_CODEC.cast();
        }

        public ResourceLocation getUid() {
            return Utils.modLoc("primitive_machines");
        }

        private record Data(int progress, int temperature, boolean activeRecipe) {
            private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::progress, (StreamCodec)ByteBufCodecs.VAR_INT, Data::temperature, (StreamCodec)ByteBufCodecs.BOOL, Data::activeRecipe, Data::new);
        }
    }

    private static class IrrigationProvider
    implements IBlockComponentProvider,
    StreamServerDataProvider<BlockAccessor, Data> {
        private static final IrrigationProvider INSTANCE = new IrrigationProvider();

        private IrrigationProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor accessor, IPluginConfig iPluginConfig) {
            this.decodeFromData((Accessor)accessor).ifPresent(data -> {
                data.production.ifPresent(value -> iTooltip.add((Component)Component.translatable((String)"text.ytech.top.irrigation.production", (Object[])new Object[]{value})));
                data.hydrating.ifPresent(x -> iTooltip.add((Component)Component.translatable((String)"text.ytech.top.irrigation.hydrating")));
                data.fertilizing.ifPresent(x -> iTooltip.add((Component)Component.translatable((String)"text.ytech.top.irrigation.fertilizing")));
                if (data.amount.isPresent() && data.capacity.isPresent()) {
                    iTooltip.add((Component)Component.translatable((String)"text.ytech.top.irrigation.network", (Object[])new Object[]{data.amount.get(), data.capacity.get()}));
                }
            });
        }

        @Nullable
        public Data streamData(BlockAccessor accessor) {
            IrrigationBlockEntity blockEntity = (IrrigationBlockEntity)accessor.getBlockEntity();
            Optional<Integer> production = Optional.empty();
            Optional<Boolean> hydrating = Optional.empty();
            Optional<Boolean> fertilizing = Optional.empty();
            Optional<Integer> amount = Optional.empty();
            Optional<Integer> capacity = Optional.empty();
            switch (blockEntity.getNetworkType()) {
                case PROVIDER: {
                    production = Optional.of(Math.round((float)blockEntity.getFlow() * (20.0f / (float)YTechMod.CONFIGURATION.getValveFillPerNthTick())));
                    break;
                }
                case CONSUMER: {
                    AqueductFertilizerBlockEntity fertilizerBlock;
                    AqueductHydratorBlockEntity hydratorBlock;
                    if (blockEntity instanceof AqueductHydratorBlockEntity && (hydratorBlock = (AqueductHydratorBlockEntity)blockEntity).isHydrating()) {
                        hydrating = Optional.of(true);
                    }
                    if (!(blockEntity instanceof AqueductFertilizerBlockEntity) || !(fertilizerBlock = (AqueductFertilizerBlockEntity)blockEntity).isFertilizing()) break;
                    fertilizing = Optional.of(true);
                }
            }
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(blockEntity);
            if (network != null) {
                amount = Optional.of(network.getFluidHandler().getFluidAmount());
                capacity = Optional.of(network.getFluidHandler().getCapacity());
            }
            return new Data(production, hydrating, fertilizing, amount, capacity);
        }

        public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
            return Data.STREAM_CODEC.cast();
        }

        public ResourceLocation getUid() {
            return Utils.modLoc("irrigation");
        }

        private record Data(Optional<Integer> production, Optional<Boolean> hydrating, Optional<Boolean> fertilizing, Optional<Integer> amount, Optional<Integer> capacity) {
            private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), Data::production, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), Data::hydrating, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), Data::fertilizing, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), Data::amount, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), Data::capacity, Data::new);
        }
    }

    private static class FirePitProvider
    implements IBlockComponentProvider,
    StreamServerDataProvider<BlockAccessor, Data> {
        private static final FirePitProvider INSTANCE = new FirePitProvider();

        private FirePitProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            this.decodeFromData((Accessor)blockAccessor).ifPresent(data -> iTooltip.add((Component)Component.translatable((String)"text.ytech.top.fire_pit.progress", (Object[])new Object[]{data.progress})));
        }

        @Nullable
        public Data streamData(BlockAccessor accessor) {
            FirePitBlockEntity blockEntity = (FirePitBlockEntity)accessor.getBlockEntity();
            if (!blockEntity.getItem().isEmpty()) {
                return new Data(blockEntity.getProgress());
            }
            return null;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
            return Data.STREAM_CODEC.cast();
        }

        public ResourceLocation getUid() {
            return YTechBlocks.FIRE_PIT.getId();
        }

        private record Data(int progress) {
            private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::progress, Data::new);
        }
    }

    private static class TreeStumpProvider
    implements IBlockComponentProvider,
    StreamServerDataProvider<BlockAccessor, Data> {
        private static final TreeStumpProvider INSTANCE = new TreeStumpProvider();

        private TreeStumpProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            this.decodeFromData((Accessor)blockAccessor).ifPresent(data -> iTooltip.add((Component)Component.translatable((String)"text.ytech.top.tree_stump.progress", (Object[])new Object[]{data.progress})));
        }

        @Nullable
        public Data streamData(BlockAccessor accessor) {
            TreeStumpBlockEntity blockEntity = (TreeStumpBlockEntity)accessor.getBlockEntity();
            if (!blockEntity.getItem().isEmpty()) {
                return new Data(blockEntity.getProgress());
            }
            return null;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
            return Data.STREAM_CODEC.cast();
        }

        public ResourceLocation getUid() {
            return YTechBlocks.TREE_STUMP.getId();
        }

        private record Data(int progress) {
            private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::progress, Data::new);
        }
    }

    private static class BronzeAnvilProvider
    implements IBlockComponentProvider {
        private static final BronzeAnvilProvider INSTANCE = new BronzeAnvilProvider();

        private BronzeAnvilProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BronzeAnvilBlockEntity blockEntity;
            BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
            if (blockEntity2 instanceof BronzeAnvilBlockEntity && !(blockEntity = (BronzeAnvilBlockEntity)blockEntity2).getItem().isEmpty()) {
                IElementHelper elements = IElementHelper.get();
                iTooltip.add(elements.item(blockEntity.getItem()));
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.BRONZE_ANVIL.getId();
        }
    }

    private static class PottersWheelProvider
    implements IBlockComponentProvider {
        private static final PottersWheelProvider INSTANCE = new PottersWheelProvider();

        private PottersWheelProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            PottersWheelBlockEntity blockEntity;
            BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
            if (blockEntity2 instanceof PottersWheelBlockEntity && !(blockEntity = (PottersWheelBlockEntity)blockEntity2).getItem().isEmpty()) {
                IElementHelper elements = IElementHelper.get();
                iTooltip.add(elements.item(blockEntity.getItem()));
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.POTTERS_WHEEL.getId();
        }
    }

    private static class AmphoraProvider
    implements IBlockComponentProvider {
        private static final AmphoraProvider INSTANCE = new AmphoraProvider();

        private AmphoraProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            AmphoraBlockEntity blockEntity;
            BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
            if (blockEntity2 instanceof AmphoraBlockEntity && !(blockEntity = (AmphoraBlockEntity)blockEntity2).getItem().isEmpty()) {
                IElementHelper elements = IElementHelper.get();
                iTooltip.add(elements.item(blockEntity.getItem()));
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.AMPHORA.getId();
        }
    }

    private static class WoodenBoxProvider
    implements IBlockComponentProvider {
        private static final WoodenBoxProvider INSTANCE = new WoodenBoxProvider();

        private WoodenBoxProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof WoodenBoxBlockEntity) {
                WoodenBoxBlockEntity blockEntity2 = (WoodenBoxBlockEntity)blockEntity;
                IElementHelper elements = IElementHelper.get();
                ItemStack item = blockEntity2.getItem(blockAccessor.getPosition(), blockAccessor.getSide(), ((BlockHitResult)blockAccessor.getHitResult()).getLocation());
                if (!item.isEmpty()) {
                    iTooltip.add(elements.item(item));
                    iTooltip.append(item.getItemName());
                }
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.WOODEN_BOX.getId();
        }
    }

    private static class ToolRackProvider
    implements IBlockComponentProvider {
        private static final ToolRackProvider INSTANCE = new ToolRackProvider();

        private ToolRackProvider() {
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof ToolRackBlockEntity) {
                ToolRackBlockEntity blockEntity2 = (ToolRackBlockEntity)blockEntity;
                IElementHelper elements = IElementHelper.get();
                ItemStack item = blockEntity2.getItem(blockAccessor.getPosition(), blockAccessor.getSide(), ((BlockHitResult)blockAccessor.getHitResult()).getLocation());
                if (!item.isEmpty()) {
                    iTooltip.add(elements.item(item));
                    iTooltip.append(item.getItemName());
                }
            }
        }

        public ResourceLocation getUid() {
            return YTechBlocks.TOOL_RACK.getId();
        }
    }
}

