/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.block.Block;

public enum YTechToolMaterials {
    IRON(MaterialType.IRON, ToolMaterial.IRON),
    GOLD(MaterialType.GOLD, ToolMaterial.GOLD),
    COPPER(MaterialType.COPPER, (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 160, 5.0f, 0.5f, 10),
    BRONZE(MaterialType.BRONZE, (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 200, 32.0f, 1.5f, 15),
    LEAD(MaterialType.LEAD, (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 16, 3.0f, 3.0f, 21),
    TIN(MaterialType.TIN, (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 15, 10.0f, -1.0f, 16),
    FLINT(MaterialType.FLINT, (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 80, 4.5f, 2.0f, 8),
    ANTLER(MaterialType.ANTLER, (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 50, 5.0f, 0.0f, 1),
    STONE(MaterialType.STONE, ToolMaterial.STONE);

    private static final Map<MaterialType, ToolMaterial> TOOLS;
    public final MaterialType materialType;
    public final ToolMaterial toolMaterial;

    private YTechToolMaterials(MaterialType materialType, ToolMaterial toolMaterial) {
        this.materialType = materialType;
        this.toolMaterial = toolMaterial;
    }

    private YTechToolMaterials(MaterialType materialType, TagKey<Block> incorrectBlocksForDrops, int durability, float speed, float attackDamageBonus, int enchantmentValue) {
        this.materialType = materialType;
        this.toolMaterial = new ToolMaterial(incorrectBlocksForDrops, durability, speed, attackDamageBonus, enchantmentValue, (TagKey)YTechItemTags.INGOTS.get(materialType));
    }

    public static ToolMaterial get(MaterialType type) {
        ToolMaterial material = TOOLS.get(type);
        if (material == null) {
            throw new IllegalStateException("Undefined tool material " + type.key);
        }
        return material;
    }

    static {
        TOOLS = new HashMap<MaterialType, ToolMaterial>();
        for (YTechToolMaterials value : YTechToolMaterials.values()) {
            TOOLS.put(value.materialType, value.toolMaterial);
        }
    }
}

