/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.block.MachineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPrimitiveMachineBlock
extends MachineBlock {
    public AbstractPrimitiveMachineBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops().strength(3.5f).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 13 : 0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.LIT});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false));
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && random.nextInt(10) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
    }

    @Override
    public boolean hasClientTicker() {
        return true;
    }

    @Override
    public boolean hasServerTicker() {
        return true;
    }
}

