/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AqueductConsumerBlock;
import com.yanny.ytech.configuration.block.AqueductHydratorBlock;
import com.yanny.ytech.configuration.block_entity.AqueductFertilizerBlockEntity;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import org.jetbrains.annotations.NotNull;

public class AqueductFertilizerBlock
extends AqueductHydratorBlock {
    public AqueductFertilizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        return new AqueductFertilizerBlockEntity(pos, blockState);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (!level.isClientSide) {
            player.openMenu(Objects.requireNonNull(this.getMenuProvider(state, level, pos)), pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AqueductFertilizerBlockEntity) {
            AqueductFertilizerBlockEntity blockEntity2 = (AqueductFertilizerBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, blockEntity2.getItemStackHandler().getItems());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ResourceLocation fertilizerTexture = Utils.modBlockLoc("aqueduct/aqueduct_fertilizer");
        ResourceLocation valveTexture = Utils.modBlockLoc("aqueduct/aqueduct_valve");
        ResourceLocation bricksTexture = Utils.modBlockLoc("terracotta_bricks");
        ResourceLocation invisibleTexture = Utils.modBlockLoc("invisible");
        ResourceLocation workingTexture = Utils.modBlockLoc("aqueduct/aqueduct_fertilizer_working");
        String name = Utils.getPath(YTechBlocks.AQUEDUCT_FERTILIZER);
        ModelBuilder base = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name)).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#2").cullface(direction);
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).end()).texture("0", fertilizerTexture)).texture("2", bricksTexture)).texture("particle", fertilizerTexture);
        ModelBuilder activated = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_activated")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#2").cullface(direction);
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#4").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).end()).texture("2", bricksTexture)).texture("4", workingTexture)).texture("particle", fertilizerTexture);
        ModelBuilder overlay = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_overlay")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            if (Objects.requireNonNull(direction) == Direction.NORTH) {
                faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1");
            } else {
                faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#3");
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).end()).renderType("minecraft:cutout")).texture("1", valveTexture)).texture("3", invisibleTexture);
        ModelBuilder inventory = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_inventory")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1");
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0");
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).end()).texture("0", fertilizerTexture)).texture("1", valveTexture)).texture("particle", fertilizerTexture);
        MultiPartBlockStateBuilder builder = provider.getMultipartBuilder((Block)YTechBlocks.AQUEDUCT_FERTILIZER.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).addModel()).condition((Property)AqueductConsumerBlock.ACTIVATED, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)activated).addModel()).condition((Property)AqueductConsumerBlock.ACTIVATED, (Comparable[])new Boolean[]{true}).end();
        PROPERTY_BY_DIRECTION.forEach((arg_0, arg_1) -> AqueductFertilizerBlock.lambda$registerModel$4(builder, (ModelFile)overlay, arg_0, arg_1));
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)inventory);
    }

    private static /* synthetic */ void lambda$registerModel$4(MultiPartBlockStateBuilder builder, ModelFile overlay, Direction dir, BooleanProperty value) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(overlay).rotationY(((Integer)ANGLE_BY_DIRECTION.get(dir)).intValue()).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true}).end();
    }
}

