/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.BrickChimneyBlockEntity;
import com.yanny.ytech.registration.YTechBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrickChimneyBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);

    public BrickChimneyBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f, 2.0f));
    }

    public boolean propagatesSkylightDown(@NotNull BlockState blockState) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BrickChimneyBlockEntity(pos, state);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!level.isClientSide && !state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof BrickChimneyBlockEntity) {
            BrickChimneyBlockEntity blockEntity2 = (BrickChimneyBlockEntity)blockEntity;
            blockEntity2.onRemove();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.BRICK_CHIMNEY))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(3.0f, 0.0f, 13.0f, 16.0f).texture("#0");
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#1").cullface(direction);
                }
            }
        }).from(3.0f, 0.0f, 3.0f).to(13.0f, 16.0f, 13.0f).end()).texture("particle", Utils.modBlockLoc("bricks"))).texture("0", Utils.modBlockLoc("bricks"))).texture("1", Utils.modBlockLoc("machine/primitive_smelter_top"));
        provider.getVariantBuilder((Block)YTechBlocks.BRICK_CHIMNEY.get()).forAllStates(arg_0 -> BrickChimneyBlock.lambda$registerModel$1((ModelFile)model, arg_0));
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.BRICK_CHIMNEY))).parent((ModelFile)model);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerModel$1(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }
}

