/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.CraftingWorkspaceBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingWorkspaceBlock
extends Block
implements EntityBlock {
    public static final VoxelShape BOX = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.3333333333333333, (double)0.3333333333333333, (double)0.3333333333333333);
    public static final Map<Integer, VoxelShape> SHAPES = new HashMap<Integer, VoxelShape>(27);
    private static final VoxelShape SHAPE_BASE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
    private static final Map<Integer, VoxelShape> SHAPE_CACHE = Collections.synchronizedMap(new HashMap());

    public CraftingWorkspaceBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f).noOcclusion().noLootTable());
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Optional op = pLevel.getBlockEntity(pPos, (BlockEntityType)YTechBlockEntityTypes.CRAFTING_WORKSPACE.get());
        if (op.isPresent()) {
            int bitmask = ((CraftingWorkspaceBlockEntity)((Object)op.get())).getBitmask();
            return SHAPE_CACHE.computeIfAbsent(bitmask, i -> CraftingWorkspaceBlock.prepareShape(bitmask));
        }
        return SHAPE_BASE;
    }

    @NotNull
    public InteractionResult useItemOn(@NotNull ItemStack itemStack, @NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            Optional op = pLevel.getBlockEntity(pPos, (BlockEntityType)YTechBlockEntityTypes.CRAFTING_WORKSPACE.get());
            if (op.isPresent()) {
                return ((CraftingWorkspaceBlockEntity)((Object)op.get())).use(itemStack, pState, serverLevel, pPos, pPlayer, pHand, pHit);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new CraftingWorkspaceBlockEntity(blockPos, blockState);
    }

    public boolean propagatesSkylightDown(@NotNull BlockState pState) {
        return true;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CraftingWorkspaceBlockEntity) {
            CraftingWorkspaceBlockEntity blockEntity2 = (CraftingWorkspaceBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, blockEntity2.getItems());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public static int getIndex(int @Nullable [] position) {
        if (CraftingWorkspaceBlock.validPosition(position)) {
            return position[1] * 9 + position[2] * 3 + position[0];
        }
        return -1;
    }

    public static int @Nullable [] getPosition(BlockHitResult hit, boolean emptyHand) {
        BlockPos pos = hit.getBlockPos();
        Direction direction = hit.getDirection();
        Vec3 position = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        Vec3i normal = direction.getUnitVec3i();
        int flag = emptyHand ? -1 : 1;
        double eps = 0.16666666666666666;
        int x = (int)Math.floor(position.x * 3.0 + eps * (double)normal.getX() * (double)flag);
        int y = (int)Math.floor(position.y * 3.0 + eps * (double)normal.getY() * (double)flag);
        int z = (int)Math.floor(position.z * 3.0 + eps * (double)normal.getZ() * (double)flag);
        if (x >= 0 && x < 3 && y >= 0 && y < 3 && z >= 0 && z < 3) {
            return new int[]{x, y, z};
        }
        return null;
    }

    public static int @Nullable [] getPosition(int index) {
        if (index >= 0 && index < 27) {
            int y = index / 9;
            int z = (index %= 9) / 3;
            int x = index %= 3;
            return new int[]{x, y, z};
        }
        return null;
    }

    public static boolean validPosition(int @Nullable [] position) {
        return position != null && position[0] >= 0 && position[0] < 3 && position[1] >= 0 && position[1] < 3 && position[2] >= 0 && position[2] < 3;
    }

    private static VoxelShape prepareShape(int bitmask) {
        VoxelShape shape = SHAPE_BASE;
        for (int i = 0; i < 27; ++i) {
            if ((bitmask >> i & 1) != 1) continue;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPES.get(i));
        }
        return shape;
    }

    public static void registerModel(BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.CRAFTING_WORKSPACE))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 1.0f, 1.0f, 4.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(2.0f, 1.0f, 3.0f, 4.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(7.0f, 1.0f, 8.0f, 4.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(3.0f, 5.0f, 4.0f, 8.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 1.0f, 1.0f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(6.0f, 3.0f, 7.0f, 4.0f).texture("#0").cullface(direction);
                }
            }
        }).from(0.25f, 0.0f, 0.25f).to(1.25f, 3.0f, 1.25f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(0.25f, 0.0f, 0.25f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 1.0f, 1.0f, 4.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(2.0f, 1.0f, 3.0f, 4.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(7.0f, 1.0f, 8.0f, 4.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(3.0f, 5.0f, 4.0f, 8.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 1.0f, 1.0f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(6.0f, 3.0f, 7.0f, 4.0f).texture("#0").cullface(direction);
                }
            }
        }).from(14.75f, 0.0f, 0.25f).to(15.75f, 3.0f, 1.25f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(14.75f, 0.0f, 0.25f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 1.0f, 1.0f, 4.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(2.0f, 1.0f, 3.0f, 4.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(7.0f, 1.0f, 8.0f, 4.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(3.0f, 5.0f, 4.0f, 8.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 1.0f, 1.0f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(6.0f, 3.0f, 7.0f, 4.0f).texture("#0").cullface(direction);
                }
            }
        }).from(0.25f, 0.0f, 14.75f).to(1.25f, 3.0f, 15.75f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(0.25f, 0.0f, 14.75f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 1.0f, 1.0f, 4.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(2.0f, 1.0f, 3.0f, 4.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(7.0f, 1.0f, 8.0f, 4.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(3.0f, 5.0f, 4.0f, 8.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 1.0f, 1.0f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(6.0f, 3.0f, 7.0f, 4.0f).texture("#0").cullface(direction);
                }
            }
        }).from(14.75f, 0.0f, 14.75f).to(15.75f, 3.0f, 15.75f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(14.75f, 0.0f, 14.75f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(2.0f, 3.0f, 14.0f, 4.0f).texture("#1");
                }
            }
        }).from(0.75f, 1.75f, 1.25f).to(0.75f, 2.75f, 14.75f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(-0.25f, 0.75f, 1.25f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(2.0f, 3.0f, 14.0f, 4.0f).texture("#1");
                }
            }
        }).from(15.25f, 1.75f, 1.25f).to(15.25f, 2.75f, 14.75f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(14.25f, 0.75f, 1.25f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 3.0f, 14.0f, 4.0f).texture("#1");
                }
            }
        }).from(1.25f, 1.75f, 15.25f).to(14.75f, 2.75f, 15.25f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(1.25f, 0.75f, 14.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 3.0f, 14.0f, 4.0f).texture("#1");
                }
            }
        }).from(1.25f, 1.75f, 0.75f).to(14.75f, 2.75f, 0.75f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(1.25f, 0.75f, -0.5f).end().end()).texture("particle", Utils.modBlockLoc("horizontal_rope"))).texture("0", Utils.mcBlockLoc("oak_planks"))).texture("1", Utils.modBlockLoc("horizontal_rope"));
        provider.getVariantBuilder((Block)YTechBlocks.CRAFTING_WORKSPACE.get()).forAllStates(arg_0 -> CraftingWorkspaceBlock.lambda$registerModel$9((ModelFile)model, arg_0));
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.CRAFTING_WORKSPACE))).parent((ModelFile)model);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerModel$9(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }

    static {
        for (int y = 0; y < 3; ++y) {
            for (int z = 0; z < 3; ++z) {
                for (int x = 0; x < 3; ++x) {
                    SHAPES.put(y * 9 + z * 3 + x, BOX.move((double)x / 3.0, (double)y / 3.0, (double)z / 3.0));
                }
            }
        }
        SHAPE_CACHE.put(0, SHAPE_BASE);
    }
}

