/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.TreeStumpBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;

public class TreeStumpBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_BOTTOM = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    private static final VoxelShape SHAPE_TOP = Shapes.box((double)0.125, (double)0.25, (double)0.125, (double)0.875, (double)1.0, (double)0.875);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_BOTTOM, (VoxelShape)SHAPE_TOP);

    public TreeStumpBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TreeStumpBlockEntity(blockPos, blockState);
    }

    @NotNull
    public InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.getBlockEntity(pos, (BlockEntityType)YTechBlockEntityTypes.TREE_STUMP.get());
        if (optional.isPresent()) {
            return ((TreeStumpBlockEntity)((Object)optional.get())).onUse(state, level, pos, player, hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TreeStumpBlockEntity) {
            TreeStumpBlockEntity treeStumpBlock = (TreeStumpBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)NonNullList.withSize((int)1, (Object)treeStumpBlock.getItem()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.TREE_STUMP))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 4.0f).texture("#1").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 4.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 12.0f, 12.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 2.0f, 14.0f, 14.0f).texture("#3").cullface(direction);
                }
            }
        }).from(2.0f, 4.0f, 2.0f).to(14.0f, 16.0f, 14.0f).end()).texture("particle", Utils.mcBlockLoc("oak_log"))).texture("1", Utils.mcBlockLoc("cobblestone"))).texture("2", Utils.mcBlockLoc("oak_log"))).texture("3", Utils.modBlockLoc("tree_stump_top"));
        provider.simpleBlock((Block)YTechBlocks.TREE_STUMP.get(), (ModelFile)model);
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.TREE_STUMP))).parent((ModelFile)model);
    }
}

