/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.AqueductHydratorBlockEntity;
import com.yanny.ytech.configuration.block_entity.IMenuBlockEntity;
import com.yanny.ytech.configuration.container.AqueductFertilizerMenu;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductFertilizerBlockEntity
extends AqueductHydratorBlockEntity
implements MenuProvider,
IMenuBlockEntity {
    private static final String TAG_FERTILIZER = "fertilizer";
    private static final String TAG_ITEMS = "items";
    @NotNull
    protected final MachineItemStackHandler itemStackHandler = this.createItemStackHandler();
    @NotNull
    protected final ContainerData containerData = this.createContainerData();
    private int fertilizer = 0;

    public AqueductFertilizerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)YTechBlockEntityTypes.AQUEDUCT_FERTILIZER.get()), pos, blockState);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.fertilizer = tag.getInt(TAG_FERTILIZER);
        if (tag.contains(TAG_ITEMS)) {
            this.itemStackHandler.deserializeNBT(provider, tag.getCompound(TAG_ITEMS));
        }
    }

    @Override
    public void tick(@NotNull ServerLevel level) {
        super.tick(level);
        if (this.isHydrating()) {
            int z;
            int y;
            int x;
            BlockPos randomPos;
            if (this.fertilizer == 0 && level.getGameTime() % 20L == 0L) {
                if (this.useFertilizer()) {
                    this.fertilizer = YTechMod.CONFIGURATION.getFertilizerDuration();
                    AqueductFertilizerBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
                }
            } else if (this.fertilizer > 0) {
                --this.fertilizer;
                if (this.fertilizer == 0) {
                    if (this.useFertilizer()) {
                        this.fertilizer = YTechMod.CONFIGURATION.getFertilizerDuration();
                        AqueductFertilizerBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
                    }
                } else {
                    AqueductFertilizerBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
                }
            }
            if (this.fertilizer > 0 && level.random.nextInt(YTechMod.CONFIGURATION.getApplyFertilizerChance()) == 0 && (randomPos = (BlockPos)BlockPos.randomBetweenClosed((RandomSource)level.random, (int)1, (int)((x = this.worldPosition.getX()) - 4), (int)(y = this.worldPosition.getY()), (int)((z = this.worldPosition.getZ()) - 4), (int)(x + 4), (int)y, (int)(z + 4)).iterator().next()) != null) {
                BonemealableBlock bonemealableBlock;
                Block block;
                BlockState state = level.getBlockState(randomPos);
                if (state.getBlock() instanceof FarmBlock) {
                    randomPos = randomPos.above();
                    state = level.getBlockState(randomPos);
                }
                if ((block = state.getBlock()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, randomPos, state) && bonemealableBlock.isBonemealSuccess((Level)level, level.random, randomPos, state)) {
                    bonemealableBlock.performBonemeal(level, level.random, randomPos, state);
                    level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)randomPos.getX() + 0.5, (double)randomPos.getY() + 0.5, (double)randomPos.getZ() + 0.5, 10, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.ytech.aqueduct_fertilizer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return new AqueductFertilizerMenu(pContainerId, pPlayer, this.worldPosition, this.itemStackHandler, this.createContainerData());
    }

    @Override
    @NotNull
    public MachineItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    @Override
    @NotNull
    public MachineItemStackHandler createItemStackHandler() {
        return new MachineItemStackHandler.Builder().addInputSlot(80, 32, (itemStackHandler, slot, itemStack) -> itemStack.is(YTechItemTags.FERTILIZER)).setOnChangeListener(() -> ((AqueductFertilizerBlockEntity)this).setChanged()).build();
    }

    @Override
    @NotNull
    public ContainerData createContainerData() {
        return new SimpleContainerData(0);
    }

    @Override
    public int getDataSize() {
        return this.containerData.getCount();
    }

    public boolean isFertilizing() {
        return this.fertilizer > 0 && this.isHydrating();
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt(TAG_FERTILIZER, this.fertilizer);
        tag.put(TAG_ITEMS, (Tag)this.itemStackHandler.serializeNBT(provider));
    }

    private boolean useFertilizer() {
        return !this.itemStackHandler.extractItem(0, 1, false).isEmpty();
    }
}

