/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.mojang.logging.LogUtils;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.ReinforcedBrickChimneyBlock;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BrickChimneyBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_MASTER_POSITION = "masterPos";
    private static final String TAG_HEIGHT_INDEX = "heightIndex";
    private static final int MAX_HEIGHT = 3;
    @Nullable
    private BlockPos masterPos = null;
    private int heightIndex = -1;

    public BrickChimneyBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.BRICK_CHIMNEY.get(), pos, blockState);
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.masterPos = tag.contains(TAG_MASTER_POSITION) ? Utils.loadBlockPos(tag.getCompound(TAG_MASTER_POSITION)) : null;
        this.heightIndex = tag.contains(TAG_HEIGHT_INDEX) ? tag.getInt(TAG_HEIGHT_INDEX) : -1;
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide && this.masterPos == null) {
            this.setMaster(this.worldPosition.below());
        }
    }

    public void setMaster(@NotNull BlockPos blockPos) {
        if (this.level != null) {
            BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
            if (blockEntity instanceof AbstractPrimitiveMachineBlockEntity) {
                BrickChimneyBlockEntity chimney;
                BlockEntity blockEntity2;
                AbstractPrimitiveMachineBlockEntity primitiveMachine = (AbstractPrimitiveMachineBlockEntity)blockEntity;
                int height = -1;
                if (blockPos.equals((Object)this.worldPosition.below())) {
                    height = 3;
                } else {
                    blockEntity2 = this.level.getBlockEntity(this.worldPosition.below());
                    if (blockEntity2 instanceof BrickChimneyBlockEntity) {
                        chimney = (BrickChimneyBlockEntity)blockEntity2;
                        height = chimney.getNextHeight(this.getBlockState().getBlock() instanceof ReinforcedBrickChimneyBlock);
                    } else {
                        LOGGER.warn("Cannot get chimney height index, should not happen! At {}, master at {}", (Object)this.worldPosition, (Object)blockPos);
                    }
                }
                if (height == -1) {
                    this.removeBlock();
                } else {
                    this.registerChimney(this.level, blockPos, primitiveMachine, height);
                    blockEntity2 = this.level.getBlockEntity(this.worldPosition.above());
                    if (blockEntity2 instanceof BrickChimneyBlockEntity) {
                        chimney = (BrickChimneyBlockEntity)blockEntity2;
                        chimney.setMaster(blockPos);
                    }
                }
            } else {
                blockEntity = this.level.getBlockEntity(blockPos);
                if (blockEntity instanceof BrickChimneyBlockEntity) {
                    BrickChimneyBlockEntity blockEntity3 = (BrickChimneyBlockEntity)blockEntity;
                    if (blockEntity3.masterPos != null) {
                        this.setMaster(blockEntity3.masterPos);
                    }
                }
            }
        }
    }

    public void onRemove() {
        BlockEntity blockEntity;
        if (this.level != null && this.masterPos != null && (blockEntity = this.level.getBlockEntity(this.masterPos)) instanceof AbstractPrimitiveMachineBlockEntity) {
            AbstractPrimitiveMachineBlockEntity primitiveMachine = (AbstractPrimitiveMachineBlockEntity)blockEntity;
            this.masterPos = null;
            this.heightIndex = -1;
            primitiveMachine.chimneyRemoved();
            BrickChimneyBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
            BlockEntity blockEntity2 = this.level.getBlockEntity(this.worldPosition.above());
            if (blockEntity2 instanceof BrickChimneyBlockEntity) {
                BrickChimneyBlockEntity chimney = (BrickChimneyBlockEntity)blockEntity2;
                chimney.onRemove();
            }
        }
    }

    public void removeBlock() {
        if (this.level != null) {
            this.level.destroyBlock(this.worldPosition, true);
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.above());
            if (blockEntity instanceof BrickChimneyBlockEntity) {
                BrickChimneyBlockEntity chimney = (BrickChimneyBlockEntity)blockEntity;
                chimney.removeBlock();
            }
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.masterPos != null) {
            tag.put(TAG_MASTER_POSITION, (Tag)Utils.saveBlockPos(this.masterPos));
        }
        tag.putInt(TAG_HEIGHT_INDEX, this.heightIndex);
    }

    private int getNextHeight(boolean isReinforced) {
        if (this.heightIndex == -1) {
            return -1;
        }
        if (this.getBlockState().getBlock() instanceof ReinforcedBrickChimneyBlock) {
            if (this.heightIndex > 0) {
                if (isReinforced) {
                    return this.heightIndex - 1;
                }
                return 3;
            }
            if (isReinforced) {
                return -1;
            }
            return 3;
        }
        if (isReinforced) {
            return -1;
        }
        if (this.heightIndex > 0) {
            return this.heightIndex - 1;
        }
        return -1;
    }

    private void registerChimney(@NotNull Level level, @NotNull BlockPos masterPos, @NotNull AbstractPrimitiveMachineBlockEntity primitiveMachine, int height) {
        this.masterPos = masterPos;
        this.heightIndex = height;
        primitiveMachine.chimneyAdded();
        BrickChimneyBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
    }
}

