/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.recipe.WorkspaceCraftingRecipe;
import com.yanny.ytech.configuration.recipe.YTechRecipeInput;
import com.yanny.ytech.configuration.renderer.FakeCraftingWorkspaceLevel;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class CraftingWorkspaceBlockEntity
extends BlockEntity {
    private static final FakeCraftingWorkspaceLevel FAKE_LEVEL;
    private static final String TAG_BITMASK = "bitmask";
    private static final String TAG_ITEMS = "items";
    private static final String TAG_BLOCK_STATES = "blockStates";
    private final NonNullList<ItemStack> itemList = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final NonNullList<BlockState> blockStates = NonNullList.withSize((int)27, (Object)Blocks.AIR.defaultBlockState());
    private int bitmask = 0;

    public CraftingWorkspaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.CRAFTING_WORKSPACE.get(), pPos, pBlockState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult use(@NotNull ItemStack itemStack, @NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        int[] pos = CraftingWorkspaceBlock.getPosition(pHit, itemStack.isEmpty());
        if (pos == null) return this.constructBlock(itemStack, pLevel, pPos, pPlayer, pHand, pHit) ? InteractionResult.CONSUME : InteractionResult.PASS;
        int index = CraftingWorkspaceBlock.getIndex(pos);
        BlockPos fakePos = new BlockPos(pos[0] + 1, pos[1] + 1, pos[2] + 1);
        if ((this.bitmask >> index & 1) == 0 && !itemStack.isEmpty()) {
            this.bitmask |= 1 << index;
            if (this.constructBlock(itemStack, pLevel, pPos, pPlayer, pHand, pHit)) return InteractionResult.CONSUME;
            BlockHitResult hit = new BlockHitResult(pHit.getLocation(), pHit.getDirection(), fakePos, true);
            FAKE_LEVEL.setData(pPos, (Level)pLevel, this.itemList, this.blockStates);
            Item item = itemStack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.getBlock();
                BlockState state = block.getStateForPlacement(new BlockPlaceContext((Level)FAKE_LEVEL, pPlayer, pHand, itemStack, hit));
                if (state == null) {
                    state = block.defaultBlockState();
                }
                this.blockStates.set(index, (Object)state);
                this.updateNeighbors(state, pos, fakePos);
            } else {
                block = itemStack.getItem();
                if (block instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)block;
                    BlockState state = bucket.content.defaultFluidState().createLegacyBlock();
                    this.blockStates.set(index, (Object)state);
                    this.updateNeighbors(state, pos, fakePos);
                }
            }
            FAKE_LEVEL.clearData();
            this.itemList.set(index, (Object)itemStack.split(1));
        } else {
            if ((this.bitmask >> index & 1) != 1 || !itemStack.isEmpty()) return this.constructBlock(itemStack, pLevel, pPos, pPlayer, pHand, pHit) ? InteractionResult.CONSUME : InteractionResult.PASS;
            Block.popResourceFromFace((Level)pLevel, (BlockPos)pPos, (Direction)pHit.getDirection(), (ItemStack)((ItemStack)this.itemList.get(index)));
            FAKE_LEVEL.setData(pPos, (Level)pLevel, this.itemList, this.blockStates);
            this.blockStates.set(index, (Object)Blocks.AIR.defaultBlockState());
            this.updateNeighbors(Blocks.AIR.defaultBlockState(), pos, fakePos);
            FAKE_LEVEL.clearData();
            this.itemList.set(index, (Object)ItemStack.EMPTY);
            this.bitmask &= ~(1 << index);
        }
        pLevel.sendBlockUpdated(pPos, pState, pState, 3);
        pLevel.blockEntityChanged(pPos);
        return InteractionResult.CONSUME;
    }

    public int getBitmask() {
        return this.bitmask;
    }

    public NonNullList<ItemStack> getItems() {
        return this.itemList;
    }

    public NonNullList<BlockState> getBlockStates() {
        return this.blockStates;
    }

    public void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pProvider) {
        super.loadAdditional(pTag, pProvider);
        this.bitmask = pTag.getInt(TAG_BITMASK);
        ListTag list = pTag.getList(TAG_ITEMS, 10);
        ListTag states = pTag.getList(TAG_BLOCK_STATES, 10);
        for (int i = 0; i < 27; ++i) {
            this.itemList.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)pProvider, (CompoundTag)list.getCompound(i)));
            this.blockStates.set(i, (Object)NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK, (CompoundTag)states.getCompound(i)));
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pProvider) {
        super.saveAdditional(pTag, pProvider);
        pTag.putInt(TAG_BITMASK, this.bitmask);
        ListTag list = new ListTag();
        ListTag states = new ListTag();
        for (int i = 0; i < 27; ++i) {
            list.add(i, ((ItemStack)this.itemList.get(i)).saveOptional(pProvider));
            states.add(i, (Tag)NbtUtils.writeBlockState((BlockState)((BlockState)this.blockStates.get(i))));
        }
        pTag.put(TAG_ITEMS, (Tag)list);
        pTag.put(TAG_BLOCK_STATES, (Tag)states);
    }

    private boolean constructBlock(@NotNull ItemStack itemStack, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        YTechRecipeInput container = new YTechRecipeInput((ItemStack[])this.itemList.toArray(ItemStack[]::new));
        Optional op = pLevel.recipeAccess().getRecipeFor((RecipeType)YTechRecipeTypes.WORKSPACE_CRAFTING.get(), (RecipeInput)container, (Level)pLevel);
        if (op.isPresent() && ((WorkspaceCraftingRecipe)((RecipeHolder)op.get()).value()).tool().test(itemStack)) {
            BlockItem item = (BlockItem)((WorkspaceCraftingRecipe)((RecipeHolder)op.get()).value()).assemble(container, (HolderLookup.Provider)pLevel.registryAccess()).getItem();
            BlockState blockState = item.getBlock().getStateForPlacement(new BlockPlaceContext(pPlayer, pHand, ItemStack.EMPTY, pHit));
            if (blockState == null) {
                blockState = item.getBlock().defaultBlockState();
            }
            this.itemList.clear();
            pLevel.setBlock(pPos, blockState, 3);
            pLevel.blockEntityChanged(pPos);
            pLevel.playSound(null, pPos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, 200, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            itemStack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            return true;
        }
        return false;
    }

    private void updateNeighbors(BlockState state, int[] pos, BlockPos fakePos) {
        for (Direction value : Direction.values()) {
            int neighborIndex;
            int[] neighborPos = new int[]{pos[0] + value.getUnitVec3i().getX(), pos[1] + value.getUnitVec3i().getY(), pos[2] + value.getUnitVec3i().getZ()};
            if (!CraftingWorkspaceBlock.validPosition(neighborPos) || (neighborIndex = CraftingWorkspaceBlock.getIndex(neighborPos)) < 0 || neighborIndex >= 27 || !(((ItemStack)this.itemList.get(neighborIndex)).getItem() instanceof BlockItem)) continue;
            this.blockStates.set(neighborIndex, (Object)((BlockState)this.blockStates.get(neighborIndex)).updateShape((LevelReader)this.level, null, fakePos.offset(value.getUnitVec3i()), value.getOpposite(), fakePos, state, this.level.random));
        }
    }

    static {
        ObjenesisStd objenesis = new ObjenesisStd();
        ObjectInstantiator instantiator = objenesis.getInstantiatorOf(FakeCraftingWorkspaceLevel.class);
        FAKE_LEVEL = (FakeCraftingWorkspaceLevel)((Object)instantiator.newInstance());
        FAKE_LEVEL.init();
    }
}

