/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block_entity.SimpleProgressHandler;
import com.yanny.ytech.configuration.recipe.DryingRecipe;
import com.yanny.ytech.registration.YTechBiomeTags;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class DryingRackBlockEntity
extends BlockEntity
implements BlockEntityTicker<DryingRackBlockEntity> {
    private final SimpleProgressHandler<SingleRecipeInput, DryingRecipe> progressHandler = new SimpleProgressHandler((RecipeType)YTechRecipeTypes.DRYING.get());

    public DryingRackBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.DRYING_RACK.get(), pos, blockState);
    }

    public int getProgress() {
        return this.progressHandler.getProgress();
    }

    public ItemStack getItem() {
        return this.progressHandler.getItem();
    }

    public InteractionResult onUse(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack holdingItemStack = player.getItemInHand(hand);
            if (this.progressHandler.isEmpty()) {
                this.progressHandler.setupCrafting(serverLevel, holdingItemStack, DryingRecipe::dryingTime, SingleRecipeInput::new);
            } else {
                Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)hitResult.getDirection(), (ItemStack)this.progressHandler.getItem());
                this.progressHandler.clear();
            }
            level.sendBlockUpdated(pos, state, state, 3);
            level.blockEntityChanged(pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull DryingRackBlockEntity blockEntity) {
        BiConsumer<SingleRecipeInput, DryingRecipe> onFinish;
        Function<DryingRecipe, Float> getStep;
        Function<DryingRecipe, Boolean> canProcess;
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && this.progressHandler.tick(serverLevel = (ServerLevel)level, canProcess = recipe -> !level.isRaining() || !YTechMod.CONFIGURATION.noDryingDuringRain(), getStep = recipe -> {
            Holder biome = level.getBiome(pos);
            if (biome.is(YTechBiomeTags.SLOW_DRYING_BIOMES)) {
                return Float.valueOf(0.5f);
            }
            if (biome.is(YTechBiomeTags.FAST_DRYING_BIOMES)) {
                return Float.valueOf(2.0f);
            }
            return Float.valueOf(1.0f);
        }, onFinish = (container, recipe) -> {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)recipe.assemble((SingleRecipeInput)container, (HolderLookup.Provider)level.registryAccess()));
            level.sendBlockUpdated(pos, state, state, 3);
            level.blockEntityChanged(pos);
        }, SingleRecipeInput::new)) {
            DryingRackBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.progressHandler.load(tag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.progressHandler.save(tag, provider);
    }
}

