/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.network.irrigation.IIrrigationBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class IrrigationBlockEntity
extends BlockEntity
implements IIrrigationBlockEntity {
    private static final String NETWORK_ID = "networkId";
    @NotNull
    private final List<BlockPos> validNeighbors;
    protected int networkId = -1;

    public IrrigationBlockEntity(@NotNull BlockEntityType<? extends BlockEntity> entityType, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull List<BlockPos> validNeighbors) {
        super(entityType, pos, blockState);
        this.validNeighbors = validNeighbors;
    }

    @Override
    public int getNetworkId() {
        return this.networkId;
    }

    @Override
    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Override
    @NotNull
    public List<BlockPos> getValidNeighbors() {
        return this.validNeighbors;
    }

    @Override
    public void onRemove() {
        if (this.level != null && !this.level.isClientSide) {
            YTechMod.IRRIGATION_PROPAGATOR.server().remove(this);
            this.setChanged();
        }
    }

    @Override
    public void onChangedState(@NotNull BlockState oldBlockState, @NotNull BlockState newBlockState) {
        if (!oldBlockState.equals(newBlockState)) {
            this.setChanged();
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(NETWORK_ID)) {
            this.networkId = tag.getInt(NETWORK_ID);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide) {
            this.onLevelSet((ServerLevel)this.level);
            if (this.networkId < 0) {
                YTechMod.IRRIGATION_PROPAGATOR.server().add(this);
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
                this.setChanged();
            }
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt(NETWORK_ID, this.networkId);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.networkId = tag.getInt(NETWORK_ID);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void onLevelSet(@NotNull ServerLevel level) {
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt(NETWORK_ID, this.networkId);
    }
}

