/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.container;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.IMenuBlockEntity;
import com.yanny.ytech.configuration.container.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class MachineContainerMenu<T extends AbstractContainerMenu>
extends AbstractContainerMenu {
    protected final BlockPos pos;
    @NotNull
    protected final ItemStackHandler itemStackHandler;
    @NotNull
    protected final IMenuBlockEntity blockEntity;
    @NotNull
    protected final ContainerData containerData;
    private final int inputSlots;

    public MachineContainerMenu(MenuType<T> menuType, int windowId, @NotNull Player player, @NotNull BlockPos pos, @NotNull MachineItemStackHandler itemStackHandler, @NotNull ContainerData data) {
        super(menuType, windowId);
        this.pos = pos;
        this.containerData = data;
        this.blockEntity = Utils.getMachineBlockEntity(player, pos);
        this.itemStackHandler = itemStackHandler;
        this.inputSlots = itemStackHandler.getInputSlots();
        for (int index = 0; index < itemStackHandler.getSlots(); ++index) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemStackHandler, index, itemStackHandler.getX(index), itemStackHandler.getY(index)));
        }
        Utils.layoutPlayerInventorySlots(x$0 -> this.addSlot((Slot)x$0), (Container)player.getInventory(), 8, 84);
        this.addDataSlots(data);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack quickMovedStack = ItemStack.EMPTY;
        Slot quickMovedSlot = (Slot)this.slots.get(index);
        int slotCount = this.itemStackHandler.getSlots();
        if (quickMovedSlot.hasItem()) {
            ItemStack stack = quickMovedSlot.getItem();
            quickMovedStack = stack.copy();
            if (index < slotCount ? !this.moveItemStackTo(stack, slotCount, 36 + slotCount, true) : !this.moveItemStackTo(stack, 0, this.inputSlots, false) && (index < 27 + slotCount ? !this.moveItemStackTo(stack, 27 + slotCount, 36 + slotCount, false) : index < 36 + slotCount && !this.moveItemStackTo(stack, slotCount, 27 + slotCount, false))) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                quickMovedSlot.set(ItemStack.EMPTY);
            } else {
                quickMovedSlot.setChanged();
            }
            if (stack.getCount() == quickMovedStack.getCount()) {
                return ItemStack.EMPTY;
            }
            quickMovedSlot.onTake(player, stack);
        }
        return quickMovedStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return MachineContainerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.pos), (Player)player, (Block)player.level().getBlockState(this.pos).getBlock());
    }

    @NotNull
    public IMenuBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

