/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ArrowEntity
extends AbstractArrow {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_EFFECT_COLOR = -1;
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.defineId(ArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final byte EVENT_POTION_PUFF = 0;
    private PotionContents potionContents = PotionContents.EMPTY;

    public ArrowEntity(@NotNull Level level, @NotNull LivingEntity shooter, @NotNull Item arrowType, @Nullable ItemStack source) {
        super(EntityType.ARROW, shooter, level, arrowType.getDefaultInstance(), source);
        this.updateColor();
    }

    private PotionContents getPotionContents() {
        return this.potionContents;
    }

    private void setPotionContents(PotionContents contents) {
        this.potionContents = contents;
        this.updateColor();
    }

    protected void setPickupItemStack(@NotNull ItemStack stack) {
        super.setPickupItemStack(stack);
        this.updateColor();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_EFFECT_COLOR, (Object)-1);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.isInGround()) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("effect", (Tag)Objects.requireNonNull(DataComponents.POTION_CONTENTS.codec()).encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.potionContents).getOrThrow());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("effect")) {
            this.setPotionContents(Objects.requireNonNull(DataComponents.POTION_CONTENTS.codec()).parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("effect")).resultOrPartial(p_330102_ -> LOGGER.error("Tried to load invalid item: '{}'", p_330102_)).orElse(PotionContents.EMPTY));
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                float d0 = (float)(i >> 16 & 0xFF) / 255.0f;
                float d1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float d2 = (float)(i & 0xFF) / 255.0f;
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)d0, (float)d1, (float)d2), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), (double)d0, (double)d1, (double)d2);
                }
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(ID_EFFECT_COLOR);
    }

    public void addEffect(@NotNull MobEffectInstance mobEffectInstance) {
        this.setPotionContents(this.getPotionContents().withEffectAdded(mobEffectInstance));
    }

    protected void doPostHurtEffects(@NotNull LivingEntity living) {
        super.doPostHurtEffects(living);
        Entity entity = this.getEffectSource();
        PotionContents potionContents = this.getPotionContents();
        if (potionContents.potion().isPresent()) {
            for (MobEffectInstance mobEffectInstance : ((Potion)((Holder)potionContents.potion().get()).value()).getEffects()) {
                living.addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), Math.max(mobEffectInstance.mapDuration(duration -> duration / 8), 1), mobEffectInstance.getAmplifier(), mobEffectInstance.isAmbient(), mobEffectInstance.isVisible()), entity);
            }
        }
        for (MobEffectInstance mobEffectInstance : potionContents.customEffects()) {
            living.addEffect(mobEffectInstance, entity);
        }
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return this.getPickupItemStackOrigin();
    }

    private void updateColor() {
        PotionContents potioncontents = this.getPotionContents();
        this.entityData.set(ID_EFFECT_COLOR, (Object)(potioncontents.equals((Object)PotionContents.EMPTY) ? -1 : potioncontents.getColor()));
    }

    private void makeParticle(int particleAmount) {
        int i = this.getColor();
        if (i != -1 && particleAmount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < particleAmount; ++j) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)i), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), d0, d1, d2);
            }
        }
    }
}

