/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.goal.GoAround;
import com.yanny.ytech.registration.YTechEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoAroundEntity
extends Mob
implements IEntityWithComplexSpawn {
    @NotNull
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private BlockPos position = null;
    @Nullable
    private MillstoneBlockEntity millstoneBlockEntity;

    public GoAroundEntity(EntityType<GoAroundEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
    }

    public GoAroundEntity(@NotNull Mob mob, @NotNull BlockPos position, @NotNull Level level) {
        super((EntityType)YTechEntityTypes.GO_AROUND.get(), level);
        this.position = position;
        this.millstoneBlockEntity = (MillstoneBlockEntity)this.level().getBlockEntity(position);
        this.setPos(mob.getX(), mob.getY(), mob.getZ());
        this.setXRot(mob.getXRot());
        this.setYRot(mob.getYRot());
        this.setYHeadRot(mob.getYHeadRot());
        this.setYBodyRot(mob.getVisualRotationYInDegrees());
        this.setPose(mob.getPose());
        this.leashToMillstone();
        this.registerGoals();
    }

    protected void registerGoals() {
        if (!this.level().isClientSide && this.position != null) {
            this.goalSelector.removeAllGoals(goal -> true);
            this.goalSelector.addGoal(0, (Goal)new GoAround(this, this.position.getCenter()));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 1.0);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (this.position != null) {
            pCompound.putInt("pX", this.position.getX());
            pCompound.putInt("pY", this.position.getY());
            pCompound.putInt("pZ", this.position.getZ());
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("pX") && pCompound.contains("pY") && pCompound.contains("pZ")) {
            this.position = new BlockPos(pCompound.getInt("pX"), pCompound.getInt("pY"), pCompound.getInt("pZ"));
            this.registerGoals();
        }
    }

    public boolean startRiding(@NotNull Entity entity, boolean pForce) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.navigation = new FixedGroundPathNavigation(mob, mob.level());
        } else {
            LOGGER.warn("Failed to start riding entity (not a Mob): {}", (Object)entity);
        }
        return super.startRiding(entity, pForce);
    }

    public void stopRiding() {
        super.stopRiding();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getRemovalReason() == null) {
                if (this.millstoneBlockEntity != null) {
                    this.millstoneBlockEntity.removeLeash();
                } else {
                    LOGGER.warn("Failed to remove BE because is NULL");
                }
                this.remove(Entity.RemovalReason.DISCARDED);
                this.spawnAtLocation(serverLevel, (ItemLike)Items.LEAD);
            }
        }
    }

    public void tick() {
        if (this.millstoneBlockEntity == null) {
            this.leashToMillstone();
        }
        super.tick();
    }

    public void rideTick() {
        Entity vehicle = this.getVehicle();
        super.rideTick();
        if (vehicle != null) {
            this.yBodyRot = vehicle.getVisualRotationYInDegrees();
        }
    }

    @Nullable
    public MillstoneBlockEntity getDevice() {
        return this.millstoneBlockEntity;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(this.position != null);
        if (this.position != null) {
            friendlyByteBuf.writeInt(this.position.getX());
            friendlyByteBuf.writeInt(this.position.getY());
            friendlyByteBuf.writeInt(this.position.getZ());
        } else {
            LOGGER.warn("Sending spawn packet without position!");
        }
    }

    public void readSpawnData(RegistryFriendlyByteBuf friendlyByteBuf) {
        if (friendlyByteBuf.readBoolean()) {
            this.position = new BlockPos(friendlyByteBuf.readInt(), friendlyByteBuf.readInt(), friendlyByteBuf.readInt());
        } else {
            LOGGER.warn("Received spawn packet without position!");
        }
    }

    private void leashToMillstone() {
        if (this.position != null) {
            this.millstoneBlockEntity = (MillstoneBlockEntity)this.level().getBlockEntity(this.position);
            if (this.millstoneBlockEntity != null) {
                this.millstoneBlockEntity.setLeashed(this);
            } else {
                LOGGER.warn("Failed to load BE at {}", (Object)this.position);
            }
        } else {
            LOGGER.warn("NULL position!");
        }
    }

    static class FixedGroundPathNavigation
    extends GroundPathNavigation {
        public FixedGroundPathNavigation(Mob pMob, Level pLevel) {
            super(pMob, pLevel);
        }

        protected void doStuckDetection(@NotNull Vec3 pPositionVec3) {
            if (this.tick - this.lastStuckCheck > 100) {
                float f = this.mob.getSpeed() >= 1.0f ? this.mob.getSpeed() : this.mob.getSpeed() * this.mob.getSpeed();
                float f1 = f * 100.0f * 0.25f;
                if (pPositionVec3.distanceToSqr(this.lastStuckCheckPos) < (double)(f1 * f1)) {
                    this.isStuck = true;
                    this.stop();
                } else {
                    this.isStuck = false;
                }
                this.lastStuckCheck = this.tick;
                this.lastStuckCheckPos = pPositionVec3;
            }
            if (this.path != null && !this.path.isDone()) {
                BlockPos vec3i = this.path.getNextNodePos();
                long i = this.level.getGameTime();
                if (vec3i.equals((Object)this.timeoutCachedNode)) {
                    this.timeoutTimer += i - this.lastTimeoutCheck;
                } else {
                    this.timeoutCachedNode = vec3i;
                    double d0 = pPositionVec3.distanceTo(Vec3.atBottomCenterOf((Vec3i)this.timeoutCachedNode));
                    this.timeoutLimit = this.mob.getSpeed() > 0.0f ? d0 / (double)this.mob.getSpeed() * 20.0 : 0.0;
                    this.timeoutTimer = 0L;
                }
                if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                    this.timeoutPath();
                }
                this.lastTimeoutCheck = i;
            }
        }
    }
}

