/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.goal;

import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.entity.GoAroundEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoAround
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double STEP = 0.19634954084936207;
    private static final int RADIUS = 3;
    @NotNull
    GoAroundEntity mob;
    Vec3 pos;

    public GoAround(@NotNull GoAroundEntity mob, Vec3 pos) {
        this.pos = pos;
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        MillstoneBlockEntity blockEntity = this.mob.getDevice();
        if (blockEntity != null) {
            return blockEntity.isMilling();
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone() && this.mob.isAlive() && this.mob.getDevice() != null && this.mob.getDevice().isMilling();
    }

    public void start() {
        Path path = this.mob.getNavigation().getPath();
        if ((path == null || path.isDone()) && !this.mob.getNavigation().moveTo(this.createPath(), 1.0)) {
            LOGGER.warn("Failed to create path!");
        }
    }

    public void stop() {
        MillstoneBlockEntity millstoneBlockEntity;
        super.stop();
        Entity entity = this.mob.getVehicle();
        if (entity instanceof Mob) {
            Mob mobVehicle = (Mob)entity;
            mobVehicle.navigation.stop();
        }
        if ((millstoneBlockEntity = this.mob.getDevice()) != null) {
            this.mob.getDevice().onFinished();
        }
    }

    private Path createPath() {
        BlockPos startingPos = null;
        Vec3 mobPos = this.mob.getOnPos().getCenter();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(17);
        for (double angle = 0.0; angle < 6.4795348480289485; angle += 0.19634954084936207) {
            double x = this.pos.x + 3.0 * Math.cos(angle);
            double y = this.pos.y;
            double z = this.pos.z + 3.0 * Math.sin(angle);
            BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
            if (startingPos == null || startingPos.distToCenterSqr((Position)mobPos) > blockPos.distToCenterSqr((Position)mobPos)) {
                startingPos = blockPos;
            }
            if (posList.contains(blockPos)) continue;
            posList.add(blockPos);
        }
        int index = posList.indexOf(startingPos);
        Stream ordered = Stream.concat(posList.subList(index, posList.size()).stream(), posList.subList(0, index).stream());
        return new SamePathIsFine(ordered.map(n -> new Node(n.getX(), n.getY(), n.getZ())).toList(), startingPos, true);
    }

    static class SamePathIsFine
    extends Path {
        public SamePathIsFine(List<Node> pNodes, BlockPos pTarget, boolean pReached) {
            super(pNodes, pTarget, pReached);
        }

        public boolean sameAs(@Nullable Path path) {
            return false;
        }
    }
}

