/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.item;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.YTechToolMaterials;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class ToolItem
extends Item {
    private ToolItem(Item.Properties properties) {
        super(properties);
    }

    public static Item tool(MaterialType materialType, Item.Properties properties) {
        properties = YTechToolMaterials.get(materialType).applyCommonProperties(properties);
        properties = properties.component(DataComponents.TOOL, (Object)new Tool(List.of(), 1.0f, 1));
        return new ToolItem(properties);
    }

    public static Item toolAndWeapon(MaterialType materialType, Item.Properties properties) {
        ToolMaterial toolMaterial = YTechToolMaterials.get(materialType);
        properties = toolMaterial.applyCommonProperties(properties);
        properties = properties.component(DataComponents.TOOL, (Object)new Tool(List.of(), 1.0f, 1));
        properties = properties.attributes(toolMaterial.createToolAttributes(0.0f, 4.0f));
        return new ToolItem(properties);
    }

    public boolean canAttackBlock(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, Player player) {
        return !player.isCreative();
    }

    public boolean hurtEnemy(@NotNull ItemStack itemStack, @NotNull LivingEntity entity, @NotNull LivingEntity other) {
        return true;
    }

    public void postHurtEnemy(ItemStack itemStack, @NotNull LivingEntity entity, @NotNull LivingEntity other) {
        itemStack.hurtAndBreak(1, other, EquipmentSlot.MAINHAND);
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(itemAbility);
    }
}

