/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.yanny.ytech.configuration.Utils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.ChickenRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FowlModel
extends EntityModel<ChickenRenderState> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("fowl"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart l_wing;
    @NotNull
    private final ModelPart r_wing;
    @NotNull
    private final ModelPart l_foot;
    @NotNull
    private final ModelPart r_foot;

    public FowlModel(@NotNull ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.l_wing = root.getChild("l_wing");
        this.r_wing = root.getChild("r_wing");
        this.l_foot = root.getChild("l_foot");
        this.r_foot = root.getChild("r_foot");
    }

    public void setupAnim(@NotNull ChickenRenderState state) {
        super.setupAnim((EntityRenderState)state);
        float f = (Mth.sin((float)state.flap) + 1.0f) * state.flapSpeed;
        this.head.xRot = state.xRot * ((float)Math.PI / 180);
        this.head.yRot = state.yRot * ((float)Math.PI / 180);
        float f1 = state.walkAnimationSpeed;
        float f2 = state.walkAnimationPos;
        this.r_foot.xRot = Mth.cos((float)(f2 * 0.6662f)) * 1.4f * f1;
        this.l_foot.xRot = Mth.cos((float)(f2 * 0.6662f + (float)Math.PI)) * 1.4f * f1;
        this.r_wing.zRot = f;
        this.l_wing.zRot = -f;
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -11.0f, -4.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(14, 15).addBox(-2.0f, -5.0f, -2.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -3.0f, -4.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("l_wing", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, 0.0f, -3.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("r_wing", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("l_foot", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-3, 5).addBox(-1.0f, 5.0f, -2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)19.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("r_foot", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-3, 5).addBox(-2.0f, 5.0f, -2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }
}

