/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.yanny.ytech.configuration.Utils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WoollyMammothModel
extends EntityModel<LivingEntityRenderState> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("woolly_mammoth"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart fl_foot;
    @NotNull
    private final ModelPart bl_foot;
    @NotNull
    private final ModelPart fr_foot;
    @NotNull
    private final ModelPart br_foot;

    public WoollyMammothModel(@NotNull ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.fl_foot = root.getChild("fl_foot");
        this.bl_foot = root.getChild("bl_foot");
        this.fr_foot = root.getChild("fr_foot");
        this.br_foot = root.getChild("br_foot");
    }

    public void setupAnim(@NotNull LivingEntityRenderState state) {
        super.setupAnim((EntityRenderState)state);
        this.head.xRot = state.xRot * ((float)Math.PI / 180);
        this.head.yRot = state.yRot * ((float)Math.PI / 180);
        float pLimbSwing = state.walkAnimationPos;
        float pLimbSwingAmount = state.walkAnimationSpeed;
        this.fl_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.bl_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.fr_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.br_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(66, 0).addBox(-8.0f, -30.0f, 7.0f, 16.0f, 18.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-8.0f, -32.0f, -10.0f, 16.0f, 20.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("fl_foot", CubeListBuilder.create().texOffs(61, 32).addBox(-3.0f, 0.0f, -2.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)12.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("fr_foot", CubeListBuilder.create().texOffs(61, 32).addBox(-3.0f, 0.0f, -2.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)12.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("bl_foot", CubeListBuilder.create().texOffs(61, 32).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)12.0f, (float)17.0f));
        partdefinition.addOrReplaceChild("br_foot", CubeListBuilder.create().texOffs(61, 32).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)12.0f, (float)17.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(86, 31).addBox(-5.0f, -5.0f, -9.0f, 10.0f, 14.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)-10.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -18.0f, -22.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)28.0f, (float)10.0f));
        nose.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(14, 38).addBox(-3.0f, -6.0f, -2.5f, 6.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-21.0f, (float)-18.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        nose.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(50, 0).addBox(-1.5f, -4.0f, 0.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.5f, (float)-20.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition tusks = head.addOrReplaceChild("tusks", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)28.0f, (float)10.0f));
        tusks.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 37).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)-24.0f, (float)-17.5f, (float)-0.3491f, (float)0.0f, (float)0.3491f));
        tusks.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(63, 2).addBox(-1.0f, 1.5f, 7.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)-17.5f, (float)-20.0f, (float)-2.618f, (float)0.0f, (float)0.3491f));
        tusks.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(68, 2).addBox(-1.5f, 2.5f, 2.25f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)-17.5f, (float)-20.0f, (float)-1.7017f, (float)0.0f, (float)0.3491f));
        tusks.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(68, 2).addBox(-1.5f, -1.25f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)-17.5f, (float)-20.0f, (float)-0.8727f, (float)0.0f, (float)0.3491f));
        tusks.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(63, 2).addBox(0.0f, 1.5f, 7.25f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-17.5f, (float)-20.0f, (float)-2.618f, (float)0.0f, (float)-0.3491f));
        tusks.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(68, 2).addBox(-0.5f, 2.5f, 2.25f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-17.5f, (float)-20.0f, (float)-1.7017f, (float)0.0f, (float)-0.3491f));
        tusks.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(68, 2).addBox(-0.5f, -1.25f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-17.5f, (float)-20.0f, (float)-0.8727f, (float)0.0f, (float)-0.3491f));
        tusks.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(0, 37).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-24.0f, (float)-17.5f, (float)-0.3491f, (float)0.0f, (float)-0.3491f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }
}

